/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.tcp.TCPService;
import com.ur.polyscope.urcaps.URCapErrorHandler;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.safety.urcapcontribution.SafetyContribution;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyCreationContext;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.urcap.contribution.installation.InstallationContributionWithIcon;
import com.ur.urcap.contribution.installation.NullFeatureService;
import com.ur.urcap.contribution.installation.NullTCPService;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

abstract class AbstractInstallationContribution
implements InstallationContributionWithIcon {
    private static final JPanel DEFAULT_PANEL = new JPanel();
    protected JComponent component = DEFAULT_PANEL;
    protected InstallationNodeContribution installationNodeContribution;
    protected final ExceptionHandling exceptionHandling;
    protected final URCapErrorHandler urCapErrorHandler;
    protected TCPService tcpService = new NullTCPService();
    protected FeatureService featureService = new NullFeatureService();
    private InstallationLoadingContext installationLoadingContext;
    private final ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper;
    private boolean viewOpened = false;
    private SafetyContribution safetyContribution;

    static {
        DEFAULT_PANEL.add(new JLabel("URCap failed to contribute a view"));
    }

    AbstractInstallationContribution(ExceptionHandling exceptionHandling, InstallationLoadingContext installationLoadingContext, ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper) {
        this.exceptionHandling = exceptionHandling;
        this.urCapErrorHandler = exceptionHandling.getUrCapErrorHandler();
        this.installationLoadingContext = installationLoadingContext;
        this.consoleLoggerExceptionHelper = consoleLoggerExceptionHelper;
    }

    public void assertNotNull(InstallationNodeContribution installationNodeContribution, Object installationNodeService) {
        if (installationNodeContribution == null) {
            throw new NullPointerException(String.valueOf(installationNodeService.getClass().getSimpleName()) + ".createInstallationNode() returned null.");
        }
    }

    @Override
    public final JComponent getComponent() {
        return this.component;
    }

    @Override
    public final InstallationNodeContribution getUserContribution() {
        return this.installationNodeContribution;
    }

    @Override
    public final JComponent getErrorView() {
        URCapErrorPanel urCapErrorPanel = this.urCapErrorHandler.getErrorPanel();
        urCapErrorPanel.setMetadataFromClass(this.getInstallationNodeServiceClassForException());
        return urCapErrorPanel;
    }

    @Override
    public final boolean enterView() {
        if (this.installationLoadingContext.isLoading()) {
            return true;
        }
        this.urCapErrorHandler.clearError();
        if (!this.viewOpened) {
            this.viewOpened = true;
            try {
                this.installationNodeContribution.openView();
            }
            catch (Throwable e) {
                StackTraceElement exitPoint = this.getCatchingMethod("com.ur.urcap.contribution.installation.AbstractInstallationContribution", e, "enterView");
                this.consoleLoggerExceptionHelper.logToConsole(e, this.installationNodeContribution.getClass(), exitPoint);
                this.urCapErrorHandler.handle(e);
                this.logInternalURCapException(e);
                return false;
            }
        }
        return true;
    }

    @Override
    public final void exitView() {
        if (this.viewOpened) {
            this.viewOpened = false;
            try {
                this.cleanUpOtherInstallationContributions();
                this.installationNodeContribution.closeView();
            }
            catch (Throwable e) {
                StackTraceElement exitPoint = this.getCatchingMethod("com.ur.urcap.contribution.installation.AbstractInstallationContribution", e, "exitView");
                this.consoleLoggerExceptionHelper.logToConsole(e, this.installationNodeContribution.getClass(), exitPoint);
                this.urCapErrorHandler.handle(e);
                this.showDialogForInternalURCapException(e);
            }
        }
    }

    abstract void cleanUpOtherInstallationContributions();

    @Override
    public final void generatePreambleScript(ScriptWriter writer) {
        try {
            if (this.installationNodeContribution != null) {
                this.installationNodeContribution.generateScript(writer);
            }
        }
        catch (Throwable e) {
            StackTraceElement exitPoint = this.getCatchingMethod("com.ur.urcap.contribution.installation.AbstractInstallationContribution", e, "generatePreambleScript");
            this.consoleLoggerExceptionHelper.logToConsole(e, this.installationNodeContribution.getClass(), exitPoint);
            StackTraceElement stack = e instanceof ProxiedException ? ((ProxiedException)e).findCatchingMethod() : Thread.currentThread().getStackTrace()[1];
            this.exceptionHandling.showURCapExceptionDialogWithoutFlightReport(e, stack, this.getInstallationNodeServiceClassForException());
            throw new RuntimeException("Error generating preamble script", e);
        }
    }

    final void logInternalURCapException(Throwable e) {
        StackTraceElement stack = e instanceof ProxiedException ? ((ProxiedException)e).findCatchingMethod() : Thread.currentThread().getStackTrace()[2];
        this.exceptionHandling.recordURCapExceptionInFlightReport(e, stack, this.getInstallationNodeServiceClassForException());
    }

    final void showDialogForInternalURCapException(Throwable e) {
        StackTraceElement stack = e instanceof ProxiedException ? ((ProxiedException)e).findCatchingMethod() : Thread.currentThread().getStackTrace()[2];
        this.exceptionHandling.showURCapExceptionDialog(e, stack, this.getInstallationNodeServiceClassForException());
    }

    protected Class getInstallationNodeServiceClassForException() {
        return this.getInstallationNodeServiceClass();
    }

    @Override
    public final boolean hasError() {
        return this.urCapErrorHandler.hasError();
    }

    @Override
    public final void clearError() {
    }

    @Override
    public void setError(Throwable e) {
        this.component = null;
        this.urCapErrorHandler.handle(e);
    }

    @Override
    public void finalizeDataModelReset(CreationContextHolder contextHolder) {
    }

    public void bindSafetyContribution(SafetyContribution safetyContribution) {
        this.safetyContribution = safetyContribution;
        this.safetyContribution.bindErrorHandling(new SafetyContribution.URCapErrorPropagator(){

            public void informAndDisableURCap(String fullyQualifiedClassName, Throwable e, String method) {
                AbstractInstallationContribution.this.logExceptionOnMethod(fullyQualifiedClassName, e, AbstractInstallationContribution.this.getInstallationNodeServiceClassForException(), method);
            }

            public void inform(String fullyQualifiedClassName, Throwable e, String method) {
                StackTraceElement exitPoint = AbstractInstallationContribution.this.getCatchingMethod(fullyQualifiedClassName, e, method);
                AbstractInstallationContribution.this.consoleLoggerExceptionHelper.logToConsole(e, AbstractInstallationContribution.this.installationNodeContribution.getClass(), exitPoint);
                StackTraceElement stack = e instanceof ProxiedException ? ((ProxiedException)e).findCatchingMethod() : Thread.currentThread().getStackTrace()[1];
                AbstractInstallationContribution.this.exceptionHandling.showURCapExceptionDialogWithoutFlightReport(e, stack, AbstractInstallationContribution.this.getInstallationNodeServiceClassForException());
            }
        });
    }

    public SafetyContribution getSafetyContribution() {
        return this.safetyContribution;
    }

    protected void logAndShowException(String fullyQualifiedClassName, Throwable e, Class<?> subClass) {
        this.logExceptionOnMethod(fullyQualifiedClassName, e, subClass, "setModel");
    }

    private void logExceptionOnMethod(String fullyQualifiedClassName, Throwable e, Class<?> subClass, String method) {
        StackTraceElement exitPoint = this.getCatchingMethod(fullyQualifiedClassName, e, method);
        this.consoleLoggerExceptionHelper.logToConsole(e, subClass, exitPoint);
        this.urCapErrorHandler.handle(e);
        this.showDialogForInternalURCapException(e);
    }

    private StackTraceElement getCatchingMethod(String fullyQualifiedClassName, Throwable e, String method) {
        if (method == null) {
            return null;
        }
        return this.consoleLoggerExceptionHelper.findCatchingMethod(e, fullyQualifiedClassName, method);
    }

    @Inject
    public void setTcpService(TCPService tcpService) {
        this.tcpService = tcpService;
    }

    @Inject
    public void setFeatureService(FeatureService featureService) {
        this.featureService = featureService;
    }

    protected void safelyCreateInstallationNode(CreationContext context, Runnable createNodeAction) {
        try {
            if (this.isNodeCreationLoadType(context)) {
                this.featureService.setFeatureRemoveAndUpdateAllowed(false);
                this.tcpService.setTCPRemoveAndUpdateAllowed(false);
            }
            createNodeAction.run();
        }
        finally {
            this.featureService.setFeatureRemoveAndUpdateAllowed(true);
            this.tcpService.setTCPRemoveAndUpdateAllowed(true);
        }
    }

    private boolean isNodeCreationLoadType(CreationContext context) {
        return context != null && context.getNodeCreationType() == CreationContext.NodeCreationType.LOAD;
    }

    protected void safelyCreateInstallationNode(SafetyCreationContext context, Runnable createNodeAction) {
        try {
            if (this.isNodeCreationLoadType(context)) {
                this.featureService.setFeatureRemoveAndUpdateAllowed(false);
                this.tcpService.setTCPRemoveAndUpdateAllowed(false);
            }
            createNodeAction.run();
        }
        finally {
            this.featureService.setFeatureRemoveAndUpdateAllowed(true);
            this.tcpService.setTCPRemoveAndUpdateAllowed(true);
        }
    }

    private boolean isNodeCreationLoadType(SafetyCreationContext context) {
        return context != null && context.getSafetyCreationType() == SafetyCreationContext.SafetyCreationType.LOAD;
    }
}

