/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.InstallationModifier;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.persistence.TypedDictionary;
import com.ur.polyscope.persistence.TypedOptionsSection;
import com.ur.polyscope.scriptwriter.ScriptError;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.urcap.api.contribution.installation.ContributionConfiguration;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.urcap.contribution.installation.InstallationDataModelAdapter;
import com.ur.urcap.contribution.installation.URCapInstallation;
import gui.installation.TypedInstallationNodeModel;
import gui.tools.LanguagePack;
import javax.inject.Provider;

abstract class AbstractURCapInstallation
extends InstallationNode
implements URCapInstallation {
    private static final Logger LOGGER = LogFactory.createLogger(AbstractURCapInstallation.class);
    private final TextResource textResource = LanguagePack.getTextResource();
    private final Provider<InstallationContribution> contributionProvider;
    private final InstallationModifier installationModifier;
    TypedOptionsSection installationModel;
    InstallationContribution contribution;
    private String id;
    private URCapInformation info;

    AbstractURCapInstallation(Provider<InstallationContribution> contributionProvider, InstallationModifier installationModifier) {
        this.contributionProvider = contributionProvider;
        this.installationModifier = installationModifier;
    }

    public void clearErrors() {
        super.clearErrors();
        InstallationContribution installationContribution = this.getInstallationContribution();
        if (installationContribution != null) {
            installationContribution.clearError();
        }
    }

    public boolean hasError() {
        return this.getScriptGenerator().hasScriptError() || this.getInstallationContribution().hasError();
    }

    public String getTypeName() {
        return this.getTitle();
    }

    public final ScriptError createScriptError(ScriptWriter.ScriptPosition scriptPosition) {
        ScriptError scriptError;
        ScriptError scriptError2 = scriptError = this.hasInstallationContribution() ? super.createScriptError(scriptPosition) : new ScriptError(this.textResource.programNode(), this.getTitle());
        if (this.isThirdPartyURCap()) {
            String name = this.info.getName();
            scriptError.addLabel(String.valueOf(this.textResource.urcapName()) + ":", name);
            String version = this.info.getVersion();
            scriptError.addLabel(String.valueOf(this.textResource.urcapVersion()) + ":", version);
            String vendor = this.info.getVendor();
            scriptError.addLabel(String.valueOf(this.textResource.Developer()) + ":", vendor);
            String contact = this.info.getBundleAttribute("Bundle-ContactAddress");
            scriptError.addLabel(String.valueOf(this.textResource.urcapContactinfo()) + ":", contact);
        }
        return scriptError;
    }

    public final ScriptWriter generatePreambleScript(ScriptWriter writer) {
        return writer;
    }

    @Override
    public final String getBundleInfo() {
        String name = this.info.getName();
        String version = this.info.getVersion();
        String vendor = this.info.getVendor();
        return String.valueOf(name) + ", " + version + ", " + vendor;
    }

    @Override
    public InstallationContribution getInstallationContribution() {
        if (this.contribution == null) {
            this.contribution = (InstallationContribution)this.contributionProvider.get();
            this.prepareUI();
        }
        return this.contribution;
    }

    protected abstract void prepareUI();

    public final URCapInformation getURCapInformation() {
        return this.info;
    }

    public void setURCapInformation(URCapInformation info) {
        this.info = info;
    }

    @Override
    public final boolean isThirdPartyURCap() {
        return this.info.isThirdParty();
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public TypedOptionsSection getInstallationModel() {
        if (this.installationModel == null) {
            this.installationModel = new TypedOptionsSection();
        }
        return this.installationModel;
    }

    @Override
    public void setInstallationModel(TypedOptionsSection model, CreationContextHolder contextHolder) {
        this.installationModel = model;
        this.updateInstallationContribution(contextHolder);
    }

    @Override
    public void clearInstallationModel(CreationContextHolder contextHolder) {
        this.installationModel = null;
        this.updateInstallationContribution(contextHolder);
    }

    @Override
    public String getInstallationContributionTitle() {
        if (this.getInstallationContribution() == null) {
            return "";
        }
        String title = this.getInstallationContribution().getTitle();
        return title == null ? null : title.trim();
    }

    @Override
    public void configureInstallation(ContributionConfiguration configuration) {
    }

    protected void updateInstallationContribution(CreationContextHolder contextHolder) {
        try {
            this.tryProcessDataModel(contextHolder, this.getInstallationContribution());
        }
        catch (RuntimeException e) {
            LOGGER.info("Error updating installation contribution: " + e.getMessage(), new Object[0]);
        }
    }

    private void tryProcessDataModel(CreationContextHolder contextHolder, InstallationContribution installationContribution) {
        if (installationContribution == null) {
            return;
        }
        this.settingAndFinalizingDataModel(contextHolder, installationContribution);
    }

    private void settingAndFinalizingDataModel(CreationContextHolder contextHolder, InstallationContribution installationContribution) {
        try {
            this.setInstallationContributionModel(contextHolder, installationContribution);
        }
        finally {
            installationContribution.finalizeDataModelReset(contextHolder);
        }
    }

    private void setInstallationContributionModel(CreationContextHolder contextHolder, InstallationContribution installationContribution) {
        if (AbstractURCapInstallation.isNewlyCreatedNode(contextHolder)) {
            this.setNewDataModel(contextHolder, installationContribution);
        } else {
            this.setClonedModelWithRealData(contextHolder, installationContribution);
        }
    }

    private static boolean isNewlyCreatedNode(CreationContextHolder contextHolder) {
        return contextHolder.creationContext().getNodeCreationType() == CreationContext.NodeCreationType.NEW;
    }

    private void setNewDataModel(CreationContextHolder contextHolder, InstallationContribution contribution) {
        TypedOptionsSection dataModel = this.getInstallationModel();
        TypedInstallationNodeModel optionsSection = new TypedInstallationNodeModel(dataModel, this.installationModifier);
        InstallationDataModelAdapter model = new InstallationDataModelAdapter((TypedDictionary)optionsSection);
        contribution.setModel(model, contextHolder);
    }

    private void setClonedModelWithRealData(CreationContextHolder contextHolder, InstallationContribution installationContribution) {
        InstallationDataModelAdapter dataModel = this.createClone();
        installationContribution.setModel(dataModel, contextHolder);
        TypedInstallationNodeModel realModel = new TypedInstallationNodeModel(this.getInstallationModel(), this.installationModifier);
        dataModel.setOptionsSection((TypedDictionary)realModel);
    }

    private InstallationDataModelAdapter createClone() {
        TypedOptionsSection installationModelClone = this.getInstallationModel().clone();
        TypedInstallationNodeModel tempModel = new TypedInstallationNodeModel(installationModelClone, this.installationModifier);
        return new InstallationDataModelAdapter((TypedDictionary)tempModel);
    }
}

