/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.safety.SafetySettingsCaretaker;
import com.ur.polyscope.urcaps.proxy.SwitchableProxy;
import com.ur.safety.urcapcontribution.SafetyContribution;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyContributionConfiguration;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyEquipmentConfiguredOutsideScope;
import com.ur.urcap.api.contribution.installation.swing.safety.MustCallInsideMethodScope;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyNodeContribution;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyNodeService;
import com.ur.urcap.contribution.installation.SafetyInstallationContribution;
import javax.inject.Provider;

public class CallConfigureContribution {
    private static final String CONFIGURATION_USED_OUTSIDE_SCOPE = "Registration of Equipment and binding of listeners cannot be performed outside 'configureContribution(..)' call";
    private final SafetyNodeService safetyNodeService;
    private final SafetyEquipmentContributionService equipmentContributionService;

    public CallConfigureContribution(SafetyNodeService safetyNodeService, SafetyEquipmentContributionService safetyEquipmentContributionService) {
        this.safetyNodeService = safetyNodeService;
        this.equipmentContributionService = safetyEquipmentContributionService;
    }

    void configureConfiguration() {
        int equipmentCount = this.equipmentContributionService.registeredEquipmentCount();
        SafetyContributionConfiguration configurationProxy = (SafetyContributionConfiguration)SwitchableProxy.createForwardingActionProxy((Object)this.equipmentContributionService);
        this.invokeProxyThenBlock(configurationProxy);
        this.ensureRegistrationOfEquipment(equipmentCount);
    }

    private void ensureRegistrationOfEquipment(int equipmentCount) {
        if (this.equipmentContributionService.registeredEquipmentCount() == equipmentCount) {
            throw new MustCallInsideMethodScope("Failed to register Safety Equipment inside 'configureSafetyContribution(..)' call");
        }
    }

    private void invokeProxyThenBlock(SafetyContributionConfiguration configurationProxy) {
        try {
            this.safetyNodeService.configureSafetyContribution(configurationProxy);
        }
        finally {
            SwitchableProxy.switchToAction((Object)configurationProxy, this::throwMustCallInsideMethodScope);
        }
    }

    private void throwMustCallInsideMethodScope() {
        throw new SafetyEquipmentConfiguredOutsideScope(CONFIGURATION_USED_OUTSIDE_SCOPE);
    }

    void bindSafetyContribution(SafetyInstallationContribution installationContribution, SafetySettingsCaretaker safetySettingsCaretaker) {
        SafetyContribution safetyContribution = new SafetyContribution(this.getSafetyNodeContributionProvider(installationContribution), installationContribution.getURCapSafetyLock(), safetySettingsCaretaker, this.equipmentContributionService);
        installationContribution.bindSafetyContribution(safetyContribution);
    }

    private Provider<SafetyNodeContribution> getSafetyNodeContributionProvider(SafetyInstallationContribution installationContribution) {
        return () -> (SafetyNodeContribution)installationContribution.getUserContribution();
    }
}

