/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.installation.resource.ResourceControlService;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.tcp.TCPRef;
import com.ur.polyscope.tcp.TCPService;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class ContributionResourceCleaner {
    private final TCPService tcpService1;
    private final FeatureService featureService1;
    private final PayloadService payloadService1;
    private final ResourceControlService resourceControlService1;

    @Inject
    public ContributionResourceCleaner(TCPService tcpService, FeatureService featureService, PayloadService payloadService, ResourceControlService resourceControlService) {
        this.tcpService1 = tcpService;
        this.featureService1 = featureService;
        this.payloadService1 = payloadService;
        this.resourceControlService1 = resourceControlService;
    }

    public void cleanContributionByOwner(String ownerId) {
        this.removeContributedTCPs(ownerId);
        this.removeContributedFeatures(ownerId);
        this.removeContributedPayloads(ownerId);
        this.removeResourceControl(ownerId);
    }

    private void removeResourceControl(String urcapId) {
        this.resourceControlService1.removeMissingRequests(urcapId);
    }

    private void removeContributedTCPs(String ownerId) {
        Collection contributedTCPs = this.tcpService1.getContributedTCPsByOwnerId(ownerId);
        for (TCPRef tcp : contributedTCPs) {
            this.tcpService1.deregisterTCP(tcp.dereferenceInUnderwayInstallation());
        }
    }

    private void removeContributedFeatures(String ownerId) {
        Collection allFeatures = this.featureService1.getAllSpatialFeatures();
        for (SpatialFeature feature : allFeatures) {
            if (!(feature instanceof GeomPoseNodeContributed) || !((GeomPoseNodeContributed)feature).getContributorInfo().getOwnerId().equals(ownerId)) continue;
            this.featureService1.deregisterFeature(feature);
        }
    }

    private void removeContributedPayloads(String ownerId) {
        this.payloadService1.removeURCapsPayloadsWithOwnerId(ownerId);
    }
}

