/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.lang.Defense;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyCreationContext;

public class CreationContextHolder {
    private final CreationContext creationContext;
    private final SafetyCreationContext safetyCreationContext;

    public CreationContextHolder(SafetyCreationContext.SafetyCreationType safetyCreationType) {
        this(() -> safetyCreationType);
    }

    public CreationContextHolder(SafetyCreationContext context) {
        Defense.notNull((Object)context, (String)"Context cannot be null");
        this.creationContext = () -> context.getSafetyCreationType() == SafetyCreationContext.SafetyCreationType.LOAD ? CreationContext.NodeCreationType.LOAD : CreationContext.NodeCreationType.NEW;
        this.safetyCreationContext = context;
    }

    public static CreationContextHolder createLoad() {
        return new CreationContextHolder(SafetyCreationContext.SafetyCreationType.LOAD);
    }

    public static CreationContextHolder createNewAndReset() {
        return new CreationContextHolder(SafetyCreationContext.SafetyCreationType.NEW_AND_RESET);
    }

    public static CreationContextHolder createNewAndKeep() {
        return new CreationContextHolder(SafetyCreationContext.SafetyCreationType.NEW_AND_KEEP);
    }

    public CreationContext creationContext() {
        return this.creationContext;
    }

    public SafetyCreationContext safetyCreationContext() {
        return this.safetyCreationContext;
    }
}

