/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.bean.InvokeField;
import com.ur.bean.InvokeMethod;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.resource.ResourceControlRequestService;
import com.ur.swing.SwingUtil;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.InstallationNodeService;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.domain.URCapAPIFacade;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.UIBinder;
import com.ur.urcap.contribution.UIConverter;
import com.ur.urcap.contribution.installation.AbstractInstallationContribution;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.io.IOUtils;

public final class InstallationContributionHtml
extends AbstractInstallationContribution {
    private static final String BLANK_SCREEN_HTML = HTML.html((String)HTML.body((String)HTML.div((String)HTML.space())));
    private final UIConverter converter;
    private final ResourceControlRequestService resourceControlRequestService;
    private final ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper;
    private final UIBinder binder;
    private InstallationNodeService htmlInstallationNodeService = null;
    private String html;
    private String title = null;

    @Inject
    public InstallationContributionHtml(UIConverter converter, UIBinder binder, ExceptionHandling exceptionHandling, ResourceControlRequestService resourceControlRequestService, InstallationLoadingContext installationLoadingContext, ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper) {
        super(exceptionHandling, installationLoadingContext, consoleLoggerExceptionHelper);
        this.converter = converter;
        this.binder = binder;
        this.resourceControlRequestService = resourceControlRequestService;
        this.consoleLoggerExceptionHelper = consoleLoggerExceptionHelper;
    }

    public void bind(InstallationNodeService service) throws IOException {
        this.htmlInstallationNodeService = service;
        this.binder.setExceptionClass(this.htmlInstallationNodeService.getClass());
        InputStream htmlStream = service.getHTML();
        this.html = htmlStream == null ? BLANK_SCREEN_HTML : IOUtils.toString((InputStream)htmlStream, (Charset)StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindComponent(String html, InstallationNodeContribution backend) {
        try {
            Object object = this.component.getTreeLock();
            synchronized (object) {
                AccessibleObject each;
                this.component = this.converter.convert(html);
                this.binder.setComponent(this.component);
                AccessibleObject[] accessibleObjectArray = backend.getClass().getDeclaredMethods();
                int n = accessibleObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    each = accessibleObjectArray[n2];
                    InvokeMethod method = InvokeMethod.createInvokeMethodWithFixedTarget((Object)backend, (Method)each);
                    this.binder.bindMethod(method);
                    ++n2;
                }
                accessibleObjectArray = backend.getClass().getDeclaredFields();
                n = accessibleObjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    each = accessibleObjectArray[n2];
                    InvokeField field = new InvokeField((Object)backend, (Field)each);
                    this.binder.bindField(field);
                    ++n2;
                }
            }
        }
        catch (Throwable t) {
            this.consoleLoggerExceptionHelper.logToConsole(t, backend.getClass());
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpComponent() {
        try {
            Object object = this.component.getTreeLock();
            synchronized (object) {
                if (this.component == null) {
                    return;
                }
                List components = SwingUtil.getAllComponents((Container)this.component, (Class[])new Class[]{JComponent.class});
                components.add(this.component);
                for (Component each : components) {
                    if (each.getParent() == null) continue;
                    each.getParent().removeAll();
                }
            }
        }
        catch (Throwable t) {
            Log.error((String)"Exception occurred when cleaning up component", (Throwable)t);
            throw t;
        }
    }

    @Override
    public void setModel(DataModel model, CreationContextHolder contextHolder) {
        try {
            if (this.installationNodeContribution != null) {
                this.exitView();
            }
            if (this.htmlInstallationNodeService == null || this.html == null) {
                return;
            }
            CreationContext context = contextHolder.creationContext();
            this.safelyCreateInstallationNode(context, () -> this.createInstallationNodeContribution(model));
            this.assertNotNull(this.installationNodeContribution, this.htmlInstallationNodeService);
            this.cleanUpComponent();
            this.bindComponent(this.html, this.installationNodeContribution);
        }
        catch (Throwable e) {
            if (this.installationNodeContribution != null) {
                this.consoleLoggerExceptionHelper.logToConsole(e, this.installationNodeContribution.getClass());
            }
            this.urCapErrorHandler.handle(e);
            this.showDialogForInternalURCapException(e);
        }
    }

    private void createInstallationNodeContribution(DataModel model) {
        try {
            try {
                this.resourceControlRequestService.setEnable(true);
                this.installationNodeContribution = this.htmlInstallationNodeService.createInstallationNode(URCapAPIFacade.getURCapAPI(), model);
            }
            catch (RuntimeException e) {
                StackTraceElement exitPoint = this.consoleLoggerExceptionHelper.findCatchingMethod(e, "com.ur.urcap.contribution.installation.InstallationContributionHtml", "createInstallationNodeContribution");
                this.consoleLoggerExceptionHelper.logToConsole(e, this.htmlInstallationNodeService.getClass(), exitPoint);
                this.resourceControlRequestService.setEnable(false);
            }
        }
        finally {
            this.resourceControlRequestService.setEnable(false);
        }
    }

    @Override
    public Class getInstallationNodeServiceClass() {
        return this.htmlInstallationNodeService.getClass();
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        try {
            this.title = this.htmlInstallationNodeService.getTitle();
            if (this.title == null) {
                String canonicalName = this.htmlInstallationNodeService.getClass().getCanonicalName();
                throw new RuntimeException(String.valueOf(canonicalName) + ".getTitle() returned null");
            }
        }
        catch (Throwable e) {
            this.title = "";
            StackTraceElement exitPoint = this.consoleLoggerExceptionHelper.findCatchingMethod(e, "com.ur.urcap.contribution.installation.InstallationContributionHtml", "getTitle");
            this.consoleLoggerExceptionHelper.logToConsole(e, this.htmlInstallationNodeService.getClass(), exitPoint);
            this.urCapErrorHandler.handle(e);
            this.showDialogForInternalURCapException(e);
        }
        return this.title;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    void cleanUpOtherInstallationContributions() {
    }
}

