/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.resource.ResourceControlRequestService;
import com.ur.polyscope.installation.urcap.proxy.DataModelResetable;
import com.ur.polyscope.urcaps.nodeservices.EmbeddedProxiedService;
import com.ur.polyscope.urcaps.nodeservices.ProxiedService;
import com.ur.swing.BundleClassAuthorizer;
import com.ur.swing.BundleClassAuthorizerImpl;
import com.ur.swing.RestrictedPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.installation.AbstractInstallationContribution;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.urcap.contribution.installation.InstallationPanelFactory;
import java.awt.Dimension;
import java.util.Locale;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class InstallationContributionSwing
extends AbstractInstallationContribution {
    private static final Dimension PANEL_DIMENSION = (Dimension)UIManager.get("InstallationContributionPanel.dimensions");
    private static final Border PANEL_BORDER = (Border)UIManager.get("InstallationContributionPanel.border");
    private final InstallationAPIProvider installationAPIProvider;
    private final ViewAPIProvider viewAPIProvider;
    private final ResourceControlRequestService resourceControlRequestService;
    private MessageDialogCreator dialogCreator;
    private final InstallationPanelFactory componentFactory;
    private final BundleClassAuthorizerImpl classAuthorizer;
    private final TextResource textResource;
    private Dimension restrictedPanelDimension = PANEL_DIMENSION;
    private SwingInstallationNodeService swingInstallationNodeService = null;
    private String title = null;

    @Inject
    public InstallationContributionSwing(ExceptionHandling exceptionHandling, InstallationPanelFactory componentFactory, BundleClassAuthorizerImpl classAuthorizer, InstallationAPIProvider installationAPIProvider, ViewAPIProvider viewAPIProvider, ResourceControlRequestService resourceControlRequestService, InstallationLoadingContext installationLoadingContext, ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper, ViewContext viewContext) {
        super(exceptionHandling, installationLoadingContext, consoleLoggerExceptionHelper);
        this.componentFactory = componentFactory;
        this.classAuthorizer = classAuthorizer;
        this.installationAPIProvider = installationAPIProvider;
        this.viewAPIProvider = viewAPIProvider;
        this.resourceControlRequestService = resourceControlRequestService;
        this.dialogCreator = viewContext.getDialogCreator();
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
    }

    public void bindService(SwingInstallationNodeService swingPolyScopeInstallationNode) {
        this.swingInstallationNodeService = swingPolyScopeInstallationNode;
    }

    @Override
    public void setModel(DataModel model, CreationContextHolder contextHolder) {
        try {
            if (this.installationNodeContribution != null) {
                this.exitView();
            }
            CreationContext context = contextHolder.creationContext();
            SwingInstallationNodeView view = this.swingInstallationNodeService.createView(this.viewAPIProvider);
            this.safelyCreateInstallationNode(context, () -> this.createInstallationNode(model, context, view));
            this.assertNotNull(this.installationNodeContribution, this.swingInstallationNodeService);
            RestrictedPanel restrictedComponent = new RestrictedPanel(this.restrictedPanelDimension, PANEL_BORDER, (BundleClassAuthorizer)this.classAuthorizer);
            view.buildUI((JPanel)restrictedComponent, this.installationNodeContribution);
            if (this.hasError()) {
                return;
            }
            this.component = this.componentFactory.createTitledPanel(this.getTitle(), (JPanel)restrictedComponent);
        }
        catch (Throwable e) {
            this.logAndShowException(this.getClass().getCanonicalName(), e, this.swingInstallationNodeService.getClass());
            this.component = null;
        }
    }

    private void createInstallationNode(DataModel model, CreationContext context, SwingInstallationNodeView view) {
        try {
            this.resourceControlRequestService.setEnable(true);
            this.installationNodeContribution = this.swingInstallationNodeService.createInstallationNode(this.installationAPIProvider, view, model, context);
        }
        finally {
            this.resourceControlRequestService.setEnable(false);
        }
    }

    @Override
    public Class getInstallationNodeServiceClass() {
        if (this.isProxied()) {
            return ((ProxiedService)this.swingInstallationNodeService).getProxiedService();
        }
        return this.swingInstallationNodeService.getClass();
    }

    @Override
    protected Class getInstallationNodeServiceClassForException() {
        if (this.swingInstallationNodeService instanceof ProxiedService) {
            return ((ProxiedService)this.swingInstallationNodeService).getProxiedService();
        }
        return this.swingInstallationNodeService.getClass();
    }

    @Override
    public void finalizeDataModelReset(CreationContextHolder contextHolder) {
        if (this.swingInstallationNodeService instanceof DataModelResetable && ((DataModelResetable)this.swingInstallationNodeService).isFinalizeRequired()) {
            ((DataModelResetable)this.swingInstallationNodeService).finalizeDataModelReset();
            CreationContext context = contextHolder.creationContext();
            if (context.getNodeCreationType() == CreationContext.NodeCreationType.LOAD) {
                this.showMessage();
            }
        }
    }

    private void showMessage() {
        String dialogTitle = this.textResource.changedInstallation();
        String messageText = this.textResource.installationChanged(this.getTitle());
        DialogMessage dialogMessage = new DialogMessage(dialogTitle, messageText);
        this.dialogCreator.showMessageDialog(dialogMessage, MessageDialogType.MESSAGE, new OkDialogListener());
    }

    private boolean isProxied() {
        return this.swingInstallationNodeService instanceof ProxiedService && !(this.swingInstallationNodeService instanceof EmbeddedProxiedService);
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        try {
            Locale locale = this.viewAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
            this.title = this.swingInstallationNodeService.getTitle(locale);
            if (this.title == null) {
                String canonicalName = this.swingInstallationNodeService instanceof ProxiedService ? ((ProxiedService)this.swingInstallationNodeService).getProxiedService().getCanonicalName() : this.swingInstallationNodeService.getClass().getCanonicalName();
                throw new RuntimeException(String.valueOf(canonicalName) + ".getTitle() returned null");
            }
        }
        catch (Throwable e) {
            this.logAndShowException(this.getClass().getCanonicalName(), e, this.swingInstallationNodeService.getClass());
            this.title = "";
        }
        return this.title;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    void cleanUpOtherInstallationContributions() {
    }
}

