/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.i18n.TextResource;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.util.swing.HTML;
import gui.commandpanels.DetailsPanelBuilder;
import gui.tools.LegacyURDialogCreator;
import java.awt.BorderLayout;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MissingInstallationContribution
implements InstallationContribution {
    private final Provider<DetailsPanelBuilder> detailsPanelBuilderProvider;
    private Runnable removeFromInstallationRunnable;
    private String title;
    private JComponent component = new JPanel();
    private final TextResource textResource;

    @Inject
    public MissingInstallationContribution(Provider<DetailsPanelBuilder> detailsPanelBuilderProvider, TextResource textResource) {
        this.detailsPanelBuilderProvider = detailsPanelBuilderProvider;
        this.textResource = textResource;
    }

    public void setup(String type, String name, String vendor, Runnable removeFromInstallationRunnable) {
        this.removeFromInstallationRunnable = removeFromInstallationRunnable;
        this.title = type;
        this.component = ((DetailsPanelBuilder)this.detailsPanelBuilderProvider.get()).setTitle(this.getPanelTitle()).setPrologue(this.getPanelPrologue()).addDetails((Object)this.getURCapTypeLabelText(), (Object)type).addDetails((Object)this.getURCapNameLabelText(), (Object)name).addDetails((Object)this.getURCapVendorLabelText(), (Object)vendor).setEpilogue(this.getPanelEpilogue()).setOkListener(this.getPanelButtonLabel(), this.getRemoveFromInstallationListener()).build();
        this.setMarginOnPanel(this.component);
    }

    private void setMarginOnPanel(JComponent component) {
        component.setBorder(BorderFactory.createEmptyBorder(12, 14, 12, 12));
    }

    public void showAsRemoved(String title) {
        this.component.removeAll();
        this.component.setLayout(new BorderLayout());
        this.component.add(((DetailsPanelBuilder)this.detailsPanelBuilderProvider.get()).setTitle(title).setPrologue(this.getHasBeenRemovedText()).build());
    }

    @Override
    public JComponent getErrorView() {
        return new JPanel();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public InstallationNodeContribution getUserContribution() {
        return null;
    }

    @Override
    public Class getInstallationNodeServiceClass() {
        return this.getClass();
    }

    @Override
    public void setError(Throwable exception) {
    }

    @Override
    public void finalizeDataModelReset(CreationContextHolder contextHolder) {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean enterView() {
        return true;
    }

    @Override
    public void exitView() {
    }

    @Override
    public void generatePreambleScript(ScriptWriter writer) {
    }

    @Override
    public void setModel(DataModel model, CreationContextHolder context) {
    }

    @Override
    public void clearError() {
    }

    private String getHasBeenRemovedText() {
        return this.textResource.hasBeenRemovedFromInstallation();
    }

    private String getPanelTitle() {
        return this.textResource.missingUrcap();
    }

    private String getPanelPrologue() {
        return this.textResource.urcapMissingInstallationStatement();
    }

    private String getPanelEpilogue() {
        return String.valueOf(HTML.br()) + HTML.fontBold((String)this.textResource.urcapMissingInstallationSuggestion()) + HTML.br() + HTML.br() + HTML.indentRight((int)60, (String)(String.valueOf(HTML.unorderedList(Arrays.asList(String.valueOf(HTML.italic((String)this.textResource.installColon())) + " " + this.textResource.urcapMissingInstall()))) + HTML.unorderedList(Arrays.asList(String.valueOf(HTML.italic((String)this.textResource.removeColon())) + " " + this.textResource.urcapMissingRemove())) + HTML.unorderedList(Arrays.asList(String.valueOf(HTML.italic((String)this.textResource.ignoreColon())) + " " + this.textResource.urcapMissingIgnore()))));
    }

    private String getPanelButtonLabel() {
        return this.textResource.removeFromInstallation();
    }

    private String getURCapTypeLabelText() {
        return this.textResource.installationNodeType();
    }

    private String getURCapNameLabelText() {
        return this.textResource.urcapNameColon();
    }

    private String getURCapVendorLabelText() {
        return this.textResource.urcapDeveloper();
    }

    private Runnable getRemoveFromInstallationListener() {
        return new Runnable(){

            @Override
            public void run() {
                DialogReturnValue result = LegacyURDialogCreator.confirmMessageDialog((ConfirmationMessage)new ConfirmationMessage(this.getTitleText(), this.getExplanation(), this.getOKButtonText(), MissingInstallationContribution.this.textResource.Cancel()));
                if (result == DialogReturnValue.OK) {
                    MissingInstallationContribution.this.removeFromInstallationRunnable.run();
                }
            }

            private String getOKButtonText() {
                return MissingInstallationContribution.this.textResource.Remove();
            }

            private String getTitleText() {
                return MissingInstallationContribution.this.textResource.removeFromInstallation();
            }

            private String getExplanation() {
                return MissingInstallationContribution.this.textResource.removeFromInstallationQuestion();
            }
        };
    }

    @Override
    public boolean hasError() {
        return false;
    }
}

