/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.lang.StringUtils;
import com.ur.polyscope.installation.InstallationModifier;
import com.ur.polyscope.persistence.TypedDictionary;
import com.ur.polyscope.persistence.TypedOptionsSection;
import com.ur.urcap.contribution.installation.InstallationDataModelAdapter;
import com.ur.urcap.contribution.installation.MissingInstallationContribution;
import com.ur.urcap.contribution.installation.URCapInstallationModule;
import com.ur.urcap.contribution.installation.URCapInstallationNodeHtml;
import com.ur.view.polyscope.module.UIInstallationNode;
import gui.installation.TypedInstallationNodeModel;
import javax.inject.Inject;
import javax.inject.Provider;

public class MissingURCapInstallationNode
extends URCapInstallationNodeHtml {
    private final Provider<MissingInstallationContribution> contributionProvider;
    private InstallationModifier installationModifier;
    private MissingInstallationContribution installationContribution;
    private Callback callback = new Callback(){

        @Override
        public void remove(UIInstallationNode uiInstallationNode) {
        }
    };

    @Inject
    public MissingURCapInstallationNode(Provider<MissingInstallationContribution> contributionProvider, InstallationModifier installationModifier) {
        super(null, installationModifier, null);
        this.contributionProvider = contributionProvider;
        this.installationModifier = installationModifier;
    }

    @Override
    public void clearErrors() {
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    private MissingInstallationContribution createInstallationContribution() {
        MissingInstallationContribution contribution = (MissingInstallationContribution)this.contributionProvider.get();
        String contributionTitle = this.getURCapInformation().getInstallationContributionTitle();
        String titleOrId = StringUtils.isNullOrEmpty((String)contributionTitle) ? this.getId() : contributionTitle;
        contribution.setup(titleOrId, this.getURCapInformation().getName(), this.getURCapInformation().getVendor(), this.getRemoveFromInstallationRunnable());
        return contribution;
    }

    @Override
    public MissingInstallationContribution getInstallationContribution() {
        if (this.installationContribution == null) {
            this.installationContribution = this.createInstallationContribution();
        }
        return this.installationContribution;
    }

    public Runnable getRemoveFromInstallationRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                MissingURCapInstallationNode.this.removeFromInstallation();
                MissingURCapInstallationNode.this.setRobotInstallationDirty();
            }
        };
    }

    @Override
    public boolean hasInstallationContribution() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.getURCapInformation().getInstallationContributionTitle();
    }

    private void removeFromInstallation() {
        this.callback.remove(new URCapInstallationModule.URCapNode(this, this));
        this.getInstallationContribution().showAsRemoved(this.getTitle());
    }

    private void setRobotInstallationDirty() {
        new InstallationDataModelAdapter((TypedDictionary)new TypedInstallationNodeModel(new TypedOptionsSection(), this.installationModifier)).set("dummy", true);
    }

    public static interface Callback {
        public void remove(UIInstallationNode var1);
    }
}

