/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.profinet.installation.ProfinetService;
import com.ur.urcap.contribution.installation.UnmarshalledURCapInstallationData;
import java.util.Map;
import javax.inject.Inject;

public final class ProfinetAsURCapLoader {
    private static final String LEGACY_PROFINET_ID = "com.ur.urcap.profinet";
    private final ProfinetService profinetService;

    @Inject
    public ProfinetAsURCapLoader(ProfinetService profinetService) {
        this.profinetService = profinetService;
    }

    public void loadLegacyProfinetData(Map<String, UnmarshalledURCapInstallationData> installationDataMap) {
        if (installationDataMap != null && installationDataMap.containsKey(LEGACY_PROFINET_ID)) {
            UnmarshalledURCapInstallationData installationData = installationDataMap.get(LEGACY_PROFINET_ID);
            this.profinetService.loadLegacyProfinetSettings(installationData.getUnmarshalledDataModel().getOptions());
            installationDataMap.remove(LEGACY_PROFINET_ID);
        }
    }
}

