/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.resource.ResourceControlRequestService;
import com.ur.polyscope.installation.urcap.proxy.DataModelResetable;
import com.ur.polyscope.urcaps.nodeservices.EmbeddedProxiedService;
import com.ur.polyscope.urcaps.nodeservices.ProxiedService;
import com.ur.safety.urcapcontribution.SafetyContributionView;
import com.ur.safety.urcapcontribution.SafetyContributionViewFactory;
import com.ur.safety.urcapcontribution.URCapSafetyLock;
import com.ur.swing.BundleClassAuthorizer;
import com.ur.swing.BundleClassAuthorizerImpl;
import com.ur.swing.RestrictedPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyCreationContext;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyNodeService;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.installation.AbstractInstallationContribution;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.urcap.contribution.installation.InstallationPanelFactory;
import com.ur.urcap.contribution.installation.SafetyInstallationContribution;
import java.awt.Dimension;
import java.util.Locale;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SafetyURCapInstallationContribution
extends AbstractInstallationContribution
implements SafetyInstallationContribution {
    private static final Dimension PANEL_DIMENSION_WITH_FOOTER = (Dimension)UIManager.get("InstallationContributionPanelWithFooter.dimensions");
    private static final Border PANEL_BORDER = (Border)UIManager.get("InstallationContributionPanel.border");
    private final SafetyAPIProvider safetyAPIProvider;
    private final ViewAPIProvider viewAPIProvider;
    private final ResourceControlRequestService resourceControlRequestService;
    private MessageDialogCreator dialogCreator;
    private final SafetyContributionViewFactory safetyContributionViewFactory;
    private final URCapSafetyLock safetyLock;
    private final InstallationPanelFactory componentFactory;
    private final BundleClassAuthorizerImpl classAuthorizer;
    private final TextResource textResource;
    private SafetyNodeService nodeService = null;
    private String title = null;

    @Inject
    public SafetyURCapInstallationContribution(ExceptionHandling exceptionHandling, InstallationPanelFactory componentFactory, BundleClassAuthorizerImpl classAuthorizer, SafetyAPIProvider safetyAPIProvider, ViewAPIProvider viewAPIProvider, ResourceControlRequestService resourceControlRequestService, InstallationLoadingContext installationLoadingContext, ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper, ViewContext viewContext, SafetyContributionViewFactory safetyContributionViewFactory, URCapSafetyLock safetyLock) {
        super(exceptionHandling, installationLoadingContext, consoleLoggerExceptionHelper);
        this.componentFactory = componentFactory;
        this.classAuthorizer = classAuthorizer;
        this.safetyAPIProvider = safetyAPIProvider;
        this.viewAPIProvider = viewAPIProvider;
        this.resourceControlRequestService = resourceControlRequestService;
        this.dialogCreator = viewContext.getDialogCreator();
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.safetyContributionViewFactory = safetyContributionViewFactory;
        this.safetyLock = safetyLock;
    }

    @Override
    public URCapSafetyLock getURCapSafetyLock() {
        return this.safetyLock;
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        try {
            Locale locale = this.viewAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
            this.title = this.nodeService.getTitle(locale);
            if (this.title == null) {
                String canonicalName = this.nodeService instanceof ProxiedService ? ((ProxiedService)this.nodeService).getProxiedService().getCanonicalName() : this.nodeService.getClass().getCanonicalName();
                throw new IllegalStateException(String.valueOf(canonicalName) + ".getTitle() returned null");
            }
        }
        catch (RuntimeException e) {
            this.logAndShowException(this.getClass().getCanonicalName(), e, this.nodeService.getClass());
            this.title = "";
        }
        return this.title;
    }

    @Override
    public void setModel(DataModel model, CreationContextHolder contextHolder) {
        try {
            if (this.installationNodeContribution != null) {
                this.exitView();
            }
            SafetyCreationContext context = contextHolder.safetyCreationContext();
            SwingInstallationNodeView view = this.nodeService.createView(this.viewAPIProvider);
            this.safelyCreateInstallationNode(context, () -> this.createInstallationNode(model, context, view));
            this.assertNotNull(this.installationNodeContribution, this.nodeService);
            RestrictedPanel restrictedComponent = new RestrictedPanel(PANEL_DIMENSION_WITH_FOOTER, PANEL_BORDER, (BundleClassAuthorizer)this.classAuthorizer);
            view.buildUI((JPanel)restrictedComponent, this.installationNodeContribution);
            if (this.hasError()) {
                return;
            }
            SafetyContributionView safetyContributionView = this.safetyContributionViewFactory.getSafetyContributionView(this.getSafetyContribution());
            this.component = this.componentFactory.createSafetyRestrictedTitledPanel(this.getTitle(), (JPanel)restrictedComponent, safetyContributionView);
        }
        catch (RuntimeException e) {
            this.logAndShowException(this.getClass().getCanonicalName(), e, this.nodeService.getClass());
            this.component = null;
        }
    }

    private void createInstallationNode(DataModel model, SafetyCreationContext context, SwingInstallationNodeView view) {
        try {
            this.resourceControlRequestService.setEnable(true);
            this.installationNodeContribution = this.nodeService.createSafetyNodeContribution(this.safetyAPIProvider, view, model, context);
        }
        finally {
            this.resourceControlRequestService.setEnable(false);
        }
    }

    @Override
    public Class getInstallationNodeServiceClass() {
        if (this.isProxied()) {
            return ((ProxiedService)this.nodeService).getProxiedService();
        }
        return this.nodeService.getClass();
    }

    @Override
    protected Class getInstallationNodeServiceClassForException() {
        if (this.nodeService instanceof ProxiedService) {
            return ((ProxiedService)this.nodeService).getProxiedService();
        }
        return this.nodeService.getClass();
    }

    @Override
    public void finalizeDataModelReset(CreationContextHolder contextHolder) {
        if (this.nodeService instanceof DataModelResetable && ((DataModelResetable)this.nodeService).isFinalizeRequired()) {
            ((DataModelResetable)this.nodeService).finalizeDataModelReset();
            CreationContext context = contextHolder.creationContext();
            if (context.getNodeCreationType() == CreationContext.NodeCreationType.LOAD) {
                this.showMessage();
            }
        }
    }

    private void showMessage() {
        String dialogTitle = this.textResource.changedInstallation();
        String messageText = this.textResource.installationChanged(this.getTitle());
        DialogMessage dialogMessage = new DialogMessage(dialogTitle, messageText);
        this.dialogCreator.showMessageDialog(dialogMessage, MessageDialogType.MESSAGE, new OkDialogListener());
    }

    private boolean isProxied() {
        return this.nodeService instanceof ProxiedService && !(this.nodeService instanceof EmbeddedProxiedService);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    public void bindService(SafetyNodeService service) {
        this.nodeService = service;
    }

    @Override
    void cleanUpOtherInstallationContributions() {
        this.getSafetyContribution().lockView();
    }
}

