/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.installation.InstallationModifier;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService;
import com.ur.urcap.api.contribution.installation.ContributionConfiguration;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyCreationContext;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyNodeService;
import com.ur.urcap.api.domain.SystemAPI;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.installation.AbstractURCapInstallationNodeSwing;
import com.ur.urcap.contribution.installation.CallConfigureContribution;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.urcap.contribution.installation.SafetyURCapInstallationContribution;
import java.util.Locale;
import javax.inject.Provider;

public class SafetyURCapInstallationNode
extends AbstractURCapInstallationNodeSwing {
    private final SystemAPI systemAPI;
    private final ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private SafetyNodeService service;
    private CallConfigureContribution callConfigureContribution;

    public SafetyURCapInstallationNode(Provider<InstallationContribution> contributionProvider, SystemAPI systemAPI, InstallationModifier installationModifier, ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper, SafetySettingsLookupService safetySettingsLookupService) {
        super(contributionProvider, installationModifier, consoleLoggerExceptionHelper);
        this.systemAPI = systemAPI;
        this.consoleLoggerExceptionHelper = consoleLoggerExceptionHelper;
        this.safetySettingsLookupService = safetySettingsLookupService;
    }

    @Override
    protected void initializeInstallationContribution() {
        if (this.service != null) {
            SafetyURCapInstallationContribution installationContribution = (SafetyURCapInstallationContribution)this.getInstallationContribution();
            installationContribution.bindService(this.service);
            this.callConfigureContribution.bindSafetyContribution(installationContribution, this.safetySettingsLookupService.getCaretaker());
        }
    }

    @Override
    public String getTitle() {
        if (this.service == null) {
            return "";
        }
        return this.getServiceName();
    }

    private String getServiceName() {
        Locale locale = this.systemAPI.getSystemSettings().getLocalization().getLocale();
        try {
            return this.service.getTitle(locale);
        }
        catch (RuntimeException e) {
            this.logFailedToGetTitleToConsole(e, this.service.getClass());
            return "";
        }
    }

    @Override
    public void clearInstallationModel(CreationContextHolder contextHolder) {
        if (contextHolder.safetyCreationContext().getSafetyCreationType() == SafetyCreationContext.SafetyCreationType.NEW_AND_RESET) {
            this.installationModel = null;
        }
        this.updateInstallationContribution(contextHolder);
    }

    @Override
    public boolean hasInstallationContribution() {
        return this.service != null || this.installationModel != null;
    }

    @Override
    public void configureInstallation(ContributionConfiguration configuration) {
        if (this.service != null) {
            try {
                this.callConfigureContribution.configureConfiguration();
            }
            catch (RuntimeException e) {
                StackTraceElement exitPoint = this.consoleLoggerExceptionHelper.findCatchingMethod(e, this.getClass().getCanonicalName(), "configureInstallation");
                this.consoleLoggerExceptionHelper.logToConsole(e, this.service.getClass(), exitPoint);
                this.configurationException = e;
            }
        }
    }

    public void setSafetyNodeService(SafetyNodeService service, SafetyEquipmentContributionService safetyEquipmentContributionService) {
        this.service = service;
        this.callConfigureContribution = new CallConfigureContribution(service, safetyEquipmentContributionService);
    }
}

