/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.InstallationNodeInfo;
import com.ur.polyscope.installation.contribution.HideableInstallationNodeContribution;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.TypedOptionsSection;
import com.ur.polyscope.persistence.versioning.Version;
import com.ur.polyscope.persistence.versioning.Versioned;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.urcap.URCapScriptWriter;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.urcaps.domain.DataModelWriter;
import com.ur.polyscope.urcaps.nodeservices.EmbeddedProxiedService;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.contribution.DataModelXMLConversionStrategy;
import com.ur.urcap.contribution.URCapSortable;
import com.ur.urcap.contribution.installation.ContributionResourceCleaner;
import com.ur.urcap.contribution.installation.CreationContextFactory;
import com.ur.urcap.contribution.installation.EthernetipAsURCapLoader;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.urcap.contribution.installation.MissingURCapInstallationNode;
import com.ur.urcap.contribution.installation.ProfinetAsURCapLoader;
import com.ur.urcap.contribution.installation.SafetyURCapInstallationNode;
import com.ur.urcap.contribution.installation.URCapInstallation;
import com.ur.urcap.contribution.installation.URCapInstallationNodeDataComparator;
import com.ur.urcap.contribution.installation.URCapInstallationNodeHtml;
import com.ur.urcap.contribution.installation.URCapInstallationNodeSwing;
import com.ur.urcap.contribution.installation.URCapInstallationOptionsConversionStrategy;
import com.ur.urcap.contribution.installation.URCapInstallationProvider;
import com.ur.urcap.contribution.installation.URCapInstallationXMLConversionStrategy;
import com.ur.urcap.contribution.installation.URCapsInstallationTab;
import com.ur.urcap.contribution.installation.UnmarshalledURCapInstallationData;
import com.ur.util.event.EventNotificationService;
import com.ur.util.swing.HTML;
import com.ur.view.polyscope.module.UIInstallationNode;
import com.ur.view.polyscope.module.UserToCardPanelProvider;
import com.ur.view.polyscope.module.installation.InstallationModule;
import gui.installation.ContributionStateListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class URCapInstallationModule
extends InstallationNode
implements InstallationModule {
    private final URCapInstallationOptionsConversionStrategy urCapInstallationOptionsConversionStrategy = new URCapInstallationOptionsConversionStrategy();
    private final List<URCapInstallation> missingURCaps = new ArrayList<URCapInstallation>();
    private final CreationContextFactory creationContextFactory = new CreationContextFactory();
    private URCapInstallationProvider provider;
    private URCapInstallationXMLConversionStrategy urCapInstallationXMLConversionStrategy;
    private InstallationLoadingContext installationLoadingContext;
    private ProfinetAsURCapLoader profinetAsURCapLoader;
    private EthernetipAsURCapLoader ethernetipAsURCapLoader;
    private ContributionResourceCleaner contributionResourceCleaner;

    @Inject
    public void setInstallationServices(ContributionResourceCleaner contributionResourceCleaner) {
        this.contributionResourceCleaner = contributionResourceCleaner;
    }

    @Inject
    public void setProfinetAndEthernetIP(ProfinetAsURCapLoader profinetAsURCapLoader, EthernetipAsURCapLoader ethernetipAsURCapLoader) {
        this.profinetAsURCapLoader = profinetAsURCapLoader;
        this.ethernetipAsURCapLoader = ethernetipAsURCapLoader;
    }

    @Inject
    public void setURCapProvider(URCapInstallationProvider provider) {
        this.provider = provider;
        this.missingURCaps.clear();
    }

    @Inject
    public void setURCapInfrastructure(Set<DataModelWriter> writers, DataModelXMLConversionStrategy conversionStrategy, InstallationLoadingContext installationLoadingContext) {
        this.installationLoadingContext = installationLoadingContext;
        this.urCapInstallationXMLConversionStrategy = new URCapInstallationXMLConversionStrategy(conversionStrategy, writers);
    }

    public void registerCardPanel(FlipManager flipManager) {
        flipManager.addCardPanel((CardPanel)new URCapsInstallationTab(this, this.installationLoadingContext));
    }

    public void registerUserTypeToCardPanel(UserToCardPanelProvider userToCardProvider) {
        userToCardProvider.getUserTypeToCardPanel(URCapInstallationNodeHtml.class, URCapsInstallationTab.class);
        userToCardProvider.getUserTypeToCardPanel(URCapInstallationNodeSwing.class, URCapsInstallationTab.class);
        userToCardProvider.getUserTypeToCardPanel(SafetyURCapInstallationNode.class, URCapsInstallationTab.class);
        userToCardProvider.getUserTypeToCardPanel(MissingURCapInstallationNode.class, URCapsInstallationTab.class);
    }

    public boolean doesURCapInstallationExist(URCapInstallation urCapInstallation) {
        return this.getAllInstallationURCaps().contains(urCapInstallation);
    }

    private List<UIInstallationNode> getSortedUIInstallationNodes(List<URCapInstallation> installationContributions) {
        ArrayList<SortableAdapter> sortableList = new ArrayList<SortableAdapter>();
        for (URCapInstallation installation : installationContributions) {
            SortableAdapter sortable = new SortableAdapter(installation);
            sortableList.add(sortable);
        }
        Collections.sort(sortableList, new URCapInstallationNodeDataComparator());
        ArrayList<UIInstallationNode> sortedUIInstallationNodes = new ArrayList<UIInstallationNode>();
        for (SortableAdapter s : sortableList) {
            if (!s.getUrCapInstallation().hasInstallationContribution()) continue;
            sortedUIInstallationNodes.add(new URCapNode(s.getUrCapInstallation(), s.getUrCapInstallation()));
        }
        return sortedUIInstallationNodes;
    }

    public List<UIInstallationNode> getUIInstallationNodes() {
        List<URCapInstallation> installationContributions = this.provider.getInstallationContributions();
        this.removeScrewdrivingDriverContributions(installationContributions);
        URCapInstallationModule.removeEmptyDriverContributions(installationContributions);
        installationContributions.addAll(this.missingURCaps);
        return this.getSortedUIInstallationNodes(installationContributions);
    }

    private static void removeEmptyDriverContributions(List<URCapInstallation> installationContributions) {
        Iterator<URCapInstallation> iterator = installationContributions.iterator();
        while (iterator.hasNext()) {
            InstallationContribution installationContribution = iterator.next().getInstallationContribution();
            if (!URCapInstallationModule.isHidden(installationContribution.getUserContribution()) || installationContribution.hasError()) continue;
            iterator.remove();
        }
    }

    private static boolean isHidden(InstallationNodeContribution installationNodeContribution) {
        return installationNodeContribution instanceof HideableInstallationNodeContribution && ((HideableInstallationNodeContribution)installationNodeContribution).isHidden();
    }

    private void removeScrewdrivingDriverContributions(List<URCapInstallation> installationContributions) {
        Iterator<URCapInstallation> iterator = installationContributions.iterator();
        while (iterator.hasNext()) {
            InstallationContribution installationContribution = iterator.next().getInstallationContribution();
            if (!EmbeddedProxiedService.class.isAssignableFrom(installationContribution.getInstallationNodeServiceClass())) continue;
            iterator.remove();
        }
    }

    public void removeUIInstallationNode(UIInstallationNode uiInstallationNode) {
        URCapInstallation urCapInstallation = (URCapInstallation)uiInstallationNode.getInstallation();
        this.removeMissingURCap(urCapInstallation);
        String ownerId = urCapInstallation.getURCapInformation().getOwnerId();
        this.contributionResourceCleaner.cleanContributionByOwner(ownerId);
        this.fireContributionChangedEvent();
    }

    void removeMissingURCap(URCapInstallation urCapInstallation) {
        this.missingURCaps.remove(urCapInstallation);
    }

    private void fireContributionChangedEvent() {
        EventNotificationService.notify(ContributionStateListener.class, listener -> {
            listener.preContributionModified();
            listener.contributionModified();
            listener.postContributionModified();
        });
    }

    public void marshal(Object toMarshal, PersistWriter writer) {
        this.urCapInstallationXMLConversionStrategy.marshal(writer, this.getAllInstallationURCaps());
    }

    public Object unmarshal(PersistReader reader) {
        Map<String, UnmarshalledURCapInstallationData> installationDataMap = this.unmarshalInstallationDataMap(reader);
        this.profinetAsURCapLoader.loadLegacyProfinetData(installationDataMap);
        this.ethernetipAsURCapLoader.loadLegacyEthernetIPData(installationDataMap);
        this.updateInstalledURCaps(installationDataMap);
        this.createMissingURCapsIfAny(installationDataMap);
        return this;
    }

    private Map<String, UnmarshalledURCapInstallationData> unmarshalInstallationDataMap(PersistReader reader) {
        if (reader == null) {
            return new HashMap<String, UnmarshalledURCapInstallationData>();
        }
        return this.urCapInstallationXMLConversionStrategy.canUnmarshalFrom(reader) ? this.urCapInstallationXMLConversionStrategy.unmarshal(reader) : this.urCapInstallationOptionsConversionStrategy.unmarshal(reader);
    }

    private void updateInstalledURCaps(Map<String, UnmarshalledURCapInstallationData> installationDataMap) {
        for (URCapInstallation urCapInstallation : this.provider.getInstallationContributions()) {
            String id = urCapInstallation.getId();
            String symbolicName = urCapInstallation.getURCapInformation().getSymbolicName();
            UnmarshalledURCapInstallationData unmarshaledData = null;
            if (installationDataMap.containsKey(id)) {
                unmarshaledData = installationDataMap.get(id);
                this.updateModelAndInfo(unmarshaledData, urCapInstallation);
                installationDataMap.remove(id);
            } else if (installationDataMap.containsKey(symbolicName)) {
                unmarshaledData = installationDataMap.get(symbolicName);
                this.updateModelAndInfo(unmarshaledData, urCapInstallation);
                installationDataMap.remove(symbolicName);
            } else {
                this.updateURCapInformation(urCapInstallation);
                urCapInstallation.clearInstallationModel(this.creationContextFactory.createContextFrom(null));
            }
            this.updateVersion(unmarshaledData, urCapInstallation);
        }
    }

    void updateVersion(UnmarshalledURCapInstallationData unmarshaledData, URCapInstallation urCapInstallation) {
        InstallationNodeContribution contribution;
        if (unmarshaledData != null && (contribution = urCapInstallation.getInstallationContribution().getUserContribution()) instanceof Versioned) {
            Versioned versioned = (Versioned)contribution;
            Version version = unmarshaledData.getVersion();
            versioned.setVersion(version);
        }
    }

    private void updateURCapInformation(URCapInstallation each) {
        URCapInformation urCapInformation = each.getURCapInformation();
        urCapInformation.setInstallationContributionTitle(each.getInstallationContributionTitle());
    }

    private void updateModelAndInfo(UnmarshalledURCapInstallationData installationData, URCapInstallation each) {
        TypedOptionsSection options = installationData.getUnmarshalledDataModel().getOptions();
        each.setInstallationModel(options, this.creationContextFactory.createContextFrom(options));
        URCapInstallationModule.setURCapInformation(installationData, each);
    }

    private static void setURCapInformation(UnmarshalledURCapInstallationData installationData, URCapInstallation each) {
        URCapInformation urCapInformation = each.getURCapInformation();
        urCapInformation.setInstallationContributionTitle(each.getInstallationContributionTitle());
        urCapInformation.setName(installationData.getName());
        urCapInformation.setVendor(installationData.getVendor());
    }

    private URCapInformation createURCapInformation(UnmarshalledURCapInstallationData installationData) {
        return new URCapInformation(installationData.getOwnerId(), installationData.getInstallationNodeServiceTitle(), installationData.getName(), installationData.getVendor());
    }

    private void createMissingURCapsIfAny(Map<String, UnmarshalledURCapInstallationData> installationDataMap) {
        this.missingURCaps.clear();
        if (installationDataMap != null) {
            for (Map.Entry<String, UnmarshalledURCapInstallationData> each : installationDataMap.entrySet()) {
                this.addMissingURCap(this.createMissingURCap(each.getKey(), each.getValue()));
            }
        }
    }

    private URCapInstallation createMissingURCap(String key, UnmarshalledURCapInstallationData installationData) {
        TypedOptionsSection optionsSection = installationData.getUnmarshalledDataModel().getOptions();
        URCapInformation urCapInformation = this.createURCapInformation(installationData);
        return this.provider.createMissingUrcap(key, urCapInformation, optionsSection, this.createRemoveCallback());
    }

    private MissingURCapInstallationNode.Callback createRemoveCallback() {
        return this::removeUIInstallationNode;
    }

    public void clearData() {
        for (URCapInstallation each : this.provider.getInstallationContributions()) {
            each.clearInstallationModel(this.creationContextFactory.createContextFrom(null));
        }
        this.missingURCaps.clear();
        this.fireContributionChangedEvent();
    }

    public String getTypeName() {
        return this.getModuleName();
    }

    public com.ur.polyscope.scriptwriter.ScriptWriter generatePreambleScript(com.ur.polyscope.scriptwriter.ScriptWriter writer) {
        return writer;
    }

    private void generateInstallationContributionPreambleScript(URCapInstallation urCap, com.ur.polyscope.scriptwriter.ScriptWriter writer) {
        this.getScriptGenerator().scriptBegin(urCap.getScriptGenerator(), writer);
        boolean addURCapInformation = this.shouldAddURCapInformation(urCap);
        if (addURCapInformation) {
            writer.comment("begin: URCap Installation Node");
            writer.comment("  Source: " + urCap.getBundleInfo());
            writer.comment("  Type: " + urCap.getTitle());
        }
        urCap.getInstallationContribution().generatePreambleScript((ScriptWriter)new URCapScriptWriter(writer));
        if (addURCapInformation) {
            writer.comment("end: URCap Installation Node");
        }
        this.getScriptGenerator().scriptEnd(urCap.getScriptGenerator(), writer);
    }

    private boolean shouldAddURCapInformation(URCapInstallation urCap) {
        boolean isURCap = urCap.isThirdPartyURCap();
        boolean isEmbeddedProxy = EmbeddedProxiedService.class.isAssignableFrom(urCap.getInstallationContribution().getInstallationNodeServiceClass());
        return isURCap && !isEmbeddedProxy;
    }

    public void generatePreambleScript(com.ur.polyscope.scriptwriter.ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        this.getScriptGenerator().setScriptGeneratorLookup(scriptGeneratorLookup);
        for (URCapInstallation each : this.provider.getInstallationContributions()) {
            this.generateInstallationContributionPreambleScript(each, writer);
        }
    }

    public Class<Object> getSupportedType() {
        return Object.class;
    }

    public String getModuleName() {
        return "URCaps";
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return true;
    }

    public Map<String, Class<?>> getClassAliases(boolean forMarshalling) {
        return Collections.emptyMap();
    }

    public Map<String, Class<?>> getTypeAliases(boolean forMarshalling) {
        return Collections.emptyMap();
    }

    private List<URCapInstallation> getAllInstallationURCaps() {
        ArrayList<URCapInstallation> result = new ArrayList<URCapInstallation>();
        result.addAll(this.provider.getInstallationContributions());
        result.addAll(this.missingURCaps);
        return result;
    }

    private void addMissingURCap(URCapInstallation urCap) {
        this.missingURCaps.add(urCap);
    }

    static class SortableAdapter
    implements URCapSortable {
        private final URCapInstallation urCapInstallation;

        public SortableAdapter(URCapInstallation urCapInstallation) {
            this.urCapInstallation = urCapInstallation;
        }

        public URCapInstallation getUrCapInstallation() {
            return this.urCapInstallation;
        }

        @Override
        public String getURCapName() {
            return this.urCapInstallation.getURCapInformation().getName();
        }

        @Override
        public String getURCapVendor() {
            return this.urCapInstallation.getURCapInformation().getVendor();
        }

        @Override
        public String getURCapId() {
            return this.urCapInstallation.getId();
        }

        @Override
        public double getSortingId() {
            return 0.0;
        }

        @Override
        public String getContributionTitle() {
            return this.urCapInstallation.getURCapInformation().getInstallationContributionTitle();
        }
    }

    public static final class URCapNode
    extends UIInstallationNode
    implements InstallationNodeInfo {
        private final URCapInstallation urCap;

        public URCapNode(Object installation, URCapInstallation urCap) {
            super(urCap.getId(), installation);
            this.urCap = urCap;
        }

        public String toString() {
            String contributedTitle = null;
            if (this.urCap.getInstallationContribution() != null) {
                contributedTitle = this.urCap.getInstallationContribution().getTitle();
            }
            if (contributedTitle == null || contributedTitle.length() == 0) {
                contributedTitle = this.urCap.getURCapInformation().getInstallationContributionTitle();
            }
            if (contributedTitle != null) {
                return HTML.unHtml((String)contributedTitle);
            }
            return "";
        }

        public boolean hasWarning() {
            return this.urCap instanceof MissingURCapInstallationNode;
        }

        public InstallationNode getInstallationNode() {
            return (InstallationNode)this.urCap;
        }
    }
}

