/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.installation.InstallationModifier;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.installation.ContributionConfiguration;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.SystemAPI;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.installation.AbstractURCapInstallationNodeSwing;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.urcap.contribution.installation.InstallationContributionSwing;
import java.util.Locale;
import javax.inject.Provider;

public class URCapInstallationNodeSwing
extends AbstractURCapInstallationNodeSwing {
    private final SystemAPI systemAPI;
    private final ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper;
    private SwingInstallationNodeService<? extends InstallationNodeContribution, ? extends SwingInstallationNodeView<?>> service;

    public URCapInstallationNodeSwing(Provider<InstallationContribution> contributionProvider, SystemAPI systemAPI, InstallationModifier installationModifier, ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper) {
        super(contributionProvider, installationModifier, consoleLoggerExceptionHelper);
        this.systemAPI = systemAPI;
        this.consoleLoggerExceptionHelper = consoleLoggerExceptionHelper;
    }

    @Override
    public boolean hasInstallationContribution() {
        return this.service != null || this.installationModel != null;
    }

    @Override
    public String getTitle() {
        if (this.service == null) {
            return "";
        }
        return this.getServiceName();
    }

    private String getServiceName() {
        Locale locale = this.systemAPI.getSystemSettings().getLocalization().getLocale();
        try {
            return this.service.getTitle(locale);
        }
        catch (RuntimeException e) {
            this.logFailedToGetTitleToConsole(e, this.service.getClass());
            return "";
        }
    }

    @Override
    public void configureInstallation(ContributionConfiguration configuration) {
        if (this.service != null) {
            try {
                this.service.configureContribution(configuration);
            }
            catch (RuntimeException e) {
                StackTraceElement exitPoint = this.consoleLoggerExceptionHelper.findCatchingMethod(e, this.getClass().getCanonicalName(), "configureInstallation");
                this.consoleLoggerExceptionHelper.logToConsole(e, this.service.getClass(), exitPoint);
                this.configurationException = e;
            }
        }
    }

    @Override
    protected void initializeInstallationContribution() {
        if (this.service != null) {
            InstallationContributionSwing installationContributionSwing = (InstallationContributionSwing)this.contribution;
            installationContributionSwing.bindService(this.service);
        }
    }

    public void setInstallationNodeService(SwingInstallationNodeService<? extends InstallationNodeContribution, ? extends SwingInstallationNodeView<?>> swingInstallationNodeService) {
        this.service = swingInstallationNodeService;
    }
}

