/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.TypedOptionsSection;
import com.ur.polyscope.persistence.XmlSerializable;
import com.ur.polyscope.persistence.versioning.Version;
import com.ur.polyscope.persistence.versioning.Versioned;
import com.ur.polyscope.urcaps.domain.DataModelWriter;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.contribution.DataModelXMLConversionStrategy;
import com.ur.urcap.contribution.UnmarshalledDataModel;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.urcap.contribution.installation.URCapInstallation;
import com.ur.urcap.contribution.installation.UnmarshalledURCapInstallationData;
import com.ur.util.logging.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class URCapInstallationXMLConversionStrategy {
    public static final String ID = "id";
    public static final String DATA_NODE = "data";
    public static final String DATA_KEY = "key";
    public static final String DATA_VALUE = "value";
    public static final String CONTRIBUTED_NODE = "Contributed";
    public static final Version NO_VERSION = new Version(0, 0);
    public static final String VERSION_ATTR = "version";
    private DataModelXMLConversionStrategy dataModelConversionStrategy;
    private final Set<DataModelWriter> writers;

    public URCapInstallationXMLConversionStrategy(DataModelXMLConversionStrategy conversionStrategy, Set<DataModelWriter> writers) {
        this.dataModelConversionStrategy = conversionStrategy;
        this.writers = writers;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader != null && reader.hasMoreNodes();
    }

    public void marshal(PersistWriter writer, List<URCapInstallation> URCaps) {
        for (URCapInstallation each : URCaps) {
            this.tryToWriteURCap(each, writer);
        }
    }

    private void tryToWriteURCap(URCapInstallation urcap, PersistWriter writer) {
        TypedOptionsSection optionsSection = urcap.getInstallationModel();
        String ownerId = urcap.getURCapInformation().getOwnerId();
        String vendor = urcap.getURCapInformation().getVendor();
        String installationNodeServiceTitle = urcap.getURCapInformation().getInstallationContributionTitle();
        String name = urcap.getURCapInformation().getName();
        writer.startNode(CONTRIBUTED_NODE);
        this.writeVersion(urcap, writer);
        this.addAttribute(writer, "ownerId", ownerId);
        this.addAttribute(writer, ID, urcap.getId());
        this.addAttribute(writer, "installationContributionTitle", installationNodeServiceTitle);
        this.addAttribute(writer, "vendor", vendor);
        this.addAttribute(writer, "name", name);
        Iterator iterator = optionsSection.getPrimitivesIterator();
        this.writePrimitiveData(iterator, writer);
        Iterator typedIterator = optionsSection.getTypedIterator();
        this.writeTypedData(typedIterator, writer);
        writer.endNode();
    }

    public void writePrimitiveData(Iterator<Map.Entry<String, String>> iterator, PersistWriter writer) {
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            this.writeElement(writer, DATA_NODE, entry.getKey(), entry.getValue());
        }
    }

    public void writeTypedData(Iterator<Map.Entry<String, Object>> iterator, PersistWriter writer) {
        block0: while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            Object value = next.getValue();
            if (value instanceof XmlSerializable) {
                ((XmlSerializable)value).write(writer, next.getKey());
                continue;
            }
            for (DataModelWriter each : this.writers) {
                if (!each.canWrite(value)) continue;
                each.writeKeyValue(value, next.getKey(), writer);
                continue block0;
            }
        }
    }

    public void writeElement(PersistWriter writer, String nodeName, String key, String value) {
        writer.startNode(nodeName);
        this.addAttribute(writer, DATA_KEY, key);
        this.addAttribute(writer, DATA_VALUE, value);
        writer.endNode();
    }

    private void addAttribute(PersistWriter writer, String att, String value) {
        if (value != null && !value.isEmpty()) {
            writer.addAttribute(att, value);
        }
    }

    public Map<String, UnmarshalledURCapInstallationData> unmarshal(PersistReader reader) {
        HashMap<String, UnmarshalledURCapInstallationData> idDataMap = new HashMap<String, UnmarshalledURCapInstallationData>();
        while (reader.hasMoreNodes()) {
            this.readContributed(reader, idDataMap);
        }
        return idDataMap;
    }

    private void readContributed(PersistReader reader, Map<String, UnmarshalledURCapInstallationData> idDataMap) {
        reader.moveToChildNode();
        if (reader.isNode(CONTRIBUTED_NODE)) {
            String ownerId = reader.getStringAttribute("ownerId");
            String id = reader.getStringAttribute(ID);
            String installationNodeServiceTitle = reader.getStringAttribute("installationContributionTitle");
            String vendor = reader.getStringAttribute("vendor");
            String name = reader.getStringAttribute("name");
            String versionString = reader.getStringAttribute(VERSION_ATTR);
            UnmarshalledURCapInstallationData unmarshalledUrCapInstallationData = new UnmarshalledURCapInstallationData(ownerId, name, vendor, installationNodeServiceTitle);
            idDataMap.put(id, unmarshalledUrCapInstallationData);
            UnmarshalledDataModel unmarshalledDataModel = this.dataModelConversionStrategy.readData(reader);
            unmarshalledUrCapInstallationData.setUnmarshalledDataModel(unmarshalledDataModel);
            Version version = this.parseVersion(versionString);
            unmarshalledUrCapInstallationData.setVersion(version);
        }
        reader.moveToParentNode();
    }

    protected void writeVersion(URCapInstallation each, PersistWriter writer) {
        InstallationContribution installationContribution = each.getInstallationContribution();
        if (installationContribution == null) {
            return;
        }
        InstallationNodeContribution userContribution = installationContribution.getUserContribution();
        if (userContribution == null) {
            return;
        }
        if (userContribution instanceof Versioned) {
            Versioned versioned = (Versioned)userContribution;
            Version version = versioned.getVersion();
            if (NO_VERSION.equals((Object)version)) {
                return;
            }
            writer.addAttribute(VERSION_ATTR, version.getMajor() + "." + version.getMinor());
        }
    }

    protected Version parseVersion(String versionString) {
        Version version = NO_VERSION;
        if (versionString == null) {
            return version;
        }
        String[] split = versionString.split("\\.");
        if (split.length != 2) {
            return version;
        }
        try {
            int major = Integer.parseInt(split[0]);
            int minor = Integer.parseInt(split[1]);
            version = new Version(major, minor);
        }
        catch (NumberFormatException e) {
            Log.warning((String)("Can't parse version attribute " + versionString), (Throwable)e);
        }
        return version;
    }
}

