/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.swing.CardPanel;
import com.ur.urcap.contribution.installation.InstallationContribution;
import com.ur.urcap.contribution.installation.URCapInstallation;
import com.ur.urcap.contribution.installation.URCapInstallationModule;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.gui.OpenCloseVeto;
import java.awt.CardLayout;
import java.awt.Container;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class URCapsInstallationTab
extends CardPanel
implements OpenCloseVeto {
    private static final String EMPTY_PANEL_NAME = "<EMPTY>";
    private final CardLayout cards;
    private final URCapInstallationModule urCapInstallationModule;
    private InstallationLoadingContext installationLoadingContext;
    private URCapInstallation currentURCapInstallation;
    private boolean vetoOpen = false;
    private boolean vetoClose = false;

    @Inject
    public URCapsInstallationTab(URCapInstallationModule urCapInstallationModule, InstallationLoadingContext installationLoadingContext) {
        this.urCapInstallationModule = urCapInstallationModule;
        this.installationLoadingContext = installationLoadingContext;
        this.cards = new CardLayout();
        this.setLayout(this.cards);
        this.add(new JPanel(), EMPTY_PANEL_NAME);
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)((Object)new LoadListener()));
    }

    public void enter(Object o) {
        super.enter(o);
        try {
            if (!this.vetoOpen) {
                this.doEnter(o);
            }
        }
        finally {
            this.vetoOpen = false;
        }
    }

    private void doEnter(Object o) {
        if (o instanceof URCapInstallation) {
            this.exitCurrentURCapInstallation();
            this.currentURCapInstallation = (URCapInstallation)o;
            boolean success = false;
            InstallationContribution installationContribution = this.currentURCapInstallation.getInstallationContribution();
            try {
                if (!installationContribution.hasError()) {
                    success = installationContribution.enterView() && this.showUIPanel(installationContribution);
                }
            }
            catch (Exception e) {
                Log.error((String)"Exception occurred opening URCap view", (Throwable)e);
                success = this.showEmptyPanel();
            }
            if (!success) {
                this.removeAll();
                this.add(installationContribution.getErrorView());
                this.updateUI();
            }
        } else {
            this.showEmptyPanel();
        }
    }

    private boolean showUIPanel(InstallationContribution installationContribution) {
        try {
            this.removeAll();
            JComponent component = installationContribution.getComponent();
            if (component != null) {
                this.add(component, this.currentURCapInstallation.getId());
                this.cards.show((Container)((Object)this), this.currentURCapInstallation.getId());
            } else if (installationContribution.hasError()) {
                this.add(installationContribution.getErrorView());
            } else {
                this.showEmptyPanel();
            }
        }
        finally {
            this.revalidate();
            this.repaint();
        }
        return true;
    }

    public Object exit() {
        try {
            if (!this.vetoClose) {
                this.exitCurrentURCapInstallation();
            }
        }
        finally {
            this.vetoClose = false;
        }
        return super.exit();
    }

    private void exitCurrentURCapInstallation() {
        if (this.currentURCapInstallation != null) {
            try {
                InstallationContribution installationContribution = this.currentURCapInstallation.getInstallationContribution();
                installationContribution.exitView();
            }
            catch (Exception e) {
                Log.error((String)"Error exiting URCap view", (Throwable)e);
            }
            this.currentURCapInstallation = null;
        }
    }

    private boolean showEmptyPanel() {
        this.cards.show((Container)((Object)this), EMPTY_PANEL_NAME);
        return true;
    }

    public void vetoCloseOpenOnce() {
        this.vetoOpen = true;
        this.vetoClose = true;
    }

    public void revokeVeto() {
        this.vetoOpen = false;
        this.vetoClose = false;
    }

    public InstallationContribution getCurrentURCapInstallationContribution() {
        return this.currentURCapInstallation != null ? this.currentURCapInstallation.getInstallationContribution() : null;
    }

    private class LoadListener
    extends InstallationStateListener.Template {
        private LoadListener() {
        }

        public void installationLoaded(Installation installation) {
            if (URCapsInstallationTab.this.currentURCapInstallation != null) {
                URCapsInstallationTab.this.installationLoadingContext.setLoading(false);
                this.reselect();
            }
        }

        private void reselect() {
            URCapInstallation toBeReselected = URCapsInstallationTab.this.currentURCapInstallation;
            URCapsInstallationTab.this.exit();
            if (URCapsInstallationTab.this.urCapInstallationModule.doesURCapInstallationExist(toBeReselected)) {
                URCapsInstallationTab.this.enter(toBeReselected);
            } else {
                URCapsInstallationTab.this.showEmptyPanel();
            }
        }
    }
}

