/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.installation.internal;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.urcaps.contributions.URCap;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.urcaps.contributions.URCapProvider;
import com.ur.polyscope.urcaps.nodeservices.ProxiedService;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.InstallationNodeService;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyNodeContribution;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyNodeService;
import com.ur.urcap.contribution.installation.InstallationNodeContributionConfiguration;
import com.ur.urcap.contribution.installation.SafetyURCapInstallationNode;
import com.ur.urcap.contribution.installation.URCapInstallation;
import com.ur.urcap.contribution.installation.URCapInstallationFactory;
import com.ur.urcap.contribution.installation.URCapInstallationNodeHtml;
import com.ur.urcap.contribution.installation.URCapInstallationNodeSwing;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@Singleton
public class InstallationURCapProvider
implements URCapProvider {
    private static final String UNIVERSAL_ROBOTS = "Universal Robots";
    private static final Logger LOGGER = LogFactory.createLogger(InstallationURCapProvider.class);
    private final URCapInstallationFactory urcapInstallationFactory;
    private final FrameworkAdapter frameworkAdapter;
    private final SafetyEquipmentContributionService safetyEquipmentContributionService;

    @Inject
    public InstallationURCapProvider(FrameworkAdapter frameworkAdapter, URCapInstallationFactory installationFactory, SafetyEquipmentContributionService safetyEquipmentContributionService) {
        this.frameworkAdapter = frameworkAdapter;
        this.urcapInstallationFactory = installationFactory;
        this.safetyEquipmentContributionService = safetyEquipmentContributionService;
    }

    public Collection<URCap> getURCaps() {
        HashSet<URCap> result = new HashSet<URCap>();
        try {
            this.updateInstallationNodes(result);
        }
        catch (InvalidSyntaxException ise) {
            LOGGER.error("Failed to fetch contributions", (Throwable)ise);
        }
        for (URCap each : CollectionUtils.filter(result, (Predicate)new InstallationContributions())) {
            this.safetyEquipmentContributionService.setActiveURCap(each.getURCapInformation());
            InstallationNodeContributionConfiguration installationNodeContributionConfiguration = new InstallationNodeContributionConfiguration();
            ((URCapInstallation)each).configureInstallation(installationNodeContributionConfiguration);
        }
        return result;
    }

    private void updateInstallationNodes(Set<URCap> contributions) throws InvalidSyntaxException {
        Bundle bundle;
        InstallationNodeService service;
        BundleContext context = this.frameworkAdapter.getBundle(this.getClass()).getBundleContext();
        for (ServiceReference<InstallationNodeService> serviceReference : this.fetchReferences(InstallationNodeService.class, context)) {
            service = (InstallationNodeService)context.getService(serviceReference);
            bundle = serviceReference.getBundle();
            URCapInstallation urCapInstallationNode = this.createURCapInstallationNode(bundle, service);
            contributions.add(urCapInstallationNode);
        }
        for (ServiceReference<InstallationNodeService> serviceReference : this.fetchReferences(SwingInstallationNodeService.class, context)) {
            service = (SwingInstallationNodeService)context.getService(serviceReference);
            bundle = this.fetchBundle(serviceReference, service);
            contributions.add(this.createURCapInstallationNode(bundle, (SwingInstallationNodeService<? extends InstallationNodeContribution, ? extends SwingInstallationNodeView<?>>)service));
        }
        for (ServiceReference<InstallationNodeService> serviceReference : this.fetchReferences(SafetyNodeService.class, context)) {
            service = (SafetyNodeService)context.getService(serviceReference);
            bundle = this.fetchBundle(serviceReference, service);
            contributions.add(this.createURCapInstallationNode(bundle, (SafetyNodeService<? extends SafetyNodeContribution, ? extends SwingInstallationNodeView<?>>)service));
        }
    }

    private <T> Iterable<ServiceReference<T>> fetchReferences(Class<T> type, BundleContext context) throws InvalidSyntaxException {
        return context.getServiceReferences(type, null);
    }

    private <T> Bundle fetchBundle(ServiceReference<T> ref, T service) {
        if (service instanceof ProxiedService) {
            return this.frameworkAdapter.getBundle(((ProxiedService)service).getProxiedService());
        }
        return ref.getBundle();
    }

    private URCapInstallation createURCapInstallationNode(Bundle bundle, InstallationNodeService service) {
        URCapInformation urCapInformation = InstallationURCapProvider.createURCapInformation(bundle);
        String id = this.getId(service, urCapInformation);
        URCapInstallationNodeHtml urCapInstallationNode = this.urcapInstallationFactory.createURCapInstallationNodeHtml();
        urCapInstallationNode.setId(id);
        urCapInstallationNode.setInstallationNodeService(service);
        urCapInstallationNode.setURCapInformation(urCapInformation);
        return urCapInstallationNode;
    }

    private URCapInstallation createURCapInstallationNode(Bundle bundle, SwingInstallationNodeService<? extends InstallationNodeContribution, ? extends SwingInstallationNodeView<?>> service) {
        URCapInformation urCapInformation = InstallationURCapProvider.createURCapInformation(bundle);
        String id = this.getId(service, urCapInformation);
        URCapInstallationNodeSwing urCapInstallationNode = this.urcapInstallationFactory.createURCapInstallationNodeSwing();
        urCapInstallationNode.setId(id);
        urCapInstallationNode.setInstallationNodeService(service);
        urCapInstallationNode.setURCapInformation(urCapInformation);
        return urCapInstallationNode;
    }

    private URCapInstallation createURCapInstallationNode(Bundle bundle, SafetyNodeService<? extends SafetyNodeContribution, ? extends SwingInstallationNodeView<?>> service) {
        URCapInformation urCapInformation = InstallationURCapProvider.createURCapInformation(bundle);
        String id = this.getId(service, urCapInformation);
        SafetyURCapInstallationNode urCapInstallationNode = this.urcapInstallationFactory.createSafetyURCapInstallationNode();
        urCapInstallationNode.setId(id);
        urCapInstallationNode.setSafetyNodeService(service, this.safetyEquipmentContributionService);
        urCapInstallationNode.setURCapInformation(urCapInformation);
        return urCapInstallationNode;
    }

    private String getId(Object service, URCapInformation urCapInformation) {
        String id = service instanceof ProxiedService ? ((ProxiedService)service).getProxiedId() : this.getLegacyName(service.getClass().getName(), urCapInformation);
        return id;
    }

    private String getLegacyName(String name, URCapInformation urCapInformation) {
        if (urCapInformation.getVendor().equals(UNIVERSAL_ROBOTS)) {
            if (name.toLowerCase().contains("ethernetip")) {
                return "EthernetIP";
            }
            if (name.toLowerCase().contains("conveyortracking")) {
                return "ConveyorTracking";
            }
            if (name.toLowerCase().contains("profinet")) {
                return "com.ur.urcap.profinet";
            }
        }
        return name;
    }

    private static URCapInformation createURCapInformation(Bundle bundle) {
        Dictionary headers = null;
        if (bundle != null) {
            headers = bundle.getHeaders();
        }
        return new URCapInformation(InstallationURCapProvider.dictionary2map(headers));
    }

    private static Map<String, String> dictionary2map(Dictionary<String, String> dictionary) {
        if (dictionary == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.put(key, dictionary.get(key));
        }
        return result;
    }

    private static class InstallationContributions
    implements Predicate<URCap> {
        private InstallationContributions() {
        }

        public boolean test(URCap urcap) {
            return urcap instanceof URCapInstallation && ((URCapInstallation)urcap).hasInstallationContribution();
        }
    }
}

