/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.internal;

import com.ur.i18n.TextResource;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.urcaps.ExceptionHandler;
import com.ur.polyscope.urcaps.URCapErrorHandler;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.WaitingOnMainUI;
import com.ur.urcap.contribution.internal.ExceptionReportRobotMessage;
import com.ur.urcap.contribution.internal.ExceptionRobotMessageBuilder;
import com.ur.util.Waiting;
import com.ur.view.DialogWithName;
import gui.polyscope.InstallationTreeSelector;
import gui.tools.DialogCreator;
import gui.tools.dialogs.MessageDialogPanel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;

public class ExceptionHandlingImpl
implements ExceptionHandling,
ExceptionHandler {
    private final DialogCreator dialogCreator;
    private Provider<InstallationTreeSelector> installationTreeSelectorProvider;
    private final com.ur.polyscope.urcaps.ExceptionHandling extractedExceptionHandling;
    private final URCapErrorHandler urCapErrorHandler;
    private final Provider<ExceptionRobotMessageBuilder> robotMessageBuilderProvider;
    private final WaitingOnMainUI waitingOnMainUI;
    private TextResource textResource;

    @Inject
    public ExceptionHandlingImpl(DialogCreator dialogCreator, Provider<InstallationTreeSelector> installationTreeSelectorProvider, com.ur.polyscope.urcaps.ExceptionHandling extractedExceptionHandling, URCapErrorHandler urCapErrorHandler, Provider<ExceptionRobotMessageBuilder> robotMessageBuilderProvider, WaitingOnMainUI waitingOnMainUI, TextResource textResource) {
        this.dialogCreator = dialogCreator;
        this.installationTreeSelectorProvider = installationTreeSelectorProvider;
        this.extractedExceptionHandling = extractedExceptionHandling;
        this.urCapErrorHandler = urCapErrorHandler;
        this.robotMessageBuilderProvider = robotMessageBuilderProvider;
        this.waitingOnMainUI = waitingOnMainUI;
        this.textResource = textResource;
    }

    public void handleException(Throwable e, StackTraceElement exitPoint, Class classInBundle) {
        this.showURCapExceptionDialog(e, exitPoint, classInBundle);
    }

    @Override
    public void showURCapExceptionDialog(final Throwable e, final StackTraceElement exitPoint, final Class classInBundle) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExceptionHandlingImpl.this.waitUntilReady();
                ExceptionHandlingImpl.this.showDialogInUIThread(e, exitPoint, classInBundle, true);
            }
        }).start();
    }

    @Override
    public void showURCapExceptionDialogWithoutFlightReport(final Throwable e, final StackTraceElement exitPoint, final Class classInBundle) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExceptionHandlingImpl.this.waitUntilReady();
                ExceptionHandlingImpl.this.showDialogInUIThread(e, exitPoint, classInBundle, false);
            }
        }).start();
    }

    @Override
    public void recordURCapExceptionInFlightReport(final Throwable exception, final StackTraceElement exitPoint, final Class<?> classInBundle) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExceptionHandlingImpl.this.waitUntilReady();
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExceptionRobotMessageBuilder messageBuilder = (ExceptionRobotMessageBuilder)ExceptionHandlingImpl.this.robotMessageBuilderProvider.get();
                        messageBuilder.with(exception, exitPoint, classInBundle);
                        ExceptionReportRobotMessage detailedMessage = messageBuilder.buildFlightReportRobotMessage();
                        detailedMessage.notifyAllSubscribersAndShowFlightReport();
                    }
                });
            }
        }).start();
    }

    private void waitUntilReady() {
        Waiting.until((Waiting.ItHappens)this.waitingOnMainUI, (int)2, (TimeUnit)TimeUnit.MINUTES);
    }

    private void showDialogInUIThread(final Throwable e, final StackTraceElement exitPoint, final Class classInBundle, final boolean showFlightReport) {
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ExceptionHandlingImpl.this.showDialogAndNotify(e, exitPoint, classInBundle, showFlightReport);
            }
        });
    }

    private void showDialogAndNotify(Throwable exception, StackTraceElement exitPoint, Class<?> classInBundle, boolean showFlightReport) {
        ExceptionRobotMessageBuilder messageBuilder = (ExceptionRobotMessageBuilder)this.robotMessageBuilderProvider.get();
        messageBuilder.with(exception, exitPoint, classInBundle);
        ExceptionReportRobotMessage detailedMessage = messageBuilder.buildFlightReportRobotMessage();
        if (showFlightReport) {
            detailedMessage.notifyAllSubscribersAndShowFlightReport();
        } else {
            detailedMessage.notifyAllSubscribers();
        }
        this.showDialog(messageBuilder);
        ((InstallationTreeSelector)this.installationTreeSelectorProvider.get()).revalidateTree();
    }

    void showDialog(ExceptionRobotMessageBuilder messageBuilder) {
        RobotMessage dialogMessage = messageBuilder.build();
        String stackTrace = messageBuilder.getStackTrace();
        Map<String, String> urCapInfoMap = messageBuilder.getUrCapInfoMap();
        MessageDialogPanel panel = MessageDialogPanel.createWarningDialog((String)this.createDialogTitle(messageBuilder.getException()), urCapInfoMap, (String)stackTrace, (String)"", null, (String)this.textResource.AdvancedViewStackTrace(), (RobotMessage)dialogMessage);
        ErrorMessage errorMessage = new ErrorMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), this.textResource.urcapUnhandledexception(), "", "");
        errorMessage.setId(stackTrace.hashCode());
        this.dialogCreator.showErrorMessageWithCustomPanel((DialogMessage)errorMessage, (URDialogPanel)panel, null);
    }

    private String createDialogTitle(Throwable exception) {
        return this.replaceFullClassNameWithSimpleName(exception);
    }

    private String replaceFullClassNameWithSimpleName(Throwable exception) {
        String canonicalName = exception.getClass().getCanonicalName();
        String simpleName = exception.getClass().getSimpleName();
        return exception.toString().replaceFirst(canonicalName, simpleName);
    }

    @Override
    public String getStackTraceOutsidePolyScope(Throwable e, StackTraceElement javaFrameworkExitPoint) {
        return this.extractedExceptionHandling.getStackTraceOutsidePolyScope(e, javaFrameworkExitPoint);
    }

    @Override
    public URCapErrorHandler getUrCapErrorHandler() {
        return this.urCapErrorHandler;
    }
}

