/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.internal;

import com.ur.polyscope.urcaps.ExceptionLogger;
import com.ur.swing.SwingUtil;
import com.ur.urcap.contribution.internal.ExceptionReportRobotMessage;
import com.ur.urcap.contribution.internal.ExceptionRobotMessageBuilder;
import com.ur.util.Waiting;
import gui.main.URGUI;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ExceptionLoggerImpl
implements ExceptionLogger {
    private final Provider<ExceptionRobotMessageBuilder> robotMessageBuilderProvider;

    @Inject
    public ExceptionLoggerImpl(Provider<ExceptionRobotMessageBuilder> robotMessageBuilderProvider) {
        this.robotMessageBuilderProvider = robotMessageBuilderProvider;
    }

    public void log(final Throwable exception, final StackTraceElement exitPoint, final Class<?> classInBundle) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExceptionLoggerImpl.this.waitUntilPolyScopeInitialized();
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExceptionRobotMessageBuilder messageBuilder = (ExceptionRobotMessageBuilder)ExceptionLoggerImpl.this.robotMessageBuilderProvider.get();
                        messageBuilder.with(exception, exitPoint, classInBundle);
                        ExceptionReportRobotMessage detailedMessage = messageBuilder.buildFlightReportRobotMessage();
                        detailedMessage.notifyAllSubscribersAndShowFlightReport();
                    }
                });
            }
        }).start();
    }

    private void waitUntilPolyScopeInitialized() {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return URGUI.isInitialized();
            }
        }, (int)2, (TimeUnit)TimeUnit.MINUTES);
    }
}

