/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.internal;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.polyscope.urcaps.ExceptionHandling;
import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.contribution.internal.ExceptionReportRobotMessage;
import com.ur.urcap.html.util.HTMLBuilder;
import com.ur.util.swing.HTML;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.constants.errorcodes.ReportLevel;
import gui.debug.FlightReportAttachmentService;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.osgi.framework.Bundle;

public class ExceptionRobotMessageBuilder {
    private final ExceptionHandling extractedExceptionHandling;
    private final BundleUtils bundleUtils;
    private final Provider<HTMLBuilder> htmlBuilderProvider;
    private final FlightReportAttachmentService flightReportAttachmentService;
    private final TextResource textResource;
    private final FrameworkAdapter frameworkAdapter;
    protected Throwable exception;
    protected Map<String, String> urCapInfoMap;
    protected String stackTrace;
    protected String urcapName;

    @Inject
    public ExceptionRobotMessageBuilder(ExceptionHandling extractedExceptionHandling, BundleUtils bundleUtils, Provider<HTMLBuilder> htmlBuilderProvider, FlightReportAttachmentService flightReportAttachmentService, TextResource textResource, FrameworkAdapter frameworkAdapter) {
        this.extractedExceptionHandling = extractedExceptionHandling;
        this.bundleUtils = bundleUtils;
        this.htmlBuilderProvider = htmlBuilderProvider;
        this.flightReportAttachmentService = flightReportAttachmentService;
        this.textResource = textResource;
        this.frameworkAdapter = frameworkAdapter;
    }

    public ExceptionRobotMessageBuilder with(Throwable exception, StackTraceElement exitPoint, Class<?> classInBundle) {
        Bundle bundle;
        this.exception = exception;
        if (exception instanceof ProxiedException) {
            this.stackTrace = this.extractedExceptionHandling.getStackTraceOutsidePolyScope(exception, ((ProxiedException)exception).findCatchingMethod());
            bundle = this.frameworkAdapter.getBundle(((ProxiedException)exception).getThrowingClass());
        } else {
            this.stackTrace = this.extractedExceptionHandling.getStackTraceOutsidePolyScope(exception, exitPoint);
            bundle = this.frameworkAdapter.getBundle(classInBundle);
        }
        if (bundle == null) {
            this.urCapInfoMap = new LinkedHashMap<String, String>();
            this.urcapName = "";
        } else {
            this.urcapName = this.bundleUtils.getUrcapName(bundle);
            this.urCapInfoMap = this.bundleUtils.buildMetaInfoMap(bundle, EnumSet.of(BundleUtils.BundleMetaField.NAME, BundleUtils.BundleMetaField.VERSION, BundleUtils.BundleMetaField.DEVELOPER, BundleUtils.BundleMetaField.CONTACT_INFO));
        }
        return this;
    }

    public Map<String, String> getUrCapInfoMap() {
        return this.urCapInfoMap;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public RobotMessage build() {
        RobotMessage msg = new RobotMessage();
        msg.source = MessageSource.GUI;
        msg.type = RobotMessageType.TEXT;
        msg.warningLevel = ReportLevel.WARNING;
        msg.message = this.exception.getMessage() != null ? this.exception.getMessage() : this.exception.toString();
        return msg;
    }

    public ExceptionReportRobotMessage buildFlightReportRobotMessage() {
        ExceptionReportRobotMessage msg = new ExceptionReportRobotMessage();
        msg.source = MessageSource.GUI;
        msg.type = RobotMessageType.TEXT;
        msg.warningLevel = ReportLevel.WARNING;
        msg.flightReportAttachmentService = this.flightReportAttachmentService;
        msg.exception = this.exception;
        msg.title = msg.messageTitle = this.textResource.UnhandledExceptionOccurredInURCap(this.urcapName);
        HTMLBuilder html = (HTMLBuilder)this.htmlBuilderProvider.get();
        String exceptionMessage = this.exception.getMessage();
        String className = this.exception instanceof ProxiedException ? ((ProxiedException)this.exception).getOrgException().getClass().getName() : this.exception.getClass().getName();
        html.start("p").text(className);
        if (exceptionMessage != null) {
            html.text(": ").text(exceptionMessage);
        }
        html.end("p");
        html.br();
        html.b(this.textResource.StackTrace());
        html.start("p style=\"padding-top:8px;\"");
        html.appendHtml(this.stackTrace);
        html.end("p");
        html.br();
        html.appendHtml("<hr>");
        html.br();
        Set<Map.Entry<String, String>> entries = this.urCapInfoMap.entrySet();
        StringBuilder rows = new StringBuilder();
        for (Map.Entry<String, String> entry : entries) {
            rows.append(this.createHTMLTableRow(entry.getKey(), entry.getValue()));
        }
        html.appendHtml(HTML.tableWithProperties((String)"", (String[])new String[]{rows.toString()}));
        msg.message = html.toString();
        return msg;
    }

    private String createHTMLTableRow(Object label, Object value) {
        return HTML.tableRow((String[])new String[]{HTML.tableCellAlignTop((String)label.toString()), HTML.tableCellAlignTop((String)HTML.fontBold((String)value.toString()))});
    }

    public Throwable getException() {
        return this.exception;
    }
}

