/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.internal;

import com.ur.exception.CustomUncaughtExceptionHandler;
import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.platform.api.PolyScopeInitializationObserverService;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.ExceptionHandling;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;

@Singleton
public class UncaughtURCapExceptionHandler
implements Thread.UncaughtExceptionHandler,
PolyScopeInitializationObserverService,
CustomUncaughtExceptionHandler {
    private static Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private static ExceptionHandling handler;
    private static List<Bundle> urCapBundles;
    private static FrameworkAdapter frameworkAdapter;
    private static ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper;
    private Class[] stackTraceClasses = null;
    private Throwable throwable;

    @Inject
    public static void setExceptionHandler(ExceptionHandling exceptionHandling) {
        handler = exceptionHandling;
    }

    @Inject
    public static void setFrameworkAdapter(FrameworkAdapter framework) {
        frameworkAdapter = framework;
    }

    @Inject
    public static void setConsoleLoggerExceptionHelper(ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper) {
        UncaughtURCapExceptionHandler.consoleLoggerExceptionHelper = consoleLoggerExceptionHelper;
    }

    private static void initFinished() {
        defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        urCapBundles = frameworkAdapter != null ? frameworkAdapter.listURCapBundles() : new ArrayList<Bundle>();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            if (this.stackTraceClasses != null && this.stackTraceClasses.length > 0 && this.throwable != null && this.throwable.equals(e)) {
                this.checkBundleAndShowDialog(e);
            } else {
                this.checkClassAndShowDialog(t, e);
            }
        }
        finally {
            this.stackTraceClasses = null;
            this.throwable = null;
        }
    }

    private void checkBundleAndShowDialog(Throwable e) {
        Class[] classArray = this.stackTraceClasses;
        int n = this.stackTraceClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class stackTraceClass = classArray[n2];
            Bundle bundle = frameworkAdapter.getBundle(stackTraceClass);
            if (urCapBundles.contains(bundle)) {
                StackTraceElement exitPoint = e instanceof ProxiedException ? ((ProxiedException)e).findCatchingMethod() : e.getStackTrace()[e.getStackTrace().length - 1];
                handler.showURCapExceptionDialogWithoutFlightReport(e, exitPoint, stackTraceClass);
                return;
            }
            ++n2;
        }
    }

    private void checkClassAndShowDialog(Thread t, Throwable e) {
        ArrayList<Class> classes = this.findClassInURCapBundlesBasedOnStackTraceElementStrings(e);
        if (classes.size() == 1) {
            StackTraceElement exitPoint = e instanceof ProxiedException ? ((ProxiedException)e).findCatchingMethod() : e.getStackTrace()[e.getStackTrace().length - 1];
            handler.showURCapExceptionDialogWithoutFlightReport(e, exitPoint, classes.get(0));
            consoleLoggerExceptionHelper.logToConsole(e, classes.get(0));
        } else {
            defaultUncaughtExceptionHandler.uncaughtException(t, e);
        }
    }

    private ArrayList<Class> findClassInURCapBundlesBasedOnStackTraceElementStrings(Throwable e) {
        StackTraceElement[] stackTrace;
        ArrayList<Class> matchingClasses = new ArrayList<Class>();
        StackTraceElement[] stackTraceElementArray = stackTrace = e.getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            for (Bundle urcap : urCapBundles) {
                this.addEntry(urcap, element, matchingClasses);
            }
            if (matchingClasses.size() > 0) {
                return matchingClasses;
            }
            ++n2;
        }
        return matchingClasses;
    }

    private void addEntry(Bundle urcap, StackTraceElement element, ArrayList<Class> matchingClasses) {
        URL resource = urcap.getEntry(String.valueOf(element.getClassName().replace(".", "/")) + ".class");
        if (resource != null) {
            try {
                matchingClasses.add(urcap.loadClass(element.getClassName()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public void setStackTraceClassesForThrowable(Class[] classes, Throwable throwable) {
        this.stackTraceClasses = classes;
        this.throwable = throwable;
    }

    public void onInitBegin() {
    }

    public void onInitFinished() {
        UncaughtURCapExceptionHandler.initFinished();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public void onInitCrashed(Exception e) {
    }
}

