/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.polyscope.scriptwriter.ChildrenScriptWriter;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.ExtendedContribution;
import com.ur.urcap.domain.variable.AbstractVariable;
import com.ur.urcap.domain.variable.VariableFactoryImpl;
import com.ur.util.Optional;
import com.ur.view.variables.core.Variable;
import gui.polyscope.contribution.Contribution;
import gui.polyscope.contribution.TypedProgramNodeModel;
import gui.program.ContributableProgramNode;
import gui.program.GetVariables;
import gui.program.SetContributableProgramNode;
import gui.tools.LanguagePack;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public abstract class BaseProgramContribution
implements Contribution,
SetContributableProgramNode,
GetVariables {
    private final VariableFactoryImpl variableFactory;
    protected String URCapName = "";
    protected String URCapDeveloper = "";
    protected String URCapProgramNodeType = "";
    protected String className = "";
    protected String id = "";
    protected ContributableProgramNode node = null;
    protected TypedProgramNodeModel model = null;
    private final TextResource textResource = LanguagePack.getTextResource();

    public BaseProgramContribution(VariableFactoryImpl variableFactory) {
        this.variableFactory = variableFactory;
    }

    public void setId(String id) {
        this.id = id == null ? "" : id;
    }

    public void setProgramNodeModel(TypedProgramNodeModel model) {
        this.model = model;
    }

    public TypedProgramNodeModel getProgramNodeModel() {
        return this.model;
    }

    public void setNode(ContributableProgramNode node) {
        this.node = node;
    }

    public boolean isChildrenAllowed() {
        return true;
    }

    public boolean isPlaceHolderRequired() {
        return true;
    }

    public String getId() {
        return this.id;
    }

    public String getBundleAttribute(String attribute) {
        return "";
    }

    public String getTitle() {
        return this.textResource.missingUrcap();
    }

    public String getTreeTitle() {
        String nodeType = this.getURCapProgramNodeType();
        if (nodeType.isEmpty()) {
            nodeType = this.textResource.URCap();
        }
        return this.textResource.missingUrcapName(nodeType);
    }

    public Class getBackendClass() {
        return this.getClass();
    }

    public JComponent getErrorView() {
        return null;
    }

    protected boolean hasURCapDetails() {
        String type = StringUtils.trim((Object)this.getURCapProgramNodeType());
        String name = StringUtils.trim((Object)this.getURCapName());
        String vendor = StringUtils.trim((Object)this.getURCapDeveloper());
        return !(String.valueOf(type) + name + vendor).isEmpty();
    }

    protected String getLabelStatement(boolean hasDetails) {
        return hasDetails ? this.textResource.urcapMissingStatement() : this.textResource.urcapBrokenStatement();
    }

    protected String getLabelUrcapType() {
        return this.textResource.programNodeTypeRaw();
    }

    protected String getLabelUrcapName() {
        return this.textResource.urcapNameColon();
    }

    protected String getLabelDeveloper() {
        return this.textResource.urcapDeveloper();
    }

    protected String getLabelSuggestion(boolean hasDetails) {
        return hasDetails ? this.textResource.urcapMissingSuggestion() : this.textResource.urcapBrokenSuggestion();
    }

    public boolean openView() {
        return true;
    }

    public void closeView() {
    }

    public boolean isUndefined() {
        return true;
    }

    public boolean isThirdParty() {
        return true;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer, ChildrenScriptWriter proceed) {
        return writer;
    }

    public boolean isNonUserInsertable() {
        return true;
    }

    public Contribution clone() {
        BaseProgramContribution contribution = null;
        try {
            contribution = (BaseProgramContribution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        return contribution;
    }

    public ContributableProgramNode createNodeWithModelCloned() {
        return new ContributableProgramNode(this.clone());
    }

    public void cloneMetaInfo(Contribution dest) {
        if (dest instanceof BaseProgramContribution) {
            BaseProgramContribution urCapContribution = (BaseProgramContribution)dest;
            urCapContribution.URCapName = this.URCapName;
            urCapContribution.URCapDeveloper = this.URCapDeveloper;
            urCapContribution.URCapProgramNodeType = this.URCapProgramNodeType;
            urCapContribution.className = this.className;
        }
    }

    public String getURCapDeveloper() {
        return this.URCapDeveloper;
    }

    public String getURCapProgramNodeType() {
        String type = this.URCapProgramNodeType;
        if (StringUtils.isNullOrEmpty((String)type)) {
            type = this.className;
        }
        return type;
    }

    public String getURCapName() {
        return this.URCapName;
    }

    public void setURCapInfo(String nodeId, String urCapName, String urCapDeveloper, String urCapProgramType) {
        this.className = nodeId == null ? "" : nodeId;
        this.URCapName = urCapName == null ? "" : urCapName;
        this.URCapDeveloper = urCapDeveloper == null ? "" : urCapDeveloper;
        this.URCapProgramNodeType = urCapProgramType == null ? "" : urCapProgramType;
        this.refreshURCapInfo();
    }

    public void refreshURCapInfo() {
        this.URCapProgramNodeType = this.getTitle();
        this.URCapName = this.getBundleAttribute("Bundle-Name");
        this.URCapDeveloper = this.getBundleAttribute("Bundle-Vendor");
    }

    public Collection<Variable> getReferencedVariables() {
        HashSet<Variable> variableSet = new HashSet<Variable>();
        Iterator it = this.model.getTypedIterator();
        while (it.hasNext()) {
            Object value = ((Map.Entry)it.next()).getValue();
            if (!(value instanceof AbstractVariable)) continue;
            variableSet.add(((AbstractVariable)value).getRealVariable());
        }
        return variableSet;
    }

    public boolean doSubstituteReference(Object original, Object substitute) {
        TypedProgramNodeModel clonedModel = this.model.clone();
        Iterator it = clonedModel.getTypedIterator();
        boolean renamed = false;
        while (it.hasNext()) {
            Map.Entry next = (Map.Entry)it.next();
            Object value = next.getValue();
            if (!this.isCorrectValue(original, value) || !this.isSubstituteCorrectType(substitute) || !this.isSubstituteDifferentFromOriginal(original, substitute)) continue;
            this.model.setObject((String)next.getKey(), (Object)this.variableFactory.createVariable((Variable)substitute));
            renamed = true;
        }
        return renamed;
    }

    private boolean isCorrectValue(Object original, Object value) {
        return value instanceof AbstractVariable && ((AbstractVariable)value).getRealVariable() != null && ((AbstractVariable)value).getRealVariable().equals(original);
    }

    private boolean isSubstituteCorrectType(Object substitute) {
        return substitute instanceof Variable;
    }

    private boolean isSubstituteDifferentFromOriginal(Object original, Object substitute) {
        return original != null && !original.equals(substitute);
    }

    public void showExceptionDialog(Exception e) {
    }

    public Optional<ExtendedContribution> getExtendedContribution() {
        Optional opt = Optional.empty();
        return opt;
    }

    public <T> Optional<T> getContributionAs(Class<T> c) {
        Optional opt = Optional.empty();
        return opt;
    }
}

