/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.urcaps.domain.DataModelReader;
import com.ur.polyscope.urcaps.domain.Pair;
import com.ur.urcap.contribution.DataModelXMLConversionStrategy;
import com.ur.urcap.contribution.UnmarshalledDataModel;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

public class DataModelXMLConversionStrategyImpl
implements DataModelXMLConversionStrategy {
    private final Set<DataModelReader> readers;

    @Inject
    public DataModelXMLConversionStrategyImpl(Set<DataModelReader> readers) {
        this.readers = readers;
    }

    public DataModelXMLConversionStrategyImpl() {
        this.readers = Collections.emptySet();
    }

    @Override
    public UnmarshalledDataModel readData(PersistReader reader) {
        UnmarshalledDataModel unmarshalledDataModel = new UnmarshalledDataModel();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("data")) {
                DataModelXMLConversionStrategyImpl.readDataPair(reader, unmarshalledDataModel);
            } else {
                String nodeName = reader.getNodeName();
                for (DataModelReader dataModelReader : this.readers) {
                    Pair keyValue;
                    if (!dataModelReader.canRead(nodeName) || (keyValue = dataModelReader.readKeyValue(nodeName, reader)) == null || !DataModelXMLConversionStrategyImpl.acceptKey((String)keyValue.getFirst())) continue;
                    unmarshalledDataModel.setTypedOption((String)keyValue.getFirst(), keyValue.getSecond());
                    break;
                }
            }
            reader.moveToParentNode();
        }
        return unmarshalledDataModel;
    }

    private static boolean acceptKey(String key) {
        return key != null && !key.isEmpty();
    }

    private static void readDataPair(PersistReader reader, UnmarshalledDataModel unmarshalledDataModel) {
        String key = reader.getStringAttribute("key");
        String value = reader.getStringAttribute("value");
        if (DataModelXMLConversionStrategyImpl.acceptKey(key)) {
            unmarshalledDataModel.setOption(key, value);
        }
    }
}

