/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.polyscope.urcaps.nodeservices.URCapClassResolver;
import com.ur.polyscope.urcaps.proxy.SwitchableProxy;
import com.ur.polyscope.urcaps.proxy.SwitchableProxyCapable;
import com.ur.urcap.api.contribution.NonUserInsertable;
import com.ur.urcap.api.contribution.ProgramNodeConfiguration;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.ProgramNodeService;
import com.ur.urcap.api.contribution.ProgramNodeServiceConfigurable;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.domain.URCapAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.contribution.program.HTMLProgramNodeContributionConfigurationImpl;
import com.ur.urcap.contribution.program.HTMLProgramNodeContributionConfigurationProvider;
import com.ur.urcap.contribution.program.ProgramNodeServiceAdapter;

public class HTMLProgramNodeServiceAdapter
implements ProgramNodeServiceAdapter {
    private ProgramNodeService programNodeService;
    private HTMLProgramNodeContributionConfigurationImpl htmlConfiguration;
    private ProgramNodeConfiguration htmlConfigurationProxy;

    public void setHTMLProgramNodeService(ProgramNodeService programNodeService, HTMLProgramNodeContributionConfigurationProvider provider) {
        this.programNodeService = programNodeService;
        this.htmlConfiguration = provider.get(URCapClassResolver.getURCapClass((URCapProgramNodeService)programNodeService));
        if (programNodeService instanceof ProgramNodeServiceConfigurable) {
            this.callConfigureContribution((ProgramNodeServiceConfigurable)programNodeService);
        }
    }

    private void callConfigureContribution(ProgramNodeServiceConfigurable programNodeService) {
        try {
            this.htmlConfigurationProxy = (ProgramNodeConfiguration)SwitchableProxy.createForwardingProxy((SwitchableProxyCapable)this.htmlConfiguration);
            programNodeService.configureContribution(this.htmlConfigurationProxy);
        }
        finally {
            SwitchableProxy.switchToIgnore((SwitchableProxyCapable)((SwitchableProxyCapable)this.htmlConfigurationProxy));
        }
    }

    @Override
    public String getId() {
        return this.programNodeService.getId();
    }

    @Override
    public double getSortingId() {
        return this.htmlConfiguration.getDisplayOrderId();
    }

    @Override
    public boolean isDeprecated() {
        return this.programNodeService.isDeprecated();
    }

    @Override
    public boolean isChildrenAllowed() {
        return this.programNodeService.isChildrenAllowed();
    }

    @Override
    public boolean canPauseOnNode() {
        return this.htmlConfiguration.getProgramDebuggingSupportModel().canPauseOnNode();
    }

    @Override
    public boolean canPauseOnChildNodes() {
        return this.htmlConfiguration.getProgramDebuggingSupportModel().canPauseOnChildNodes();
    }

    @Override
    public boolean canStartFromNode() {
        return this.htmlConfiguration.getProgramDebuggingSupportModel().canStartFromNode();
    }

    @Override
    public boolean canStartFromChildNode() {
        return this.htmlConfiguration.getProgramDebuggingSupportModel().canStartFromChildNode();
    }

    @Override
    public String getTitle() {
        return this.programNodeService.getTitle();
    }

    @Override
    public ProgramNodeContribution createNode(URCapAPI api, DataModel dataModel, boolean isCloningOrLoading) {
        ProgramNodeContribution contribution = this.programNodeService.createNode(api, dataModel);
        if (contribution == null) {
            throw new NullPointerException(String.valueOf(this.programNodeService.getClass().getSimpleName()) + ".createNode() returned null.");
        }
        return contribution;
    }

    @Override
    public Class getURCapClass() {
        return URCapClassResolver.getURCapClass((URCapProgramNodeService)this.programNodeService);
    }

    @Override
    public boolean isUserInsertable() {
        return !NonUserInsertable.class.isAssignableFrom(this.programNodeService.getClass());
    }
}

