/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.polyscope.urcaps.nodeservices.URCapClassResolver;
import com.ur.polyscope.urcaps.proxy.SwitchableProxy;
import com.ur.polyscope.urcaps.proxy.SwitchableProxyCapable;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.contribution.program.ContributionConfiguration;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.URCapAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.contribution.program.ProgramNodeContributionConfigurationImpl;
import com.ur.urcap.contribution.program.ProgramNodeContributionConfigurationProvider;
import com.ur.urcap.contribution.program.ProgramNodeCreationContextImpl;
import com.ur.urcap.contribution.program.ProgramNodeServiceAdapter;
import com.ur.urcap.contribution.program.SwingProgramNodeViewProvider;
import java.util.Locale;

public class SwingProgramNodeServiceAdapter
implements ProgramNodeServiceAdapter {
    private SwingProgramNodeService programNodeService;
    private ProgramAPIProvider programAPIProvider;
    private SwingProgramNodeViewProvider programNodeViewProvider;
    private ProgramNodeContributionConfigurationImpl configuration;
    private ContributionConfiguration configurationProxy;

    public void setSwingProgramNodeServiceAndView(SwingProgramNodeService programNodeService, SwingProgramNodeViewProvider programNodeViewProvider, ProgramAPIProvider programAPIProvider, ProgramNodeContributionConfigurationProvider configurationProvider) {
        this.programNodeService = programNodeService;
        this.programAPIProvider = programAPIProvider;
        this.configuration = configurationProvider.get(URCapClassResolver.getURCapClass((URCapProgramNodeService)programNodeService));
        this.callConfigureContribution(programNodeService);
        this.programNodeViewProvider = programNodeViewProvider;
    }

    private void callConfigureContribution(SwingProgramNodeService programNodeService) {
        try {
            this.configurationProxy = (ContributionConfiguration)SwitchableProxy.createForwardingProxy((SwitchableProxyCapable)this.configuration);
            programNodeService.configureContribution(this.configurationProxy);
        }
        finally {
            SwitchableProxy.switchToIgnore((SwitchableProxyCapable)((SwitchableProxyCapable)this.configurationProxy));
        }
    }

    @Override
    public String getId() {
        return this.programNodeService.getId();
    }

    @Override
    public double getSortingId() {
        return this.configuration.getDisplayOrderId();
    }

    @Override
    public boolean isDeprecated() {
        return this.configuration.isDeprecated();
    }

    @Override
    public boolean isChildrenAllowed() {
        return this.configuration.isChildrenAllowed();
    }

    @Override
    public boolean isUserInsertable() {
        return this.configuration.isUserInsertable();
    }

    @Override
    public boolean canPauseOnNode() {
        return this.configuration.getProgramDebuggingSupportModel().canPauseOnNode();
    }

    @Override
    public boolean canPauseOnChildNodes() {
        return this.configuration.getProgramDebuggingSupportModel().canPauseOnChildNodes();
    }

    @Override
    public boolean canStartFromNode() {
        return this.configuration.getProgramDebuggingSupportModel().canStartFromNode();
    }

    @Override
    public boolean canStartFromChildNode() {
        return this.configuration.getProgramDebuggingSupportModel().canStartFromChildNode();
    }

    @Override
    public String getTitle() {
        Locale locale = this.programAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
        return this.programNodeService.getTitle(locale);
    }

    @Override
    public ProgramNodeContribution createNode(URCapAPI api, DataModel dataModel, boolean isCloningOrLoading) {
        try {
            SwingProgramNodeView view = this.programNodeViewProvider.getSwingProgramNodeView();
            this.programNodeViewProvider.setInContributionConstructor(true);
            ProgramNodeContribution contribution = this.programNodeService.createNode(this.programAPIProvider, view, dataModel, (CreationContext)SwingProgramNodeServiceAdapter.createContext(isCloningOrLoading));
            if (contribution == null) {
                throw new NullPointerException(String.valueOf(this.programNodeService.getClass().getSimpleName()) + ".createNode() returned null.");
            }
            ProgramNodeContribution programNodeContribution = contribution;
            return programNodeContribution;
        }
        finally {
            this.programNodeViewProvider.setInContributionConstructor(false);
        }
    }

    private static ProgramNodeCreationContextImpl createContext(boolean isCloningOrLoading) {
        return new ProgramNodeCreationContextImpl(isCloningOrLoading ? CreationContext.NodeCreationType.LOAD : CreationContext.NodeCreationType.NEW);
    }

    @Override
    public Class getURCapClass() {
        return URCapClassResolver.getURCapClass((URCapProgramNodeService)this.programNodeService);
    }
}

