/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.polyscope.urcaps.contributions.SwingProgramNodeViewHasLogo;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.swing.BundleClassAuthorizer;
import com.ur.swing.RestrictedPanel;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.PanelCreator;
import com.ur.urcap.contribution.program.ProgramNodeFactory;
import com.ur.urcap.contribution.program.SwingProgramNodeViewProvider;
import com.ur.urcap.contribution.program.SwingProgramNodeViewProviderImpl$BuildUIProtectedContributionProvider$AjcClosure1;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SwingProgramNodeViewProviderImpl
implements SwingProgramNodeViewProvider {
    private static final Dimension PANEL_DIMENSION = (Dimension)UIManager.get("ProgramNodeContributionPanel.dimensions");
    private static final Border PANEL_BORDER = (Border)UIManager.get("ProgramNodeContributionPanel.border");
    private static final Border TITLE_BORDER = (Border)UIManager.get("ProgramNodeContributionTitle.border");
    private static final Font TITLE_FONT = (Font)UIManager.get("ProgramNodeContributionTitle.font");
    private static final Color TITLE_BACKGROUND_COLOR = (Color)UIManager.get("ProgramNodeContributionTitle.background");
    private final SwingProgramNodeService userProgramNodeFactory;
    private final ProgramNodeFactory programNodeFactory;
    private final PanelCreator componentFactory;
    private final ExceptionHandling exceptionHandling;
    private final BundleClassAuthorizer classAuthorizer;
    private final ViewAPIProvider viewAPIProvider;
    private boolean initialized;
    private JPanel viewComponent;
    private SwingProgramNodeView programNodeView;
    private BuildUIProtectedContributionProvider contributionProvider;

    public SwingProgramNodeViewProviderImpl(SwingProgramNodeService userProgramNodeFactory, ProgramNodeFactory programNodeFactory, PanelCreator componentFactory, ExceptionHandling exceptionHandling, BundleClassAuthorizer classAuthorizer, ViewAPIProvider viewAPIProvider) {
        this.userProgramNodeFactory = userProgramNodeFactory;
        this.programNodeFactory = programNodeFactory;
        this.componentFactory = componentFactory;
        this.exceptionHandling = exceptionHandling;
        this.classAuthorizer = classAuthorizer;
        this.viewAPIProvider = viewAPIProvider;
    }

    @Override
    public JComponent getJComponent() {
        this.initialize();
        return this.viewComponent;
    }

    @Override
    public SwingProgramNodeView getSwingProgramNodeView() {
        this.initialize();
        return this.programNodeView;
    }

    @Override
    public void setInContributionConstructor(boolean inContributionConstructor) {
        if (this.contributionProvider == null) {
            return;
        }
        this.contributionProvider.setInContributionConstructor(inContributionConstructor);
    }

    @Override
    public synchronized void clear() {
        this.initialized = false;
        this.viewComponent = null;
        this.programNodeView = null;
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            RestrictedPanel restrictedComponent = new RestrictedPanel(PANEL_DIMENSION, PANEL_BORDER, this.classAuthorizer);
            try {
                this.programNodeView = this.userProgramNodeFactory.createView(this.viewAPIProvider);
                if (this.programNodeView == null) {
                    throw new NullPointerException(String.valueOf(this.userProgramNodeFactory.getClass().getSimpleName()) + ".createView() returned null.");
                }
                this.contributionProvider = new BuildUIProtectedContributionProvider(this.programNodeFactory);
                this.initializeProgramNodeView(restrictedComponent);
                restrictedComponent.setBorder(PANEL_BORDER);
            }
            catch (Exception e) {
                Log.error((String)"Failed to create UI", (Throwable)e);
                StackTraceElement exitPoint = Thread.currentThread().getStackTrace()[1];
                this.exceptionHandling.showURCapExceptionDialog(e, exitPoint, this.userProgramNodeFactory.getClass());
                URCapErrorPanel urCapErrorPanel = this.exceptionHandling.getUrCapErrorHandler().getErrorPanel();
                urCapErrorPanel.setMetadataFromClass(this.userProgramNodeFactory.getClass());
                urCapErrorPanel.setStackTrace(this.exceptionHandling.getStackTraceOutsidePolyScope(e, exitPoint));
                this.viewComponent = urCapErrorPanel;
            }
            if (this.viewComponent == null) {
                Locale locale = this.viewAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
                Icon logo = null;
                if (this.programNodeView instanceof SwingProgramNodeViewHasLogo) {
                    logo = ((SwingProgramNodeViewHasLogo)this.programNodeView).getLogo();
                }
                JPanel titleComponent = logo != null ? this.componentFactory.createTitlePanelWithLogo(this.userProgramNodeFactory.getTitle(locale), TITLE_BACKGROUND_COLOR, TITLE_FONT, TITLE_BORDER, logo) : this.componentFactory.createTitlePanel(this.userProgramNodeFactory.getTitle(locale), TITLE_BACKGROUND_COLOR, TITLE_FONT, TITLE_BORDER);
                this.viewComponent = this.componentFactory.createTitledPanel(titleComponent, (JPanel)restrictedComponent);
            }
        }
        finally {
            this.initialized = true;
        }
    }

    private void initializeProgramNodeView(RestrictedPanel restrictedComponent) {
        try {
            this.contributionProvider.setInBuildUI(true);
            this.programNodeView.buildUI((JPanel)restrictedComponent, (ContributionProvider)this.contributionProvider);
        }
        finally {
            this.contributionProvider.setInBuildUI(false);
        }
    }

    private static class BuildUIProtectedContributionProvider
    implements ContributionProvider {
        private static final String BUILD_UI_EXCEPTION_MSG = "The ProgramNodeContribution should not be used directly from within the buildUI() method, but rather from a user action. E.g. a button listener.";
        private static final String CONSTRUCTOR_EXCEPTION_MSG = "This ProgramNodeView should not be used directly from the ProgramNodeContribution constructor, but rather in openView() or from a user action. E.g. a button listener.";
        private final ProgramNodeFactory programNodeFactory;
        private boolean inBuildUI;
        private boolean inContributionConstructor;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        BuildUIProtectedContributionProvider(ProgramNodeFactory programNodeFactory) {
            this.programNodeFactory = programNodeFactory;
        }

        public Object get() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            SwingProgramNodeViewProviderImpl$BuildUIProtectedContributionProvider$AjcClosure1 swingProgramNodeViewProviderImpl$BuildUIProtectedContributionProvider$AjcClosure1 = new SwingProgramNodeViewProviderImpl$BuildUIProtectedContributionProvider$AjcClosure1(objectArray);
            return UncaughtExceptionAspect.aspectOf().aroundMethod(swingProgramNodeViewProviderImpl$BuildUIProtectedContributionProvider$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        public void setInContributionConstructor(boolean inContributionConstructor) {
            this.inContributionConstructor = inContributionConstructor;
        }

        public void setInBuildUI(boolean inBuildUI) {
            this.inBuildUI = inBuildUI;
        }

        static {
            BuildUIProtectedContributionProvider.ajc$preClinit();
        }

        static final /* synthetic */ Object get_aroundBody0(BuildUIProtectedContributionProvider ajc$this, JoinPoint joinPoint) {
            if (ajc$this.inBuildUI) {
                throw new IllegalStateException(BUILD_UI_EXCEPTION_MSG);
            }
            if (ajc$this.inContributionConstructor) {
                throw new IllegalStateException(CONSTRUCTOR_EXCEPTION_MSG);
            }
            ProgramNodeContribution selectedNode = ajc$this.programNodeFactory.getSelectedSwingProgramNodeContribution();
            if (selectedNode == null) {
                throw new IllegalStateException("No node currently selected.");
            }
            return selectedNode;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("SwingProgramNodeViewProviderImpl.java", BuildUIProtectedContributionProvider.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "com.ur.urcap.contribution.program.SwingProgramNodeViewProviderImpl$BuildUIProtectedContributionProvider", "", "", "", "java.lang.Object"), 169);
        }
    }
}

