/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.lang.StringUtils;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.urcaps.nodeservices.EmbeddedProxiedService;
import com.ur.polyscope.urcaps.nodeservices.ProxiedService;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import com.ur.swing.BundleClassAuthorizer;
import com.ur.urcap.api.contribution.ProgramNodeService;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.PanelCreator;
import com.ur.urcap.contribution.UIConverter;
import com.ur.urcap.contribution.program.HTMLProgramNodeContributionConfigurationProvider;
import com.ur.urcap.contribution.program.HTMLProgramNodeServiceAdapter;
import com.ur.urcap.contribution.program.ProgramContribution;
import com.ur.urcap.contribution.program.ProgramNodeContributionConfigurationProvider;
import com.ur.urcap.contribution.program.ProgramNodeFactory;
import com.ur.urcap.contribution.program.ProgramNodeServiceAdapter;
import com.ur.urcap.contribution.program.SwingProgramNodeServiceAdapter;
import com.ur.urcap.contribution.program.SwingProgramNodeViewProvider;
import com.ur.urcap.contribution.program.SwingProgramNodeViewProviderImpl;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JComponent;

public class UIProgramContribution
implements ProgramContribution {
    private final List<ProgramNodeFactory> factories = new ArrayList<ProgramNodeFactory>();
    private final UIConverter converter;
    private final Provider<ProgramNodeFactory> programNodeFactoryProvider;
    private final EventManager eventManager;
    private final ProgramAPIProvider programAPIProvider;
    private final ViewAPIProvider viewAPIProvider;
    private static final Map<Class, SwingProgramNodeViewProvider> viewProviderMap = new HashMap<Class, SwingProgramNodeViewProvider>();
    private final PanelCreator componentFactory;
    private final Provider<HTMLProgramNodeServiceAdapter> htmlProgramNodeServiceAdapterProvider;
    private final Provider<SwingProgramNodeServiceAdapter> swingProgramNodeServiceAdapterProvider;
    private final ExceptionHandling exceptionHandling;
    private final BundleClassAuthorizer classAuthorizer;
    private final ProgramNodeContributionConfigurationProvider swingContributionConfigurationProvider;
    private final HTMLProgramNodeContributionConfigurationProvider htmlProgramNodeContributionConfigurationProvider;

    @Inject
    public UIProgramContribution(Provider<ProgramNodeFactory> programNodeFactoryProvider, UIConverter converter, PanelCreator componentFactory, Provider<HTMLProgramNodeServiceAdapter> htmlProgramNodeServiceAdapterProvider, Provider<SwingProgramNodeServiceAdapter> swingProgramNodeServiceAdapterProvider, ExceptionHandling exceptionHandling, BundleClassAuthorizer classAuthorizer, EventManager eventManager, ProgramAPIProvider programAPIProvider, ViewAPIProvider viewAPIProvider, ProgramNodeContributionConfigurationProvider swingContributionConfigurationProvider, HTMLProgramNodeContributionConfigurationProvider htmlProgramNodeContributionConfigurationProvider) {
        this.converter = converter;
        this.programNodeFactoryProvider = programNodeFactoryProvider;
        this.componentFactory = componentFactory;
        this.htmlProgramNodeServiceAdapterProvider = htmlProgramNodeServiceAdapterProvider;
        this.swingProgramNodeServiceAdapterProvider = swingProgramNodeServiceAdapterProvider;
        this.exceptionHandling = exceptionHandling;
        this.classAuthorizer = classAuthorizer;
        this.eventManager = eventManager;
        this.programAPIProvider = programAPIProvider;
        this.viewAPIProvider = viewAPIProvider;
        this.swingContributionConfigurationProvider = swingContributionConfigurationProvider;
        this.htmlProgramNodeContributionConfigurationProvider = htmlProgramNodeContributionConfigurationProvider;
    }

    public void addProgramNodeFactory(String html, Object userProgramNodeFactory, URCapInformation urCapInformation) {
        if (userProgramNodeFactory instanceof ProgramNodeService) {
            JComponent viewComponent = null;
            if (html != null) {
                viewComponent = this.converter.convert(html);
            }
            if (viewComponent == null && !StringUtils.isNullOrEmpty((String)html)) {
                URCapErrorPanel urCapErrorPanel = this.exceptionHandling.getUrCapErrorHandler().getErrorPanel();
                urCapErrorPanel.setMetadataFromClass(userProgramNodeFactory.getClass());
                viewComponent = urCapErrorPanel;
            }
            HTMLProgramNodeServiceAdapter htmlProgramNodeServiceAdapter = (HTMLProgramNodeServiceAdapter)this.htmlProgramNodeServiceAdapterProvider.get();
            htmlProgramNodeServiceAdapter.setHTMLProgramNodeService((ProgramNodeService)userProgramNodeFactory, this.htmlProgramNodeContributionConfigurationProvider);
            ProgramNodeFactory factory = this.createProgramNodeFactory(viewComponent, htmlProgramNodeServiceAdapter, urCapInformation);
            if (factory.isValidContribution()) {
                this.factories.add(factory);
            } else {
                Log.error((String)"Failed to contribute ProgramNodeFactory due to missing Contribution Id");
            }
        } else {
            throw new IllegalStateException("Failed: User defined object should extend " + ProgramNodeService.class.getName());
        }
    }

    public void addProgramNodeFactory(SwingProgramNodeService userProgramNodeFactory, URCapInformation urCapInformation) {
        ProgramNodeFactory programNodeFactory = (ProgramNodeFactory)this.programNodeFactoryProvider.get();
        SwingProgramNodeViewProvider viewProvider = this.getViewProvider(userProgramNodeFactory, programNodeFactory);
        SwingProgramNodeServiceAdapter swingProgramNodeServiceAdapter = (SwingProgramNodeServiceAdapter)this.swingProgramNodeServiceAdapterProvider.get();
        swingProgramNodeServiceAdapter.setSwingProgramNodeServiceAndView(userProgramNodeFactory, viewProvider, this.programAPIProvider, this.swingContributionConfigurationProvider);
        programNodeFactory.setJComponentProvider(new JComponentProviderAdapter(viewProvider));
        programNodeFactory.setUserProgramNodeFactoryAndURCapInformation(swingProgramNodeServiceAdapter, urCapInformation);
        if (programNodeFactory.isValidContribution()) {
            this.factories.add(programNodeFactory);
        } else {
            Log.error((String)"Failed to contribute ProgramNodeFactory due to missing Contribution Id");
        }
    }

    private synchronized SwingProgramNodeViewProvider getViewProvider(SwingProgramNodeService userProgramNodeFactory, ProgramNodeFactory programNodeFactory) {
        Class serviceClass = this.isProxied(userProgramNodeFactory) ? ((ProxiedService)userProgramNodeFactory).getProxiedService() : userProgramNodeFactory.getClass();
        SwingProgramNodeViewProvider viewProvider = viewProviderMap.get(serviceClass);
        if (viewProvider == null) {
            viewProvider = new SwingProgramNodeViewProviderImpl(userProgramNodeFactory, programNodeFactory, this.componentFactory, this.exceptionHandling, this.classAuthorizer, this.viewAPIProvider);
            viewProviderMap.put(serviceClass, viewProvider);
            UIProgramContributionProgramEventListener listener = new UIProgramContributionProgramEventListener(viewProvider, serviceClass);
            listener.setSubscription(this.eventManager.addStrongListener(ProgramEventListener.class, (Object)listener));
        }
        return viewProvider;
    }

    private boolean isProxied(SwingProgramNodeService userProgramNodeFactory) {
        return userProgramNodeFactory instanceof ProxiedService && !(userProgramNodeFactory instanceof EmbeddedProxiedService);
    }

    private ProgramNodeFactory createProgramNodeFactory(JComponent viewComponent, ProgramNodeServiceAdapter userProgramNodeFactory, URCapInformation urCapInformation) {
        ProgramNodeFactory programNodeFactory = (ProgramNodeFactory)this.programNodeFactoryProvider.get();
        programNodeFactory.setJComponentProvider(new JComponentProvider(viewComponent));
        programNodeFactory.setUserProgramNodeFactoryAndURCapInformation(userProgramNodeFactory, urCapInformation);
        return programNodeFactory;
    }

    @Override
    public Collection<ProgramNodeFactory> getProgramNodeFactories() {
        return Collections.unmodifiableList(this.factories);
    }

    private static class JComponentProvider
    implements Provider<JComponent> {
        private final JComponent component;

        JComponentProvider(JComponent component) {
            this.component = component;
        }

        public JComponent get() {
            return this.component;
        }
    }

    private static class JComponentProviderAdapter
    implements Provider<JComponent> {
        private SwingProgramNodeViewProvider viewProvider;

        JComponentProviderAdapter(SwingProgramNodeViewProvider viewProvider) {
            this.viewProvider = viewProvider;
        }

        public JComponent get() {
            return this.viewProvider.getJComponent();
        }
    }

    private static class UIProgramContributionProgramEventListener
    implements ProgramEventListener {
        private final SwingProgramNodeViewProvider currentViewProvider;
        private final Class serviceClass;
        private Subscription subscription;

        UIProgramContributionProgramEventListener(SwingProgramNodeViewProvider currentViewProvider, Class serviceClass) {
            this.currentViewProvider = currentViewProvider;
            this.serviceClass = serviceClass;
        }

        public void handleProgramEvent(ProgramEventType evt) {
            if (evt == ProgramEventType.CLEANUP_CONTRIBUTION_VIEWS) {
                this.currentViewProvider.clear();
                viewProviderMap.remove(this.serviceClass);
                this.safeDisposeSubscription();
            }
        }

        public void handleProgramEvent(ProgramEventType evt, ProgramRootNode programRootNode) {
            this.handleProgramEvent(evt);
        }

        public void handleProgramEvent(ProgramEventType evt, File programFile) {
            this.handleProgramEvent(evt);
        }

        void setSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        private void safeDisposeSubscription() {
            if (this.subscription != null) {
                this.subscription.dispose();
            }
        }
    }
}

