/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.XmlSerializable;
import com.ur.polyscope.persistence.versioning.Version;
import com.ur.polyscope.persistence.versioning.Versioned;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.urcaps.domain.DataModelWriter;
import com.ur.urcap.contribution.DataModelXMLConversionStrategy;
import com.ur.urcap.contribution.URCapSortable;
import com.ur.urcap.contribution.UnmarshalledDataModel;
import com.ur.urcap.contribution.program.BaseProgramContribution;
import com.ur.urcap.contribution.program.DataModelXMLConversionStrategyImpl;
import com.ur.urcap.contribution.program.ProgramNodeFactory;
import com.ur.urcap.contribution.program.URCapProgramNodeDataComparator;
import com.ur.urcap.contribution.program.URCapProgramProvider;
import com.ur.util.Optional;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.module.programs.ProgramModule;
import gui.polyscope.contribution.Contribution;
import gui.polyscope.contribution.TypedProgramNodeModel;
import gui.program.ContributableProgramNode;
import gui.program.persistence.ProgramBranchNodeImporterExporter;
import gui.program.persistence.ProgramNodeStateImporterExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class URCapProgramModule
implements ProgramModule {
    private URCapProgramProvider provider;
    private static final String STRATEGY_CLASS_ATTRIBUTE = "strategyClass";
    private static final String STRATEGY_CLASS_PROGRAM_NODE_TYPE = "strategyProgramNodeType";
    private static final String STRATEGY_CLASS_URCAP_NAME = "strategyURCapName";
    private static final String STRATEGY_CLASS_URCAP_DEVELOPER = "strategyURCapDeveloper";
    private static final String DATA_NODE = "data";
    private static final String DATA_MODEL_NODE = "dataModel";
    private static final ProgramBranchNodeImporterExporter CHILDREN_IMPORTER_EXPORTER = new ProgramBranchNodeImporterExporter(null);
    private static final ProgramNodeStateImporterExporter PROGRAM_NODE_STATE_IMPORTER_EXPORTER = new ProgramNodeStateImporterExporter(null);
    private static final Version NO_VERSION = new Version(0, 0);
    private static final String VERSION_ATTR = "version";
    private DataModelXMLConversionStrategy dataModelConversionStrategy = new DataModelXMLConversionStrategyImpl();
    private Set<DataModelWriter> writers;

    @Inject
    public void setURCapProvider(URCapProgramProvider provider) {
        this.provider = provider;
    }

    @Inject
    public void setDataModelConversionStrategy(DataModelXMLConversionStrategy dataModelConversionStrategy) {
        this.dataModelConversionStrategy = dataModelConversionStrategy;
    }

    @Inject
    public void setDataModelWriter(Set<DataModelWriter> writers) {
        this.writers = writers;
    }

    public Map<String, ProgramModule.ContributableProgramNodeFactory> getContributions() {
        LinkedHashMap<String, ProgramModule.ContributableProgramNodeFactory> result = new LinkedHashMap<String, ProgramModule.ContributableProgramNodeFactory>();
        ArrayList<URCapSort> urCapSortlist = new ArrayList<URCapSort>(result.size());
        Collection<ProgramModule.ContributableProgramNodeFactory> contributableProgramNodeFactories = this.provider.getContributableProgramNodeFactories();
        for (ProgramModule.ContributableProgramNodeFactory factory : contributableProgramNodeFactories) {
            if (!(factory instanceof ProgramNodeFactory)) continue;
            urCapSortlist.add(new URCapSort((ProgramNodeFactory)factory));
        }
        Collections.sort(urCapSortlist, new URCapProgramNodeDataComparator());
        for (URCapSort urCapSort : urCapSortlist) {
            result.put(urCapSort.getProgramNodeFactory().getId(), urCapSort.getProgramNodeFactory());
        }
        return result;
    }

    public ProgramModule.ContributableProgramNodeFactory getContributableProgramNodeFactory(String nodeId) {
        return this.provider.getContributableProgramNodeFactory(nodeId);
    }

    public void marshal(ContributableProgramNode node, PersistWriter writer) {
        Contribution contribution = node.getContribution();
        String nodeId = contribution.getId();
        writer.addAttribute(STRATEGY_CLASS_ATTRIBUTE, nodeId);
        if (contribution instanceof BaseProgramContribution) {
            BaseProgramContribution urCapContribution = (BaseProgramContribution)contribution;
            urCapContribution.refreshURCapInfo();
            writer.addAttribute(STRATEGY_CLASS_PROGRAM_NODE_TYPE, urCapContribution.getURCapProgramNodeType());
            writer.addAttribute(STRATEGY_CLASS_URCAP_DEVELOPER, urCapContribution.getURCapDeveloper());
            writer.addAttribute(STRATEGY_CLASS_URCAP_NAME, urCapContribution.getURCapName());
        }
        this.writeVersion(writer, node);
        TypedProgramNodeModel model = contribution.getProgramNodeModel();
        writer.startNode(DATA_MODEL_NODE);
        if (model != null) {
            Iterator iterator = model.getPrimitivesIterator();
            this.writePrimitiveData(iterator, writer);
            Iterator typedIterator = model.getTypedIterator();
            this.writeTypedData(typedIterator, writer);
        }
        writer.endNode();
        PROGRAM_NODE_STATE_IMPORTER_EXPORTER.writeToChildNodes((AbstractProgramNode)node, writer);
        CHILDREN_IMPORTER_EXPORTER.writeToChildNodes((AbstractProgramNode)node, writer);
    }

    private void writePrimitiveData(Iterator<Map.Entry<String, String>> iterator, PersistWriter writer) {
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            this.writeElement(writer, DATA_NODE, entry.getKey(), entry.getValue());
        }
    }

    private void writeTypedData(Iterator<Map.Entry<String, Object>> iterator, PersistWriter writer) {
        block0: while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            Object value = next.getValue();
            if (value instanceof XmlSerializable) {
                ((XmlSerializable)value).write(writer, next.getKey());
                continue;
            }
            for (DataModelWriter each : this.writers) {
                if (!each.canWrite(value)) continue;
                each.writeKeyValue(value, next.getKey(), writer);
                continue block0;
            }
        }
    }

    private void writeElement(PersistWriter writer, String nodeName, String key, String value) {
        writer.startNode(nodeName);
        this.addAttribute(writer, "key", key);
        this.addAttribute(writer, "value", value);
        writer.endNode();
    }

    private void addAttribute(PersistWriter writer, String att, String value) {
        if (value != null && !value.isEmpty()) {
            writer.addAttribute(att, value);
        }
    }

    public ContributableProgramNode unmarshal(PersistReader reader) {
        String nodeId = reader.getStringAttribute(STRATEGY_CLASS_ATTRIBUTE);
        String URCapNodeType = reader.getStringAttribute(STRATEGY_CLASS_PROGRAM_NODE_TYPE);
        String URCapName = reader.getStringAttribute(STRATEGY_CLASS_URCAP_NAME);
        String URCapDeveloper = reader.getStringAttribute(STRATEGY_CLASS_URCAP_DEVELOPER);
        Version version = this.readVersion(reader);
        ContributableProgramNode node = this.unmarshalDataStateAndChildren(reader, nodeId);
        this.trySetVersion(node, version);
        Contribution contribution = node.getContribution();
        if (contribution instanceof BaseProgramContribution) {
            ((BaseProgramContribution)contribution).setURCapInfo(nodeId, URCapName, URCapDeveloper, URCapNodeType);
        }
        return node;
    }

    private ContributableProgramNode unmarshalDataStateAndChildren(PersistReader reader, String nodeId) {
        ContributableProgramNode contributableProgramNode = null;
        boolean hasDataModelChildNode = true;
        if (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            TypedProgramNodeModel programNodeDataModel = this.readProgramNodeDataModel(reader);
            if (programNodeDataModel == null) {
                hasDataModelChildNode = false;
                programNodeDataModel = new TypedProgramNodeModel();
            }
            reader.moveToParentNode();
            contributableProgramNode = this.createNode(programNodeDataModel, nodeId);
            if (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                this.unmarshalProgramNodeState(contributableProgramNode, reader);
            }
            if (hasDataModelChildNode && reader.hasMoreNodes()) {
                CHILDREN_IMPORTER_EXPORTER.tryReadFromChildNode((AbstractProgramNode)contributableProgramNode, reader);
                reader.moveToParentNode();
            }
        } else {
            TypedProgramNodeModel programNodeDataModel = new TypedProgramNodeModel();
            contributableProgramNode = this.createNode(programNodeDataModel, nodeId);
        }
        if (!hasDataModelChildNode) {
            Log.warning((String)("No data model persisted for contributable program node with id: " + nodeId));
        }
        return contributableProgramNode;
    }

    private TypedProgramNodeModel readProgramNodeDataModel(PersistReader reader) {
        if (EqualsUtil.equals((Object)reader.getNodeName(), (Object)DATA_NODE)) {
            TypedProgramNodeModel TypedProgramNodeModel2 = new TypedProgramNodeModel();
            TypedProgramNodeModel2.loadFromStringRepresentation(reader.getStringValue());
            return TypedProgramNodeModel2;
        }
        if (EqualsUtil.equals((Object)reader.getNodeName(), (Object)DATA_MODEL_NODE)) {
            UnmarshalledDataModel unmarshalledDataModel = this.dataModelConversionStrategy.readData(reader);
            return new TypedProgramNodeModel(unmarshalledDataModel.getOptions());
        }
        return null;
    }

    private ContributableProgramNode createNode(TypedProgramNodeModel model, String nodeId) {
        ProgramModule.ContributableProgramNodeFactory factory = this.getContributableProgramNodeFactory(nodeId);
        if (factory != null) {
            return factory.createNode(model);
        }
        return this.provider.createMissingProgramContribution(model, nodeId);
    }

    private void unmarshalProgramNodeState(ContributableProgramNode programNode, PersistReader reader) {
        if (PROGRAM_NODE_STATE_IMPORTER_EXPORTER.tryReadFromChildNode((AbstractProgramNode)programNode, reader)) {
            reader.moveToParentNode();
            if (reader.hasMoreNodes()) {
                reader.moveToChildNode();
            }
        }
    }

    private void writeVersion(PersistWriter writer, ContributableProgramNode contributableProgramNode) {
        Contribution contribution = contributableProgramNode.getContribution();
        if (contribution == null) {
            return;
        }
        Optional versionedOptional = contribution.getContributionAs(Versioned.class);
        if (versionedOptional.isPresent()) {
            Versioned versioned = (Versioned)versionedOptional.get();
            Version version = versioned.getVersion();
            if (NO_VERSION.equals((Object)version)) {
                return;
            }
            writer.addAttribute(VERSION_ATTR, version.getMajor() + "." + version.getMinor());
        }
    }

    private Version readVersion(PersistReader reader) {
        String versionString = reader.getStringAttribute(VERSION_ATTR);
        return this.parseVersion(versionString);
    }

    private Version parseVersion(String versionString) {
        Version version = NO_VERSION;
        if (versionString == null) {
            return version;
        }
        String[] split = versionString.split("\\.");
        if (split.length != 2) {
            return version;
        }
        try {
            int major = Integer.parseInt(split[0]);
            int minor = Integer.parseInt(split[1]);
            version = new Version(major, minor);
        }
        catch (NumberFormatException e) {
            Log.warning((String)("Can't parse version attribute " + versionString), (Throwable)e);
        }
        return version;
    }

    private void trySetVersion(ContributableProgramNode contributableProgramNode, Version version) {
        Contribution contribution = contributableProgramNode.getContribution();
        if (contribution == null) {
            return;
        }
        Optional versionedOptional = contribution.getContributionAs(Versioned.class);
        if (versionedOptional.isPresent()) {
            Versioned versioned = (Versioned)versionedOptional.get();
            versioned.setVersion(version);
        }
    }

    private class URCapSort
    implements URCapSortable {
        private final ProgramNodeFactory programNodeFactory;

        URCapSort(ProgramNodeFactory programNodeFactory) {
            this.programNodeFactory = programNodeFactory;
        }

        @Override
        public String getURCapName() {
            return this.programNodeFactory.getURCapName();
        }

        @Override
        public String getURCapVendor() {
            return this.programNodeFactory.getVendor();
        }

        @Override
        public double getSortingId() {
            return this.programNodeFactory.getSortingId();
        }

        @Override
        public String getContributionTitle() {
            return null;
        }

        @Override
        public String getURCapId() {
            return this.programNodeFactory.getNodeId();
        }

        public ProgramNodeFactory getProgramNodeFactory() {
            return this.programNodeFactory;
        }
    }
}

