/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.contribution.program;

import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.api.contribution.ProgramNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.contribution.program.ProgramContribution;
import com.ur.urcap.contribution.program.UIProgramContribution;
import com.ur.urcap.contribution.program.URCapProgram;
import com.ur.util.logging.Log;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.io.IOUtils;

public class URCapProgramNode
implements URCapProgram {
    private final Provider<UIProgramContribution> uiProgramContributionProvider;
    private final ExceptionHandling exceptionHandling;
    private final ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper;
    private ProgramNodeService htmlProgramNodeFactory;
    private SwingProgramNodeService swingProgramNodeService;
    private URCapInformation providerInfo;
    private String id;

    @Inject
    public URCapProgramNode(Provider<UIProgramContribution> uiProgramContributionProvider, ExceptionHandling exceptionHandling, ConsoleLoggerExceptionHelper consoleLoggerExceptionHelper) {
        this.uiProgramContributionProvider = uiProgramContributionProvider;
        this.exceptionHandling = exceptionHandling;
        this.consoleLoggerExceptionHelper = consoleLoggerExceptionHelper;
    }

    public URCapInformation getURCapInformation() {
        return this.providerInfo;
    }

    public void setURCapInformation(URCapInformation urCapInformation) {
        this.providerInfo = urCapInformation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProgramService(ProgramNodeService programService) {
        this.htmlProgramNodeFactory = programService;
    }

    public void setSwingProgramService(SwingProgramNodeService programService) {
        this.swingProgramNodeService = programService;
    }

    @Override
    public ProgramContribution getProgramContribution() {
        if (this.htmlProgramNodeFactory != null) {
            return this.getProgramContributionHtml();
        }
        if (this.swingProgramNodeService != null) {
            return this.getProgramContributionSwing();
        }
        Log.error((String)"Error getting ProgramContribution");
        return null;
    }

    private ProgramContribution getProgramContributionSwing() {
        try {
            UIProgramContribution uiProgramContribution = (UIProgramContribution)this.uiProgramContributionProvider.get();
            uiProgramContribution.addProgramNodeFactory(this.swingProgramNodeService, this.providerInfo);
            return uiProgramContribution;
        }
        catch (Exception e) {
            this.consoleLoggerExceptionHelper.logToConsole(e, this.swingProgramNodeService.getClass());
            StackTraceElement exitPoint = e instanceof ProxiedException ? ((ProxiedException)e).findCatchingMethod() : Thread.currentThread().getStackTrace()[1];
            this.exceptionHandling.showURCapExceptionDialog(e, exitPoint, this.swingProgramNodeService.getClass());
            return null;
        }
    }

    private ProgramContribution getProgramContributionHtml() {
        UIProgramContribution uiProgramContribution = (UIProgramContribution)this.uiProgramContributionProvider.get();
        InputStream htmlStream = null;
        try {
            htmlStream = this.htmlProgramNodeFactory.getHTML();
        }
        catch (Exception e) {
            this.consoleLoggerExceptionHelper.logToConsole(e, this.htmlProgramNodeFactory.getClass(), this.consoleLoggerExceptionHelper.findCatchingMethod(e, "com.ur.urcap.contribution.program.URCapProgramNode", "getProgramContributionHtml"));
            this.exceptionHandling.showURCapExceptionDialog(e, Thread.currentThread().getStackTrace()[1], this.htmlProgramNodeFactory.getClass());
        }
        String html = null;
        if (htmlStream != null) {
            try {
                html = IOUtils.toString((InputStream)htmlStream, (String)"UTF-8");
            }
            catch (Exception e) {
                this.consoleLoggerExceptionHelper.logToConsole(e, this.htmlProgramNodeFactory.getClass());
                this.exceptionHandling.showURCapExceptionDialog(e, Thread.currentThread().getStackTrace()[1], this.htmlProgramNodeFactory.getClass());
            }
        }
        try {
            uiProgramContribution.addProgramNodeFactory(html, this.htmlProgramNodeFactory, this.providerInfo);
        }
        catch (Exception e) {
            this.consoleLoggerExceptionHelper.logToConsole(e, this.htmlProgramNodeFactory.getClass());
            this.exceptionHandling.showURCapExceptionDialog(e, Thread.currentThread().getStackTrace()[1], this.htmlProgramNodeFactory.getClass());
        }
        return uiProgramContribution;
    }
}

