/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.expression;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.urscript.Bool;
import com.ur.polyscope.urscript.CodeLink;
import com.ur.polyscope.urscript.Expression;
import com.ur.polyscope.urscript.FunCall;
import com.ur.polyscope.urscript.Identifier;
import com.ur.polyscope.urscript.Visitor;
import com.ur.swing.expression.ExpressionNode;
import com.ur.swing.expression.ExpressionTokenNode;
import com.ur.urcap.domain.expression.EntityConverter;
import com.ur.urcap.domain.expression.ExpressionPart;
import com.ur.urcap.domain.expression.ExpressionParts;
import com.ur.urcap.domain.expression.Substitution;
import com.ur.urcap.domain.expression.Substitutions;
import gui.program.services.ProgramReferenceService;

class ASTVisitor
extends Visitor {
    private final Substitutions subs;
    private final ExpressionParts parts;
    private final EntityConverter entityConverter;

    public ASTVisitor(Substitutions subs, ExpressionParts parts, ProgramReferenceService programReferenceService) {
        this.subs = subs;
        this.parts = parts;
        this.entityConverter = new EntityConverter(programReferenceService);
    }

    public void visit(Identifier identifier) {
        ExpressionNode expressionNodeFromEntity;
        NamedEntity entity;
        String uniqueName = identifier.getIdentifier();
        int col = ASTVisitor.getAdjustedColumn((CodeLink)identifier);
        ExpressionPart expressionPart = this.parts.getExpressionPart(col - 1, uniqueName);
        if (expressionPart != null && (entity = expressionPart.getNamedEntity()) != null && (expressionNodeFromEntity = this.entityConverter.convert(entity)) != null) {
            this.subs.add(new Substitution(expressionNodeFromEntity, col - 1, col - 1 + uniqueName.length()));
        }
    }

    private static int getAdjustedColumn(CodeLink element) {
        return element.getColumn() - "var_1 = ".length();
    }

    public void visit(FunCall entity) {
        this.convertToToken(entity.getIdentifier(), ASTVisitor.getAdjustedColumn((CodeLink)entity) - 1, entity.getIdentifier().length());
    }

    public void visit(Expression entity) {
        if (EqualsUtil.equalsOneOf((Object)entity.getOperator(), (Object[])new Expression.Operator[]{Expression.Operator.AND, Expression.Operator.OR, Expression.Operator.XOR, Expression.Operator.NOT})) {
            String operator = entity.getOperator().toString();
            int col = ASTVisitor.getAdjustedColumn((CodeLink)entity) - 1;
            this.convertToToken(operator, col, operator.length());
        }
    }

    public void visit(Bool entity) {
        String operator = StringUtils.firstCharacterToUpper((String)entity.getBool().toString());
        int col = ASTVisitor.getAdjustedColumn((CodeLink)entity) - 1;
        this.convertToToken(operator, col, operator.length());
    }

    private void convertToToken(String token, int col, int length) {
        this.subs.add(new Substitution((ExpressionNode)new ExpressionTokenNode(token), col, col + length));
    }
}

