/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.expression;

import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.expression.ExpressionNode;
import com.ur.view.domain.program.expression.ExpressionGeomFeatureNode;
import com.ur.view.domain.program.expression.ExpressionIONode;
import com.ur.view.domain.program.expression.ExpressionVariableNode;
import com.ur.view.domain.program.expression.ExpressionWaypointNode;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import gui.program.position.WaypointNode;
import gui.program.services.GeomFeatureVariable;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;

public class EntityConverter {
    private final ProgramReferenceService programReferenceService;

    public EntityConverter(ProgramReferenceService programReferenceService) {
        this.programReferenceService = programReferenceService;
    }

    public ExpressionNode convert(NamedEntity entity) {
        ExpressionVariableNode result = null;
        if (entity instanceof ProgramVariable) {
            result = new ExpressionVariableNode((Variable)entity);
        } else if (entity instanceof InstallationVariableReference) {
            result = new ExpressionVariableNode((Variable)entity);
        } else if (entity instanceof GeomFeature) {
            ExpressionGeomFeatureNode expressionGeomFeatureNode = new ExpressionGeomFeatureNode();
            GeomFeatureReference geomFeatureReference = this.programReferenceService.getGeomFeatureReference((GeomFeature)entity);
            expressionGeomFeatureNode.initialSetFeatureReference(geomFeatureReference);
            result = expressionGeomFeatureNode;
        } else if (entity instanceof GeomFeatureVariable) {
            result = new ExpressionVariableNode((Variable)((GeomFeatureVariable)entity));
        } else if (entity instanceof Pin) {
            PinReference pinReference = this.programReferenceService.getPinReference((Pin)entity);
            result = new ExpressionIONode(pinReference);
        } else if (entity instanceof WaypointNode) {
            result = new ExpressionWaypointNode((WaypointNode)entity);
        }
        return result;
    }
}

