/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.expression;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ur.lang.StringUtils;
import com.ur.polyscope.urscript.Urscript;
import com.ur.polyscope.urscript.Visitor;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.domain.expression.ASTVisitor;
import com.ur.urcap.domain.expression.ExpressionImpl;
import com.ur.urcap.domain.expression.ExpressionParts;
import com.ur.urcap.domain.expression.ParseResult;
import com.ur.urcap.domain.expression.Substitutions;
import gui.program.services.ProgramReferenceService;
import java.io.IOException;

public class ExpressionConverter {
    private final ProgramReferenceService programReferenceService;
    private final ParseResult parseResult;
    private final ExpressionParts parts;
    private static final ThreadLocal<ObjectMapper> mapper = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };

    public ExpressionConverter(ProgramReferenceService programReferenceService, ParseResult parseResult, ExpressionParts parts) {
        this.programReferenceService = programReferenceService;
        this.parseResult = parseResult;
        this.parts = parts;
    }

    public Expression convertToExpression() throws InvalidExpressionException {
        if (StringUtils.isNullOrEmpty((String)this.parseResult.getExpression())) {
            return new ExpressionImpl("");
        }
        Substitutions subs = new Substitutions();
        if (this.parseResult.getExpressionAST() != null) {
            try {
                Urscript urscript = (Urscript)mapper.get().readValue(this.parseResult.getExpressionAST(), Urscript.class);
                urscript.traverse(this.getVisitor(subs));
            }
            catch (IOException e) {
                throw new InvalidExpressionException(e.getMessage());
            }
        } else {
            throw new InvalidExpressionException("Could not generate abstract syntax tree");
        }
        ExpressionBranchNode expressionNodes = new ExpressionBranchNode(this.parseResult.getExpression());
        subs.performSubstitutions(expressionNodes);
        return new ExpressionImpl(expressionNodes);
    }

    private Visitor getVisitor(Substitutions subs) {
        return new ASTVisitor(subs, this.parts, this.programReferenceService);
    }
}

