/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.expression;

import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.domain.expression.ExpressionAnalyzer;
import com.ur.urcap.domain.expression.ExpressionParts;
import com.ur.urcap.domain.expression.ParseResult;

public class ExpressionParser {
    public static final String ASSIGNMENT_PREFIX = "var_1 = ";
    private final ExpressionAnalyzer expressionAnalyzer;
    private final ExpressionParts parts;

    public ExpressionParser(ExpressionAnalyzer expressionAnalyzer, ExpressionParts parts) {
        this.expressionAnalyzer = expressionAnalyzer;
        this.parts = parts;
    }

    public ParseResult parseExpression() throws InvalidExpressionException {
        String expression = this.parts.getExpressionControllerSafe();
        if (expression.isEmpty()) {
            return new ParseResult("", "");
        }
        this.checkValidity(expression);
        return this.getParseResult(expression);
    }

    private void checkValidity(String expression) throws InvalidExpressionException {
        String response = this.expressionAnalyzer.checkExpression(ASSIGNMENT_PREFIX + expression);
        if (response == null) {
            throw new InvalidExpressionException("No response from controller.");
        }
        if (!"ok".equalsIgnoreCase(response)) {
            throw new InvalidExpressionException(this.getVerbatimErrorMessage(response, "(" + expression + ")"));
        }
    }

    private ParseResult getParseResult(String expression) throws InvalidExpressionException {
        try {
            String ast = this.expressionAnalyzer.getASTJson(ASSIGNMENT_PREFIX + expression);
            return new ParseResult(expression, ast);
        }
        catch (Exception e) {
            throw new InvalidExpressionException(this.getVerbatimErrorMessage(e.getMessage(), expression));
        }
    }

    private String getVerbatimErrorMessage(String errorMessage, String expression) {
        if (errorMessage.endsWith(expression)) {
            int lengthOfNonExpressionMessage = errorMessage.length() - expression.length();
            errorMessage = String.valueOf(errorMessage.substring(0, lengthOfNonExpressionMessage)) + this.parts.getExpressionVerbatim();
        }
        return errorMessage;
    }
}

