/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.function;

import com.ur.polyscope.logging.naming.ReservedNamesProvider;
import com.ur.polyscope.urcaps.ClassManager;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.domain.function.Function;
import com.ur.urcap.api.domain.function.FunctionException;
import com.ur.urcap.api.domain.function.FunctionModel;
import com.ur.urcap.api.domain.util.Filter;
import com.ur.urcap.domain.function.FunctionImpl;
import com.ur.urcap.domain.function.FunctionModelImpl$AjcClosure1;
import com.ur.urcap.domain.function.FunctionModelImpl$AjcClosure3;
import com.ur.urcap.domain.function.FunctionModelImpl$AjcClosure5;
import com.ur.urcap.domain.function.FunctionModelImpl$AjcClosure7;
import com.ur.urcap.domain.function.URCapInformationProvider;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.urcap.URCapFunction;
import com.ur.view.polyscope.urcap.URCapFunctionService;
import com.ur.view.polyscope.urcap.impl.URCapFunctionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class FunctionModelImpl
implements FunctionModel {
    private static final int MAX_FUNCTION_NAME_LENGTH = 25;
    private static final int MAX_ARGUMENT_NAME_LENGTH = 15;
    private final URCapInformationProvider provider;
    private final URCapFunctionService functionService;
    private ClassManager classManager;
    private final ReservedNamesProvider reservedNames;
    private final Pattern legalName = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]{0," + String.valueOf(24) + "}");
    private final Pattern legalArgumentName = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]{0," + String.valueOf(14) + "}");
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Inject
    public FunctionModelImpl(URCapInformationProvider provider, URCapFunctionService functionService, ClassManager classManager, ReservedNamesProvider reservedNames) {
        this.provider = provider;
        this.functionService = functionService;
        this.classManager = classManager;
        this.reservedNames = reservedNames;
    }

    public Function addFunction(String name, String ... argumentNames) throws FunctionException {
        String string = name;
        String[] stringArray = argumentNames;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        Object[] objectArray = new Object[]{this, string, stringArray, joinPoint};
        FunctionModelImpl$AjcClosure1 functionModelImpl$AjcClosure1 = new FunctionModelImpl$AjcClosure1(objectArray);
        return (Function)UncaughtExceptionAspect.aspectOf().aroundMethod(functionModelImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Class getCallingClass() {
        return this.classManager.getCallingClass(this.getClass());
    }

    private void verifyName(String name) throws FunctionException {
        if (name == null || !this.legalName.matcher(name).matches()) {
            this.throwFunctionException(String.format("Function name %s is illegal", name));
        }
        if (Arrays.asList(this.reservedNames.getAllKeywords()).contains(name)) {
            this.throwFunctionException(String.format("Function name %s is a reserved name", name));
        }
    }

    private void verifyArguments(String[] argumentNames) throws FunctionException {
        if (argumentNames == null) {
            this.throwFunctionException("Argument null is an illegal name");
            return;
        }
        if (argumentNames.length > 5) {
            this.throwFunctionException("More than 5 arguments specified");
        }
        String[] stringArray = argumentNames;
        int n = argumentNames.length;
        int n2 = 0;
        while (n2 < n) {
            String argumentName = stringArray[n2];
            if (argumentName == null || !this.legalArgumentName.matcher(argumentName).matches()) {
                this.throwFunctionException(String.format("Argument %s has an illegal name", argumentName));
            }
            ++n2;
        }
    }

    private void throwFunctionException(String message) throws FunctionException {
        Log.error((String)message);
        throw new FunctionException(message);
    }

    public boolean removeFunction(Function function) {
        Function function2 = function;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)function2);
        Object[] objectArray = new Object[]{this, function2, joinPoint};
        FunctionModelImpl$AjcClosure3 functionModelImpl$AjcClosure3 = new FunctionModelImpl$AjcClosure3(objectArray);
        return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(functionModelImpl$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    public Function getFunction(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        FunctionModelImpl$AjcClosure5 functionModelImpl$AjcClosure5 = new FunctionModelImpl$AjcClosure5(objectArray);
        return (Function)UncaughtExceptionAspect.aspectOf().aroundMethod(functionModelImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public Collection<Function> getFunctions(Filter<Function> filter) {
        Filter<Function> filter2 = filter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, filter2);
        Object[] objectArray = new Object[]{this, filter2, joinPoint};
        FunctionModelImpl$AjcClosure7 functionModelImpl$AjcClosure7 = new FunctionModelImpl$AjcClosure7(objectArray);
        return (Collection)UncaughtExceptionAspect.aspectOf().aroundMethod(functionModelImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    private URCapInformation getURCapInformation(Class caller) {
        return this.provider.getURCapInformation(caller);
    }

    static {
        FunctionModelImpl.ajc$preClinit();
    }

    static final /* synthetic */ Function addFunction_aroundBody0(FunctionModelImpl ajc$this, String name, String[] argumentNames, JoinPoint joinPoint) {
        ajc$this.verifyName(name);
        ajc$this.verifyArguments(argumentNames);
        URCapInformation urCapInformation = ajc$this.getURCapInformation(ajc$this.getCallingClass());
        List<String> arguments = Arrays.asList(argumentNames);
        if (ajc$this.functionService.getFunctionByName(name) == null) {
            URCapFunctionImpl urCapFunction = new URCapFunctionImpl(name, arguments, urCapInformation);
            ajc$this.functionService.registerFunction((URCapFunction)urCapFunction);
            return new FunctionImpl((URCapFunction)urCapFunction);
        }
        return null;
    }

    static final /* synthetic */ boolean removeFunction_aroundBody2(FunctionModelImpl ajc$this, Function function, JoinPoint joinPoint) {
        URCapInformation functionURCapInformation;
        URCapInformation callerURCapInformation = ajc$this.getURCapInformation(ajc$this.getCallingClass());
        if (function != null && callerURCapInformation.equals(functionURCapInformation = (URCapInformation)function.getProvidingURCapInfo())) {
            return ajc$this.functionService.removeFunctionByName(function.getName());
        }
        return false;
    }

    static final /* synthetic */ Function getFunction_aroundBody4(FunctionModelImpl ajc$this, String name, JoinPoint joinPoint) {
        URCapFunction urCapFunction = ajc$this.functionService.getFunctionByName(name);
        return urCapFunction != null ? new FunctionImpl(urCapFunction) : null;
    }

    static final /* synthetic */ Collection getFunctions_aroundBody6(FunctionModelImpl ajc$this, Filter filter, JoinPoint joinPoint) {
        ArrayList<FunctionImpl> result = new ArrayList<FunctionImpl>();
        Collection urCapFunctions = ajc$this.functionService.getFunctions();
        if (filter != null) {
            for (URCapFunction urCapFunction : urCapFunctions) {
                FunctionImpl function = new FunctionImpl(urCapFunction);
                if (!filter.accept((Object)function)) continue;
                result.add(function);
            }
        }
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionModelImpl.java", FunctionModelImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "addFunction", "com.ur.urcap.domain.function.FunctionModelImpl", "java.lang.String:[Ljava.lang.String;", "name:argumentNames", "com.ur.urcap.api.domain.function.FunctionException", "com.ur.urcap.api.domain.function.Function"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeFunction", "com.ur.urcap.domain.function.FunctionModelImpl", "com.ur.urcap.api.domain.function.Function", "function", "", "boolean"), 95);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFunction", "com.ur.urcap.domain.function.FunctionModelImpl", "java.lang.String", "name", "", "com.ur.urcap.api.domain.function.Function"), 109);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFunctions", "com.ur.urcap.domain.function.FunctionModelImpl", "com.ur.urcap.api.domain.util.Filter", "filter", "", "java.util.Collection"), 115);
    }
}

