/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program;

import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.program.undoredo.ThrowIfNonCompoundProgramChanges;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.aspects.NotNullArgumentAspect;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.valueobjects.validation.NotNull;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.builtin.DirectionNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionAxis;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfigBuilder;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeFeature;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionVectorExpression;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.FeatureSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.ToolMotionParameters;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.validation.ErrorHandler;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.domain.expression.ExpressionImpl;
import com.ur.urcap.domain.program.DirectionNodeImpl$1$AjcClosure1;
import com.ur.urcap.domain.program.DirectionNodeImpl$1$AjcClosure3;
import com.ur.urcap.domain.program.DirectionNodeImpl$AjcClosure1;
import com.ur.urcap.domain.program.DirectionNodeImpl$AjcClosure3;
import com.ur.urcap.domain.program.DirectionNodeImpl$AjcClosure5;
import com.ur.urcap.domain.program.DirectionNodeImpl$AjcClosure7;
import com.ur.urcap.domain.program.DirectionNodeImpl$AjcClosure9;
import com.ur.urcap.domain.program.ProgramNodeImpl;
import com.ur.urcap.domain.program.RealNodeFactory;
import com.ur.urcap.domain.program.configurations.directionnode.ToolMotionParametersImpl;
import com.ur.urcap.domain.program.configurations.directionnode.builder.DirectionNodeConfigBuilderImpl;
import com.ur.util.Optional;
import gui.program.direction.DirectionsLookup;
import gui.program.direction.MoveDirectionNode;
import gui.program.services.geom.GeomFeatureReferenceBase;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.util.EnumMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class DirectionNodeImpl
extends ProgramNodeImpl<MoveDirectionNode>
implements DirectionNode {
    private static final EnumMap<DirectionAxis.Axis, DirectionsLookup.Direction> AXIS_DIRECTION_MAPPING;
    private static final EnumMap<DirectionsLookup.Direction, DirectionAxis.Axis> DIRECTION_MAP;
    private final FeatureService featureService;
    private final DirectionNodeConfig defaultConfig;
    private final SimpleValueFactory simpleValueFactory;
    private final WaypointNodeValidationStrategyProvider waypointNodeValidationStrategyProvider;
    private final FeatureWrapService featureWrapService;
    private DirectionNodeConfig config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        DirectionNodeImpl.ajc$preClinit();
        AXIS_DIRECTION_MAPPING = new EnumMap(DirectionAxis.Axis.class);
        DIRECTION_MAP = new EnumMap(DirectionsLookup.Direction.class);
        AXIS_DIRECTION_MAPPING.put(DirectionAxis.Axis.X_PLUS, DirectionsLookup.Direction.XPlus);
        AXIS_DIRECTION_MAPPING.put(DirectionAxis.Axis.X_MINUS, DirectionsLookup.Direction.XMinus);
        AXIS_DIRECTION_MAPPING.put(DirectionAxis.Axis.Y_PLUS, DirectionsLookup.Direction.YPlus);
        AXIS_DIRECTION_MAPPING.put(DirectionAxis.Axis.Y_MINUS, DirectionsLookup.Direction.YMinus);
        AXIS_DIRECTION_MAPPING.put(DirectionAxis.Axis.Z_PLUS, DirectionsLookup.Direction.ZPlus);
        AXIS_DIRECTION_MAPPING.put(DirectionAxis.Axis.Z_MINUS, DirectionsLookup.Direction.ZMinus);
        DIRECTION_MAP.put(DirectionsLookup.Direction.XPlus, DirectionAxis.Axis.X_PLUS);
        DIRECTION_MAP.put(DirectionsLookup.Direction.XMinus, DirectionAxis.Axis.X_MINUS);
        DIRECTION_MAP.put(DirectionsLookup.Direction.YPlus, DirectionAxis.Axis.Y_PLUS);
        DIRECTION_MAP.put(DirectionsLookup.Direction.YMinus, DirectionAxis.Axis.Y_MINUS);
        DIRECTION_MAP.put(DirectionsLookup.Direction.ZPlus, DirectionAxis.Axis.Z_PLUS);
        DIRECTION_MAP.put(DirectionsLookup.Direction.ZMinus, DirectionAxis.Axis.Z_MINUS);
    }

    public DirectionNodeImpl(MoveDirectionNode defaultDirectionNode, FeatureService featureService, SimpleValueFactory simpleValueFactory, WaypointNodeValidationStrategyProvider waypointNodeValidationStrategyProvider, FeatureWrapService featureWrapService) {
        this.featureService = featureService;
        this.defaultConfig = this.getConfigFromNode(defaultDirectionNode);
        this.simpleValueFactory = simpleValueFactory;
        this.waypointNodeValidationStrategyProvider = waypointNodeValidationStrategyProvider;
        this.featureWrapService = featureWrapService;
    }

    @Override
    public MoveDirectionNode createRealNode(RealNodeFactory realNodeFactory) {
        MoveDirectionNode realNode = realNodeFactory.create(this);
        this.setRealProgramNode(realNode);
        this.applyConfig(this.config, realNode);
        return realNode;
    }

    @Override
    public void doVisit(int i, int depth, ProgramNodeVisitor nodeVisitor) {
        nodeVisitor.visit((DirectionNode)this, i, depth);
    }

    public DirectionNodeConfigBuilder createConfigBuilder() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DirectionNodeImpl$AjcClosure1 directionNodeImpl$AjcClosure1 = new DirectionNodeImpl$AjcClosure1(objectArray);
        return (DirectionNodeConfigBuilder)UncaughtExceptionAspect.aspectOf().aroundMethod(directionNodeImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public synchronized DirectionNodeConfig getConfig() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DirectionNodeImpl$AjcClosure3 directionNodeImpl$AjcClosure3 = new DirectionNodeImpl$AjcClosure3(objectArray);
        return (DirectionNodeConfig)UncaughtExceptionAspect.aspectOf().aroundMethod(directionNodeImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ThrowIfNonCompoundProgramChanges
    public synchronized DirectionNode setConfig(DirectionNodeConfig config) {
        Object object;
        DirectionNodeConfig directionNodeConfig = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)directionNodeConfig);
        Object[] objectArray = new Object[]{this, directionNodeConfig, joinPoint};
        DirectionNodeImpl$AjcClosure7 directionNodeImpl$AjcClosure7 = new DirectionNodeImpl$AjcClosure7(objectArray);
        try {
            object = ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNodeImpl$AjcClosure7.linkStackClosureAndJoinPoint(69648));
            directionNodeImpl$AjcClosure7.unlink();
        }
        catch (Throwable throwable) {
            directionNodeImpl$AjcClosure7.unlink();
            throw throwable;
        }
        return (DirectionNode)object;
    }

    @CompoundProgramChange
    @IgnoreProgramChanges(NonUIThreadOnly=true)
    private DirectionNode doSetConfig(DirectionNodeConfig config) {
        DirectionNodeConfig directionNodeConfig = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)directionNodeConfig);
        Object[] objectArray = new Object[]{this, directionNodeConfig, joinPoint};
        DirectionNodeImpl$AjcClosure9 directionNodeImpl$AjcClosure9 = new DirectionNodeImpl$AjcClosure9(objectArray);
        return (DirectionNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(directionNodeImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void applyConfig(DirectionNodeConfig config, MoveDirectionNode node) {
        if (node != null && config != null) {
            this.applyToolMotionParameters(config, node);
            this.applyFeature(config, node);
            this.applyDirectionVector(config, node);
        }
    }

    private void applyToolMotionParameters(DirectionNodeConfig config, MoveDirectionNode node) {
        if (config.getDirectionMotionParameters().getType() == DirectionMotionParameters.ParameterType.SHARED_MOTION) {
            node.setToolMotionParams(Optional.empty());
        } else {
            ToolMotionParameters toolMotionParameters = (ToolMotionParameters)config.getDirectionMotionParameters();
            node.setToolMotionParams(Optional.of((Object)new MoveDirectionNode.ToolMotionParams(false, Speed.from((double)toolMotionParameters.getToolSpeed().getAs(Speed.Unit.M_S), (Speed.Unit)Speed.Unit.SI), Acceleration.from((double)toolMotionParameters.getToolAcceleration().getAs(Acceleration.Unit.M_S2), (Acceleration.Unit)Acceleration.Unit.SI))));
        }
    }

    private void applyFeature(DirectionNodeConfig config, MoveDirectionNode node) {
        if (config.getFeature().getType() == FeatureSelection.SelectionType.SHARED) {
            node.setFeatureReference(Optional.empty());
        } else if (config.getFeature().getType() == FeatureSelection.SelectionType.FEATURE) {
            DirectionNodeFeature directionNodeFeature = (DirectionNodeFeature)config.getFeature();
            Feature feature = directionNodeFeature.getFeature();
            SpatialFeature spatialFeature = this.featureWrapService.unwrapFeature(feature);
            SpatialFeatureReference spatialFeatureReference = feature.isVariable() ? this.featureService.getFeatureVariable(spatialFeature) : this.featureService.getFeatureReference(spatialFeature);
            node.setFeatureReference(Optional.of((Object)((GeomFeatureReferenceBase)spatialFeatureReference)));
        }
    }

    private void applyDirectionVector(DirectionNodeConfig config, MoveDirectionNode node) {
        if (config.getDirectionSelection().getType() == DirectionSelection.SelectionType.AXIS) {
            DirectionsLookup.Direction direction = AXIS_DIRECTION_MAPPING.get(((DirectionAxis)config.getDirectionSelection()).getAxis());
            node.setSelectedDirection(Optional.of((Object)direction));
            node.setExpression(Optional.empty());
        } else {
            Expression expression = ((DirectionVectorExpression)config.getDirectionSelection()).getExpression();
            node.setExpression(Optional.of((Object)((ExpressionImpl)expression).getExpressionBranchNode()));
            node.setSelectedDirection(Optional.empty());
        }
    }

    private DirectionNodeConfig getConfigFromNode(MoveDirectionNode directionNode) {
        DirectionNodeConfigBuilderImpl builder = new DirectionNodeConfigBuilderImpl(this.waypointNodeValidationStrategyProvider, this.simpleValueFactory){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            public DirectionNodeConfigBuilder setToolMotionParameters(@NotNull com.ur.urcap.api.domain.value.simple.Speed toolSpeed, ErrorHandler<com.ur.urcap.api.domain.value.simple.Speed> toolSpeedErrorHandler, @NotNull com.ur.urcap.api.domain.value.simple.Acceleration toolAcceleration, ErrorHandler<com.ur.urcap.api.domain.value.simple.Acceleration> toolAccelerationErrorHandler) {
                Object object;
                com.ur.urcap.api.domain.value.simple.Speed speed = toolSpeed;
                ErrorHandler<com.ur.urcap.api.domain.value.simple.Speed> errorHandler = toolSpeedErrorHandler;
                com.ur.urcap.api.domain.value.simple.Acceleration acceleration = toolAcceleration;
                ErrorHandler<com.ur.urcap.api.domain.value.simple.Acceleration> errorHandler2 = toolAccelerationErrorHandler;
                Object[] objectArray = new Object[]{speed, errorHandler, acceleration, errorHandler2};
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                Object[] objectArray2 = new Object[]{this, speed, errorHandler, acceleration, errorHandler2, joinPoint};
                DirectionNodeImpl$1$AjcClosure3 directionNodeImpl$1$AjcClosure3 = new DirectionNodeImpl$1$AjcClosure3(objectArray2);
                try {
                    object = UncaughtExceptionAspect.aspectOf().aroundMethod(directionNodeImpl$1$AjcClosure3.linkStackClosureAndJoinPoint(69648));
                    directionNodeImpl$1$AjcClosure3.unlink();
                }
                catch (Throwable throwable) {
                    directionNodeImpl$1$AjcClosure3.unlink();
                    throw throwable;
                }
                return (DirectionNodeConfigBuilder)object;
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ DirectionNodeConfigBuilder setToolMotionParameters_aroundBody0(1 ajc$this, com.ur.urcap.api.domain.value.simple.Speed toolSpeed, ErrorHandler toolSpeedErrorHandler, com.ur.urcap.api.domain.value.simple.Acceleration toolAcceleration, ErrorHandler toolAccelerationErrorHandler, JoinPoint joinPoint) {
                ajc$this.toolMotionParameters = new ToolMotionParametersImpl(toolSpeed, toolAcceleration);
                return ajc$this;
            }

            static final /* synthetic */ DirectionNodeConfigBuilder setToolMotionParameters_aroundBody2(1 var0, com.ur.urcap.api.domain.value.simple.Speed speed, ErrorHandler errorHandler, com.ur.urcap.api.domain.value.simple.Acceleration acceleration, ErrorHandler errorHandler2, JoinPoint joinPoint) {
                Object object;
                Object[] objectArray = new Object[]{var0, speed, errorHandler, acceleration, errorHandler2, joinPoint};
                DirectionNodeImpl$1$AjcClosure1 directionNodeImpl$1$AjcClosure1 = new DirectionNodeImpl$1$AjcClosure1(objectArray);
                try {
                    object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(directionNodeImpl$1$AjcClosure1.linkStackClosureAndJoinPoint(69648));
                    directionNodeImpl$1$AjcClosure1.unlink();
                }
                catch (Throwable throwable) {
                    directionNodeImpl$1$AjcClosure1.unlink();
                    throw throwable;
                }
                return (DirectionNodeConfigBuilder)object;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("DirectionNodeImpl.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setToolMotionParameters", "com.ur.urcap.domain.program.DirectionNodeImpl$1", "com.ur.urcap.api.domain.value.simple.Speed:com.ur.urcap.api.domain.validation.ErrorHandler:com.ur.urcap.api.domain.value.simple.Acceleration:com.ur.urcap.api.domain.validation.ErrorHandler", "toolSpeed:toolSpeedErrorHandler:toolAcceleration:toolAccelerationErrorHandler", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfigBuilder"), 192);
            }
        };
        Optional featureReference = directionNode.getFeatureReference();
        if (featureReference.isPresent()) {
            Feature feature = this.featureWrapService.wrapFeature((SpatialFeatureReference)featureReference.get());
            builder.setFeature(feature);
        } else {
            builder.setSharedFeature();
        }
        Optional selectedDirection = directionNode.getSelectedDirection();
        if (selectedDirection.isPresent()) {
            builder.setDirection(DIRECTION_MAP.get(selectedDirection.get()));
        } else {
            Optional expression = directionNode.getExpression();
            if (expression.isPresent()) {
                builder.setDirection(new ExpressionImpl((ExpressionBranchNode)expression.get()));
            }
        }
        Optional toolMotionParams = directionNode.getToolMotionParams();
        if (toolMotionParams.isPresent()) {
            MoveDirectionNode.ToolMotionParams params = (MoveDirectionNode.ToolMotionParams)toolMotionParams.get();
            builder.setToolMotionParameters((com.ur.urcap.api.domain.value.simple.Speed)params.speed, null, (com.ur.urcap.api.domain.value.simple.Acceleration)params.accel, null);
        } else {
            builder.setSharedToolMotionParameters();
        }
        return builder.build();
    }

    static final /* synthetic */ DirectionNodeConfigBuilder createConfigBuilder_aroundBody0(DirectionNodeImpl ajc$this, JoinPoint joinPoint) {
        return new DirectionNodeConfigBuilderImpl(ajc$this.waypointNodeValidationStrategyProvider, ajc$this.simpleValueFactory);
    }

    static final /* synthetic */ DirectionNodeConfig getConfig_aroundBody2(DirectionNodeImpl ajc$this, JoinPoint joinPoint) {
        MoveDirectionNode realNode = (MoveDirectionNode)ajc$this.getRealProgramNode();
        if (realNode != null) {
            ajc$this.config = ajc$this.getConfigFromNode(realNode);
        } else if (ajc$this.config == null) {
            ajc$this.config = ajc$this.defaultConfig;
        }
        return ajc$this.config;
    }

    static final /* synthetic */ DirectionNode setConfig_aroundBody4(DirectionNodeImpl ajc$this, DirectionNodeConfig config, JoinPoint joinPoint) {
        return ajc$this.doSetConfig(config);
    }

    static final /* synthetic */ DirectionNode setConfig_aroundBody6(DirectionNodeImpl directionNodeImpl, DirectionNodeConfig directionNodeConfig, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{directionNodeImpl, directionNodeConfig, joinPoint};
        DirectionNodeImpl$AjcClosure5 directionNodeImpl$AjcClosure5 = new DirectionNodeImpl$AjcClosure5(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(directionNodeImpl$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            directionNodeImpl$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            directionNodeImpl$AjcClosure5.unlink();
            throw throwable;
        }
        return (DirectionNode)object;
    }

    static final /* synthetic */ DirectionNode doSetConfig_aroundBody8(DirectionNodeImpl ajc$this, DirectionNodeConfig config, JoinPoint joinPoint) {
        ajc$this.config = config;
        MoveDirectionNode node = (MoveDirectionNode)ajc$this.getRealProgramNode();
        ajc$this.applyConfig(config, node);
        return ajc$this;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DirectionNodeImpl.java", DirectionNodeImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createConfigBuilder", "com.ur.urcap.domain.program.DirectionNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfigBuilder"), 100);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getConfig", "com.ur.urcap.domain.program.DirectionNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfig"), 105);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "setConfig", "com.ur.urcap.domain.program.DirectionNodeImpl", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfig", "config", "", "com.ur.urcap.api.domain.program.nodes.builtin.DirectionNode"), 117);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doSetConfig", "com.ur.urcap.domain.program.DirectionNodeImpl", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfig", "config", "", "com.ur.urcap.api.domain.program.nodes.builtin.DirectionNode"), 123);
    }
}

