/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program;

import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.program.undoredo.ThrowIfNonCompoundProgramChanges;
import com.ur.polyscope.valueobjects.Angle;
import com.ur.polyscope.valueobjects.AngularSpeed;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.Torque;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.CompliantLinearAxisForce;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.CompliantRotationalAxisTorque;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.ForceNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.ForceNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.FrameForceNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.LinearAxisSettings;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.NonCompliantLinearAxisLimit;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.NonCompliantRotationalAxisLimit;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.RotationalAxisSettings;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.AngularSpeed;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Torque;
import com.ur.urcap.domain.program.ForceNodeImpl$AjcClosure1;
import com.ur.urcap.domain.program.ForceNodeImpl$AjcClosure3;
import com.ur.urcap.domain.program.ForceNodeImpl$AjcClosure5;
import com.ur.urcap.domain.program.ForceNodeImpl$AjcClosure7;
import com.ur.urcap.domain.program.ForceNodeImpl$AjcClosure9;
import com.ur.urcap.domain.program.ProgramNodeImpl;
import com.ur.urcap.domain.program.RealNodeFactory;
import com.ur.urcap.domain.program.configurations.forcenode.CompliantLinearAxisForceImpl;
import com.ur.urcap.domain.program.configurations.forcenode.CompliantRotationalAxisTorqueImpl;
import com.ur.urcap.domain.program.configurations.forcenode.ForceNodeConfigFactoryImpl;
import com.ur.urcap.domain.program.configurations.forcenode.FrameForceNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.forcenode.NonCompliantLinearAxisLimitImpl;
import com.ur.urcap.domain.program.configurations.forcenode.NonCompliantRotationalAxisLimitImpl;
import com.ur.urcap.domain.program.configurations.forcenode.UnsupportedForceNodeConfigImpl;
import com.ur.view.polyscope.program.ForceType;
import gui.program.ForceNode;
import gui.program.services.geom.GeomFeatureReference;
import gui.program.validation.ForceNodeValidationStrategyProvider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ForceNodeImpl
extends ProgramNodeImpl<ForceNode>
implements com.ur.urcap.api.domain.program.nodes.builtin.ForceNode {
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final int RX = 3;
    private static final int RY = 4;
    private static final int RZ = 5;
    public static final int NON_COMPLIANT = 0;
    public static final int COMPLIANT = 1;
    private static final ForceNodeConfig SIMPLE_NODE;
    private static final ForceNodeConfig POINT_NODE;
    private static final ForceNodeConfig MOTION_NODE;
    private final ForceNodeConfigFactoryImpl configFactory;
    private final FeatureService featureService;
    private FeatureWrapService featureWrapService;
    private ForceNodeConfig defaultConfig;
    private ForceNodeConfig config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        ForceNodeImpl.ajc$preClinit();
        SIMPLE_NODE = new UnsupportedForceNodeConfigImpl(ForceNodeConfig.ConfigType.SIMPLE);
        POINT_NODE = new UnsupportedForceNodeConfigImpl(ForceNodeConfig.ConfigType.POINT);
        MOTION_NODE = new UnsupportedForceNodeConfigImpl(ForceNodeConfig.ConfigType.MOTION);
    }

    public ForceNodeImpl(ForceNode defaultForceNode, ForceNodeValidationStrategyProvider forceNodeValidationStrategyProvider, FeatureService featureService, SimpleValueFactory simpleValueFactory, FeatureWrapService featureWrapService) {
        this.featureWrapService = featureWrapService;
        this.configFactory = new ForceNodeConfigFactoryImpl(forceNodeValidationStrategyProvider);
        this.defaultConfig = this.wrapFrameForceNodeConfig(defaultForceNode);
        this.featureService = featureService;
    }

    @Override
    public ForceNode createRealNode(RealNodeFactory realNodeFactory) {
        this.setRealProgramNode(realNodeFactory.create(this));
        ForceNode realNode = (ForceNode)this.getRealProgramNode();
        if (realNode != null) {
            this.applyConfig(this.config, realNode);
        }
        return realNode;
    }

    @Override
    public void doVisit(int i, int depth, ProgramNodeVisitor nodeVisitor) {
        nodeVisitor.visit((com.ur.urcap.api.domain.program.nodes.builtin.ForceNode)this, i, depth);
    }

    public ForceNodeConfigFactory getConfigFactory() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ForceNodeImpl$AjcClosure1 forceNodeImpl$AjcClosure1 = new ForceNodeImpl$AjcClosure1(objectArray);
        return (ForceNodeConfigFactory)UncaughtExceptionAspect.aspectOf().aroundMethod(forceNodeImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ThrowIfNonCompoundProgramChanges
    public synchronized com.ur.urcap.api.domain.program.nodes.builtin.ForceNode setConfig(ForceNodeConfig config) {
        Object object;
        ForceNodeConfig forceNodeConfig = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)forceNodeConfig);
        Object[] objectArray = new Object[]{this, forceNodeConfig, joinPoint};
        ForceNodeImpl$AjcClosure5 forceNodeImpl$AjcClosure5 = new ForceNodeImpl$AjcClosure5(objectArray);
        try {
            object = ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNodeImpl$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            forceNodeImpl$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            forceNodeImpl$AjcClosure5.unlink();
            throw throwable;
        }
        return (com.ur.urcap.api.domain.program.nodes.builtin.ForceNode)object;
    }

    @CompoundProgramChange
    @IgnoreProgramChanges(NonUIThreadOnly=true)
    private com.ur.urcap.api.domain.program.nodes.builtin.ForceNode doSetConfig(ForceNodeConfig config) {
        ForceNodeConfig forceNodeConfig = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)forceNodeConfig);
        Object[] objectArray = new Object[]{this, forceNodeConfig, joinPoint};
        ForceNodeImpl$AjcClosure7 forceNodeImpl$AjcClosure7 = new ForceNodeImpl$AjcClosure7(objectArray);
        return (com.ur.urcap.api.domain.program.nodes.builtin.ForceNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(forceNodeImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public synchronized ForceNodeConfig getConfig() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ForceNodeImpl$AjcClosure9 forceNodeImpl$AjcClosure9 = new ForceNodeImpl$AjcClosure9(objectArray);
        return (ForceNodeConfig)UncaughtExceptionAspect.aspectOf().aroundMethod(forceNodeImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void applyConfig(ForceNodeConfig config, ForceNode realNode) {
        if (config == null) {
            return;
        }
        ForceNodeConfig.ConfigType type = config.getConfigType();
        switch (type) {
            case SIMPLE: {
                break;
            }
            case FRAME: {
                this.applyFrameConfig((FrameForceNodeConfig)config, realNode);
                break;
            }
            case POINT: {
                break;
            }
            case MOTION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ForceNode.ForceType:" + type);
            }
        }
    }

    private void applyFrameConfig(FrameForceNodeConfig config, ForceNode realNode) {
        realNode.setForceType(ForceType.FRAME);
        Feature feature = config.getFeature();
        GeomFeatureReference featureReference = (GeomFeatureReference)this.featureService.getFeatureReference(this.featureWrapService.unwrapFeature(feature));
        realNode.setFeatureReference(featureReference);
        ForceNodeImpl.applyLinearAxisSettings(realNode, config.getLinearAxisSettingsX(), 0);
        ForceNodeImpl.applyLinearAxisSettings(realNode, config.getLinearAxisSettingsY(), 1);
        ForceNodeImpl.applyLinearAxisSettings(realNode, config.getLinearAxisSettingsZ(), 2);
        ForceNodeImpl.applyRotationalAxisSettings(realNode, config.getRotationalAxisSettingsRX(), 3);
        ForceNodeImpl.applyRotationalAxisSettings(realNode, config.getRotationalAxisSettingsRY(), 4);
        ForceNodeImpl.applyRotationalAxisSettings(realNode, config.getRotationalAxisSettingsRZ(), 5);
    }

    private static void applyLinearAxisSettings(ForceNode realNode, LinearAxisSettings linearAxisSettings, int index) {
        LinearAxisSettings.LinearAxisSettingsType type = linearAxisSettings.getLinearAxisSettingsType();
        if (LinearAxisSettings.LinearAxisSettingsType.COMPLIANT == type) {
            realNode.setSelection(index, 1);
            CompliantLinearAxisForce compliantAxisForce = (CompliantLinearAxisForce)linearAxisSettings;
            double value = compliantAxisForce.getForce().getAs(Force.Unit.N);
            realNode.setWrench(index, value);
            double speedLimit = compliantAxisForce.getSpeedLimit().getAs(Speed.Unit.M_S);
            realNode.setForceControlSpeedLimit(index, speedLimit);
        } else if (LinearAxisSettings.LinearAxisSettingsType.NON_COMPLIANT == type) {
            realNode.setSelection(index, 0);
            NonCompliantLinearAxisLimit nonCompliantAxisLimit = (NonCompliantLinearAxisLimit)linearAxisSettings;
            double deviationLimit = nonCompliantAxisLimit.getDeviationLimit().getAs(Length.Unit.M);
            realNode.setMotionControlErrorLimit(index, deviationLimit);
        } else {
            throw new IllegalArgumentException("Unsupported LinearAxisForceType " + type);
        }
    }

    private static void applyRotationalAxisSettings(ForceNode realNode, RotationalAxisSettings rotationalAxisSettings, int index) {
        RotationalAxisSettings.RotationalAxisSettingsType type = rotationalAxisSettings.getRotationalAxisSettingsType();
        if (RotationalAxisSettings.RotationalAxisSettingsType.COMPLIANT == type) {
            realNode.setSelection(index, 1);
            CompliantRotationalAxisTorque compliantAxisTorque = (CompliantRotationalAxisTorque)rotationalAxisSettings;
            double torqueValue = compliantAxisTorque.getTorque().getAs(Torque.Unit.NM);
            realNode.setWrench(index, torqueValue);
            double speedLimit = compliantAxisTorque.getAngularSpeedLimit().getAs(AngularSpeed.Unit.RAD_S);
            realNode.setForceControlSpeedLimit(index, speedLimit);
        } else if (RotationalAxisSettings.RotationalAxisSettingsType.NON_COMPLIANT == type) {
            realNode.setSelection(index, 0);
            NonCompliantRotationalAxisLimit nonCompliantAxisLimit = (NonCompliantRotationalAxisLimit)rotationalAxisSettings;
            double angularDeviationLimit = nonCompliantAxisLimit.getAngularDeviationLimit().getAs(Angle.Unit.RAD);
            realNode.setMotionControlErrorLimit(index, angularDeviationLimit);
        } else {
            throw new IllegalArgumentException("Unsupported RotationalAxisForceType " + type);
        }
    }

    public ForceNodeConfig wrapConfigFromNode(ForceNode realNode) {
        ForceNodeConfig result;
        ForceType type = realNode.getForceType();
        switch (type) {
            case SIMPLE: {
                result = SIMPLE_NODE;
                break;
            }
            case FRAME: {
                result = this.wrapFrameForceNodeConfig(realNode);
                break;
            }
            case POINT: {
                result = POINT_NODE;
                break;
            }
            case MOTION: {
                result = MOTION_NODE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ForceNode.ForceType:" + type);
            }
        }
        return result;
    }

    private ForceNodeConfig wrapFrameForceNodeConfig(ForceNode realNode) {
        Feature feature = this.featureWrapService.wrapFeature((SpatialFeatureReference)realNode.getFeatureReference());
        LinearAxisSettings x = ForceNodeImpl.wrapLinearAxis(realNode, 0);
        LinearAxisSettings y = ForceNodeImpl.wrapLinearAxis(realNode, 1);
        LinearAxisSettings z = ForceNodeImpl.wrapLinearAxis(realNode, 2);
        RotationalAxisSettings rx = ForceNodeImpl.wrapRotationalAxis(realNode, 3);
        RotationalAxisSettings ry = ForceNodeImpl.wrapRotationalAxis(realNode, 4);
        RotationalAxisSettings rz = ForceNodeImpl.wrapRotationalAxis(realNode, 5);
        FrameForceNodeConfigImpl result = new FrameForceNodeConfigImpl(feature, x, y, z, rx, ry, rz);
        return result;
    }

    private static RotationalAxisSettings wrapRotationalAxis(ForceNode realNode, int i) {
        Object result;
        int selection = realNode.getSelection(i);
        if (selection == 0) {
            double limit = realNode.getMotionControlErrorLimit(i);
            Angle angularDeviationLimit = Angle.from((double)limit, (Angle.Unit)Angle.Unit.RADIANS);
            result = new NonCompliantRotationalAxisLimitImpl((com.ur.urcap.api.domain.value.simple.Angle)angularDeviationLimit);
        } else if (selection == 1) {
            double limit = realNode.getForceControlSpeedLimit(i);
            AngularSpeed angularSpeedLimit = AngularSpeed.from((double)limit, (AngularSpeed.Unit)AngularSpeed.Unit.RADIANS_S);
            double torqueValue = realNode.getWrench(i);
            com.ur.polyscope.valueobjects.Torque torque = com.ur.polyscope.valueobjects.Torque.from((double)torqueValue, (Torque.Unit)Torque.Unit.NM);
            result = new CompliantRotationalAxisTorqueImpl((Torque)torque, (com.ur.urcap.api.domain.value.simple.AngularSpeed)angularSpeedLimit);
        } else {
            throw new IllegalStateException("Illegal value of selection :" + selection + " node=" + realNode);
        }
        return result;
    }

    private static LinearAxisSettings wrapLinearAxis(ForceNode realNode, int i) {
        Object result;
        int selection = realNode.getSelection(i);
        if (selection == 0) {
            double limit = realNode.getMotionControlErrorLimit(i);
            Length speedLimit = Length.from((double)limit, (Length.Unit)Length.Unit.M);
            result = new NonCompliantLinearAxisLimitImpl((com.ur.urcap.api.domain.value.simple.Length)speedLimit);
        } else if (selection == 1) {
            double limit = realNode.getForceControlSpeedLimit(i);
            Speed speedLimit = Speed.from((double)limit, (Speed.Unit)Speed.Unit.SI);
            double forceValue = realNode.getWrench(i);
            Force force = Force.from((double)forceValue, (Force.Unit)Force.Unit.N);
            result = new CompliantLinearAxisForceImpl((com.ur.urcap.api.domain.value.simple.Force)force, (com.ur.urcap.api.domain.value.simple.Speed)speedLimit);
        } else {
            throw new IllegalStateException("Illegal value of selection :" + selection + " node=" + realNode);
        }
        return result;
    }

    static final /* synthetic */ ForceNodeConfigFactory getConfigFactory_aroundBody0(ForceNodeImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.configFactory;
    }

    static final /* synthetic */ com.ur.urcap.api.domain.program.nodes.builtin.ForceNode setConfig_aroundBody2(ForceNodeImpl ajc$this, ForceNodeConfig config, JoinPoint joinPoint) {
        return ajc$this.doSetConfig(config);
    }

    static final /* synthetic */ com.ur.urcap.api.domain.program.nodes.builtin.ForceNode setConfig_aroundBody4(ForceNodeImpl forceNodeImpl, ForceNodeConfig forceNodeConfig, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{forceNodeImpl, forceNodeConfig, joinPoint};
        ForceNodeImpl$AjcClosure3 forceNodeImpl$AjcClosure3 = new ForceNodeImpl$AjcClosure3(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(forceNodeImpl$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            forceNodeImpl$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            forceNodeImpl$AjcClosure3.unlink();
            throw throwable;
        }
        return (com.ur.urcap.api.domain.program.nodes.builtin.ForceNode)object;
    }

    static final /* synthetic */ com.ur.urcap.api.domain.program.nodes.builtin.ForceNode doSetConfig_aroundBody6(ForceNodeImpl ajc$this, ForceNodeConfig config, JoinPoint joinPoint) {
        ajc$this.config = config;
        ForceNode realNode = (ForceNode)ajc$this.getRealProgramNode();
        if (realNode != null) {
            ajc$this.applyConfig(config, realNode);
        }
        return ajc$this;
    }

    static final /* synthetic */ ForceNodeConfig getConfig_aroundBody8(ForceNodeImpl ajc$this, JoinPoint joinPoint) {
        ForceNode realNode = (ForceNode)ajc$this.getRealProgramNode();
        if (realNode != null) {
            ajc$this.config = ajc$this.wrapConfigFromNode(realNode);
        } else if (ajc$this.config == null) {
            ajc$this.config = ajc$this.defaultConfig;
        }
        return ajc$this.config;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ForceNodeImpl.java", ForceNodeImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigFactory", "com.ur.urcap.domain.program.ForceNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.ForceNodeConfigFactory"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "setConfig", "com.ur.urcap.domain.program.ForceNodeImpl", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.ForceNodeConfig", "config", "", "com.ur.urcap.api.domain.program.nodes.builtin.ForceNode"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doSetConfig", "com.ur.urcap.domain.program.ForceNodeImpl", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.ForceNodeConfig", "config", "", "com.ur.urcap.api.domain.program.nodes.builtin.ForceNode"), 99);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getConfig", "com.ur.urcap.domain.program.ForceNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.forcenode.ForceNodeConfig"), 109);
    }
}

