/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program;

import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.FolderNode;
import com.ur.polyscope.program.nodes.NonVisitable;
import com.ur.polyscope.program.nodes.URCapProgramNodeFactory;
import com.ur.polyscope.program.nodes.move.MoveNode;
import com.ur.polyscope.urcaps.nodeservices.PalletProgramNodeService;
import com.ur.polyscope.urcaps.nodeservices.ScrewdrivingProgramNode;
import com.ur.polyscope.urcaps.programnodes.NamedWaypointNode;
import com.ur.polyscope.urcaps.programnodes.ProgramNodeProxy;
import com.ur.urcap.api.domain.io.IOModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.builtin.CommentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.HomeNode;
import com.ur.urcap.api.domain.program.nodes.builtin.SetPayloadNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import com.ur.urcap.contribution.program.NodeFactoryProvider;
import com.ur.urcap.contribution.program.ProgramNodeFactory;
import com.ur.urcap.contribution.program.ProgramNodeServiceAdapter;
import com.ur.urcap.contribution.program.URCapContribution;
import com.ur.urcap.domain.program.AssignmentNodeImpl;
import com.ur.urcap.domain.program.CircleMoveNodeImpl;
import com.ur.urcap.domain.program.DirectionNodeImpl;
import com.ur.urcap.domain.program.ElseIfNodeImpl;
import com.ur.urcap.domain.program.ElseNodeImpl;
import com.ur.urcap.domain.program.ForceNodeImpl;
import com.ur.urcap.domain.program.HaltNodeImpl;
import com.ur.urcap.domain.program.IfNodeImpl;
import com.ur.urcap.domain.program.LoopNodeImpl;
import com.ur.urcap.domain.program.PalletNodeImpl;
import com.ur.urcap.domain.program.PalletURCapProgramNodeImpl;
import com.ur.urcap.domain.program.PopupNodeImpl;
import com.ur.urcap.domain.program.ProgramNodeImpl;
import com.ur.urcap.domain.program.ProgramNodeWrapperFactory;
import com.ur.urcap.domain.program.RealNodeFactory;
import com.ur.urcap.domain.program.ScrewdrivingURCapProgramNodeImpl;
import com.ur.urcap.domain.program.SeekNodeImpl;
import com.ur.urcap.domain.program.SetNodeImpl;
import com.ur.urcap.domain.program.URCapProgramNodeImpl;
import com.ur.urcap.domain.program.UntilNodeImpl;
import com.ur.urcap.domain.program.WaitNodeImpl;
import com.ur.urcap.domain.program.configurations.until.validation.UntilNodeValidators;
import com.ur.urcap.domain.variable.VariableFactoryImpl;
import gui.polyscope.contribution.Contribution;
import gui.program.AssignmentNode;
import gui.program.CircleMoveNode;
import gui.program.ContributableProgramNode;
import gui.program.EntityFactory;
import gui.program.ForceNode;
import gui.program.HaltNode;
import gui.program.IfNode;
import gui.program.LoopNode;
import gui.program.PalletNode;
import gui.program.PopupNode;
import gui.program.SafeHomeNode;
import gui.program.SpecialSequenceNode;
import gui.program.StackNode;
import gui.program.WaitNode;
import gui.program.direction.MoveDirectionNode;
import gui.program.services.ProgramReferenceService;
import gui.program.setnode.SetNode;
import gui.program.until.UntilNode;
import gui.program.validation.UntilIONodeValidationStrategyProvider;
import gui.program.validation.ValidationStrategyProviderService;
import javax.inject.Inject;
import javax.inject.Provider;

public class ProgramNodeWrapperFactoryImpl
implements ProgramNodeWrapperFactory {
    private final ValidationStrategyProviderService validationStrategyProviderService;
    private final ValueFactoryProvider valueFactoryProvider;
    private final VariableFactoryImpl variableFactory;
    private final Provider<CommentNode> commentNodeProvider;
    private final Provider<com.ur.urcap.api.domain.program.nodes.builtin.FolderNode> folderNodeProvider;
    private final Provider<com.ur.urcap.api.domain.program.nodes.builtin.MoveNode> moveNodeProvider;
    private final Provider<NamedWaypointNode> waypointNodeProvider;
    private Provider<SetPayloadNode> setPayloadNodeProvider;
    private final ProgramReferenceService programReferenceService;
    private final Provider<HomeNode> homeNodeProvider;
    private FeatureWrapService featureWrapService;
    private URCapProgramNodeFactory urCapProgramNodeFactory;
    private final IOModel ioModel;
    private final EntityFactory entityFactory;
    private final FeatureService featureService;
    private final Provider<UntilNodeValidators> untilNodeValidatorsProvider;

    @Inject
    public ProgramNodeWrapperFactoryImpl(ValidationStrategyProviderService validationStrategyProviderService, IOModel ioModel, EntityFactory entityFactory, FeatureService featureService, ValueFactoryProvider valueFactoryProvider, VariableFactoryImpl variableFactory, Provider<CommentNode> commentNodeProvider, Provider<com.ur.urcap.api.domain.program.nodes.builtin.FolderNode> folderNodeProvider, Provider<com.ur.urcap.api.domain.program.nodes.builtin.MoveNode> moveNodeProvider, Provider<NamedWaypointNode> waypointNodeProvider, Provider<UntilNodeValidators> untilNodeValidatorsProvider, Provider<HomeNode> homeNodeProvider, Provider<SetPayloadNode> setPayloadNodeProvider, ProgramReferenceService programReferenceService, FeatureWrapService featureWrapService, URCapProgramNodeFactory urCapProgramNodeFactory) {
        this.validationStrategyProviderService = validationStrategyProviderService;
        this.ioModel = ioModel;
        this.entityFactory = entityFactory;
        this.featureService = featureService;
        this.valueFactoryProvider = valueFactoryProvider;
        this.variableFactory = variableFactory;
        this.commentNodeProvider = commentNodeProvider;
        this.folderNodeProvider = folderNodeProvider;
        this.moveNodeProvider = moveNodeProvider;
        this.waypointNodeProvider = waypointNodeProvider;
        this.untilNodeValidatorsProvider = untilNodeValidatorsProvider;
        this.homeNodeProvider = homeNodeProvider;
        this.setPayloadNodeProvider = setPayloadNodeProvider;
        this.programReferenceService = programReferenceService;
        this.featureWrapService = featureWrapService;
        this.urCapProgramNodeFactory = urCapProgramNodeFactory;
    }

    @Override
    public ProgramNodeProxy<ContributableProgramNode> create(ContributableProgramNode contributableProgramNode) {
        Class serviceClass = this.getServiceClass(contributableProgramNode);
        Object node = this.urCapProgramNodeFactory.isSupported(serviceClass) ? (ProgramNodeProxy)this.urCapProgramNodeFactory.createProgramNode(serviceClass) : (this.isPalletURCapProgramNode(contributableProgramNode) ? new PalletURCapProgramNodeImpl(null) : (ProgramNodeWrapperFactoryImpl.isProgramNodeExtends(contributableProgramNode, ScrewdrivingProgramNode.class) ? new ScrewdrivingURCapProgramNodeImpl(null) : new URCapProgramNodeImpl(null)));
        node.setRealProgramNode((Object)contributableProgramNode);
        return node;
    }

    private Class getServiceClass(ContributableProgramNode contributableProgramNode) {
        ProgramNodeServiceAdapter programNodeServiceAdapter;
        Contribution contribution;
        if (contributableProgramNode != null && (contribution = contributableProgramNode.getContribution()) instanceof NodeFactoryProvider && (programNodeServiceAdapter = ((NodeFactoryProvider)contribution).getNodeFactory().getProgramNodeServiceAdapter()) != null) {
            return programNodeServiceAdapter.getURCapClass();
        }
        return null;
    }

    private static boolean isProgramNodeExtends(ContributableProgramNode programNode, Class<?> type) {
        Contribution contribution = programNode.getContribution();
        if (!(contribution instanceof URCapContribution)) {
            return false;
        }
        URCapContribution urCapContribution = (URCapContribution)contribution;
        ProgramNodeFactory factory = urCapContribution.getNodeFactory();
        if (factory == null) {
            return false;
        }
        ProgramNodeServiceAdapter serviceAdapter = factory.getProgramNodeServiceAdapter();
        if (serviceAdapter == null) {
            return false;
        }
        Class urcapClass = serviceAdapter.getURCapClass();
        if (urcapClass == null) {
            return false;
        }
        return type.isAssignableFrom(urcapClass);
    }

    private boolean isPalletURCapProgramNode(ContributableProgramNode contributableProgramNode) {
        if (contributableProgramNode.getContribution() != null && contributableProgramNode.getContribution() instanceof URCapContribution) {
            URCapContribution urCapContribution = (URCapContribution)contributableProgramNode.getContribution();
            ProgramNodeServiceAdapter programNodeServiceAdapter = urCapContribution.getNodeFactory().getProgramNodeServiceAdapter();
            return programNodeServiceAdapter != null && PalletProgramNodeService.class.isAssignableFrom(programNodeServiceAdapter.getURCapClass());
        }
        return false;
    }

    @Override
    public com.ur.urcap.api.domain.program.nodes.builtin.MoveNode create(MoveNode moveNode) {
        com.ur.urcap.api.domain.program.nodes.builtin.MoveNode node = (com.ur.urcap.api.domain.program.nodes.builtin.MoveNode)this.moveNodeProvider.get();
        ((ProgramNodeProxy)node).setRealProgramNode((Object)moveNode);
        return node;
    }

    @Override
    public WaypointNode create(gui.program.position.WaypointNode waypointNode) {
        WaypointNode node = (WaypointNode)this.waypointNodeProvider.get();
        ((ProgramNodeProxy)node).setRealProgramNode((Object)waypointNode);
        return node;
    }

    @Override
    public CommentNode create(com.ur.polyscope.program.nodes.CommentNode commentNode) {
        CommentNode node = (CommentNode)this.commentNodeProvider.get();
        ((ProgramNodeProxy)node).setRealProgramNode((Object)commentNode);
        return node;
    }

    @Override
    public HomeNode create(SafeHomeNode homeNode) {
        HomeNode node = (HomeNode)this.homeNodeProvider.get();
        ((ProgramNodeProxy)node).setRealProgramNode((Object)homeNode);
        return node;
    }

    @Override
    public SetPayloadNode create(com.ur.polyscope.program.nodes.setpayload.SetPayloadNode programNode) {
        SetPayloadNode node = (SetPayloadNode)this.setPayloadNodeProvider.get();
        ((ProgramNodeProxy)node).setRealProgramNode((Object)programNode);
        return node;
    }

    @Override
    public WaitNodeImpl create(WaitNode waitNode) {
        WaitNodeImpl node = new WaitNodeImpl(this.entityFactory.createWaitNode(), this.validationStrategyProviderService.getWaitNodeValidationStrategyProvider(), this.valueFactoryProvider.getSimpleValueFactory(), this.ioModel);
        node.setRealProgramNode(waitNode);
        return node;
    }

    @Override
    public SetNodeImpl create(SetNode setNode) {
        SetNodeImpl node = new SetNodeImpl(this.entityFactory.createSetNode(), this.validationStrategyProviderService.getSetNodeValidationStrategyProvider(), this.valueFactoryProvider.getSimpleValueFactory(), this.ioModel);
        node.setRealProgramNode(setNode);
        return node;
    }

    @Override
    public PopupNodeImpl create(PopupNode popupNode) {
        PopupNodeImpl node = new PopupNodeImpl(this.entityFactory.createPopupNode());
        node.setRealProgramNode(popupNode);
        return node;
    }

    @Override
    public HaltNodeImpl create(HaltNode haltNode) {
        HaltNodeImpl node = new HaltNodeImpl();
        node.setRealProgramNode(haltNode);
        return node;
    }

    @Override
    public com.ur.urcap.api.domain.program.nodes.builtin.FolderNode create(FolderNode folderNode) {
        com.ur.urcap.api.domain.program.nodes.builtin.FolderNode node = (com.ur.urcap.api.domain.program.nodes.builtin.FolderNode)this.folderNodeProvider.get();
        ((ProgramNodeProxy)node).setRealProgramNode((Object)folderNode);
        return node;
    }

    @Override
    public LoopNodeImpl create(LoopNode loopNode) {
        LoopNodeImpl node = new LoopNodeImpl(this.entityFactory.createLoopNode(), this.entityFactory.getNamingService(), this.validationStrategyProviderService.getLoopNodeValidationStrategyProvider(), this.variableFactory);
        node.setRealProgramNode(loopNode);
        return node;
    }

    @Override
    public AssignmentNodeImpl create(AssignmentNode assignmentNode) {
        AssignmentNodeImpl node = new AssignmentNodeImpl(this.entityFactory.createAssignmentNode(), this.variableFactory);
        node.setRealProgramNode(assignmentNode);
        return node;
    }

    @Override
    public ProgramNodeImpl create(IfNode node) {
        switch (node.getType()) {
            case IF: {
                IfNodeImpl ifnode = new IfNodeImpl(this.entityFactory.createIfNode());
                ifnode.setRealProgramNode(node);
                return ifnode;
            }
            case ELSE_IF: {
                ElseIfNodeImpl elseifnode = new ElseIfNodeImpl(this.entityFactory.createElseIfNode());
                elseifnode.setRealProgramNode(node);
                return elseifnode;
            }
            case ELSE: {
                ElseNodeImpl elsenode = new ElseNodeImpl();
                elsenode.setRealProgramNode(node);
                return elsenode;
            }
        }
        return null;
    }

    @Override
    public PalletNodeImpl create(PalletNode palletNode) {
        PalletNodeImpl node = new PalletNodeImpl();
        node.setRealProgramNode(palletNode);
        return node;
    }

    @Override
    public ForceNodeImpl create(ForceNode forceNode) {
        ForceNodeImpl node = new ForceNodeImpl(this.entityFactory.createForceNode(), this.validationStrategyProviderService.getForceNodeValidationStrategyProvider(), this.featureService, this.valueFactoryProvider.getSimpleValueFactory(), this.featureWrapService);
        node.setRealProgramNode(forceNode);
        return node;
    }

    @Override
    public SeekNodeImpl create(StackNode stackNode) {
        SeekNodeImpl node = new SeekNodeImpl();
        node.setRealProgramNode(stackNode);
        return node;
    }

    @Override
    public UntilNodeImpl create(UntilNode untilNode) {
        UntilNodeImpl node = new UntilNodeImpl(this.entityFactory.createUntilNode(), this.valueFactoryProvider.getSimpleValueFactory(), this.valueFactoryProvider.getBlendFactory(), this.untilNodeValidatorsProvider, (UntilIONodeValidationStrategyProvider)this.validationStrategyProviderService.getWaitNodeValidationStrategyProvider(), this.ioModel, this.programReferenceService);
        node.setRealProgramNode(untilNode);
        return node;
    }

    @Override
    public DirectionNodeImpl create(MoveDirectionNode directionNode) {
        DirectionNodeImpl node = new DirectionNodeImpl(this.entityFactory.createMoveDirectionNode(), this.featureService, this.valueFactoryProvider.getSimpleValueFactory(), this.validationStrategyProviderService.getWaypointNodeValidationStrategyProvider(), this.featureWrapService);
        node.setRealProgramNode(directionNode);
        return node;
    }

    @Override
    public ProgramNode create(AbstractProgramNode programNode) {
        URCapSupportedNode nodeType = this.getNodeType(programNode);
        switch (nodeType) {
            case ForceNode: {
                return this.create((ForceNode)programNode);
            }
            case MoveNode: {
                return this.create((MoveNode)programNode);
            }
            case LegacyWaypointNode: 
            case MeasuredWaypointNode: {
                return this.create((gui.program.position.WaypointNode)programNode);
            }
            case IfNode: {
                return this.create((IfNode)programNode);
            }
            case SetNode: {
                return this.create((SetNode)programNode);
            }
            case CommentNode: {
                return this.create((com.ur.polyscope.program.nodes.CommentNode)programNode);
            }
            case WaitNode: {
                return this.create((WaitNode)programNode);
            }
            case PopupNode: {
                return this.create((PopupNode)programNode);
            }
            case HaltNode: {
                return this.create((HaltNode)programNode);
            }
            case FolderNode: {
                return this.create((FolderNode)programNode);
            }
            case LoopNode: {
                return this.create((LoopNode)programNode);
            }
            case AssignmentNode: {
                return this.create((AssignmentNode)programNode);
            }
            case PalletNode: {
                return this.create((PalletNode)programNode);
            }
            case StackNode: {
                return this.create((StackNode)programNode);
            }
            case SpecialSequenceNode: {
                return this.create((SpecialSequenceNode)programNode);
            }
            case CircleMoveNode: {
                return this.create((CircleMoveNode)programNode);
            }
            case UntilNode: {
                return this.create((UntilNode)programNode);
            }
            case MoveDirectionNode: {
                return this.create((MoveDirectionNode)programNode);
            }
            case ContributableProgramNode: {
                return this.create((ContributableProgramNode)programNode);
            }
            case SafeHomeNode: {
                return this.create((SafeHomeNode)programNode);
            }
            case SetPayloadNode: {
                return this.create((com.ur.polyscope.program.nodes.setpayload.SetPayloadNode)programNode);
            }
            case ProgramNode: {
                return this.createProgramNode(programNode);
            }
        }
        return null;
    }

    @Override
    public ProgramNode create(SpecialSequenceNode specialSequenceNode) {
        ProgramNode node = this.createProgramNode((AbstractProgramNode)specialSequenceNode);
        return node;
    }

    @Override
    public ProgramNodeImpl create(CircleMoveNode circleMoveNode) {
        CircleMoveNodeImpl node = new CircleMoveNodeImpl();
        node.setRealProgramNode(circleMoveNode);
        return node;
    }

    private ProgramNode createProgramNode(final AbstractProgramNode programNode) {
        if (programNode instanceof ProgramNodeProxy && !(programNode instanceof NonVisitable)) {
            return (ProgramNodeProxy)programNode;
        }
        return new ProgramNodeImpl(){

            public AbstractProgramNode getRealProgramNode() {
                return programNode;
            }

            public AbstractProgramNode createRealNode(RealNodeFactory realNodeFactory) {
                return programNode;
            }

            @Override
            public void doVisit(int i, int depth, ProgramNodeVisitor nodeVisitor) {
            }
        };
    }

    private URCapSupportedNode getNodeType(AbstractProgramNode programNode) {
        try {
            return URCapSupportedNode.valueOf(programNode.getClass().getSimpleName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return URCapSupportedNode.ProgramNode;
        }
    }

    private static enum URCapSupportedNode {
        ProgramNode,
        ForceNode,
        MoveNode,
        LegacyWaypointNode,
        MeasuredWaypointNode,
        IfNode,
        SetNode,
        CommentNode,
        WaitNode,
        PopupNode,
        HaltNode,
        FolderNode,
        LoopNode,
        AssignmentNode,
        PalletNode,
        StackNode,
        ContributableProgramNode,
        SpecialSequenceNode,
        CircleMoveNode,
        UntilNode,
        MoveDirectionNode,
        SafeHomeNode,
        SetPayloadNode;

    }
}

