/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program;

import com.ur.urcap.contribution.program.ProgramNodeFactory;
import com.ur.urcap.domain.program.AssignmentNodeImpl;
import com.ur.urcap.domain.program.CircleMoveNodeImpl;
import com.ur.urcap.domain.program.DirectionNodeImpl;
import com.ur.urcap.domain.program.ElseIfNodeImpl;
import com.ur.urcap.domain.program.ElseNodeImpl;
import com.ur.urcap.domain.program.ForceNodeImpl;
import com.ur.urcap.domain.program.HaltNodeImpl;
import com.ur.urcap.domain.program.IfNodeImpl;
import com.ur.urcap.domain.program.LoopNodeImpl;
import com.ur.urcap.domain.program.PalletNodeImpl;
import com.ur.urcap.domain.program.PopupNodeImpl;
import com.ur.urcap.domain.program.RealNodeFactory;
import com.ur.urcap.domain.program.SeekNodeImpl;
import com.ur.urcap.domain.program.SetNodeImpl;
import com.ur.urcap.domain.program.URCapProgramNodeImpl;
import com.ur.urcap.domain.program.UntilNodeImpl;
import com.ur.urcap.domain.program.WaitNodeImpl;
import com.ur.view.variables.core.Variable;
import gui.program.AssignmentNode;
import gui.program.CircleMoveNode;
import gui.program.ContributableProgramNode;
import gui.program.EntityFactory;
import gui.program.ForceNode;
import gui.program.HaltNode;
import gui.program.IfNode;
import gui.program.LoopNode;
import gui.program.PalletNode;
import gui.program.PopupNode;
import gui.program.StackNode;
import gui.program.WaitNode;
import gui.program.direction.MoveDirectionNode;
import gui.program.setnode.SetNode;
import gui.program.until.UntilNode;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;

public class RealNodeFactoryImpl
implements RealNodeFactory {
    protected final EntityFactory entityFactory;

    @Inject
    public RealNodeFactoryImpl(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    @Override
    public ContributableProgramNode create(URCapProgramNodeImpl urcapProgramNode) {
        ProgramNodeFactory programNodeFactory = urcapProgramNode.getProgramNodeFactory();
        ContributableProgramNode programNode = programNodeFactory.createNode();
        if (programNode.getNodeType().isChildrenAllowed() && !this.hasURCapAddedSubtree(programNode)) {
            programNode.add((MutableTreeNode)this.entityFactory.createPlaceholderNode());
        }
        return programNode;
    }

    private boolean hasURCapAddedSubtree(ContributableProgramNode programNode) {
        return programNode.children().hasMoreElements();
    }

    @Override
    public WaitNode create(WaitNodeImpl waitNode) {
        return this.entityFactory.createWaitNode();
    }

    @Override
    public SetNode create(SetNodeImpl setNode) {
        return this.entityFactory.createSetNode();
    }

    @Override
    public UntilNode create(UntilNodeImpl untilNode) {
        return this.entityFactory.createUntilNode();
    }

    @Override
    public PopupNode create(PopupNodeImpl popupNode) {
        PopupNode node = this.entityFactory.createPopupNode();
        node.setMessage(popupNode.getMessageInternal());
        node.setType(popupNode.getDialogType());
        return node;
    }

    @Override
    public HaltNode create(HaltNodeImpl haltNode) {
        return this.entityFactory.createHaltNode();
    }

    @Override
    public LoopNode create(LoopNodeImpl loopNode) {
        return this.entityFactory.createLoopNode();
    }

    @Override
    public AssignmentNode create(AssignmentNodeImpl assignmentNode) {
        AssignmentNode node = this.entityFactory.createAssignmentNode();
        node.setVariable((Variable)this.entityFactory.createVariable());
        return node;
    }

    @Override
    public IfNode create(IfNodeImpl ifNode) {
        IfNode node = this.entityFactory.createIfNode();
        node.setExpressionNoUndo(ifNode.getExpressionBranchNode());
        return node;
    }

    @Override
    public CircleMoveNode create(CircleMoveNodeImpl circleMoveNode) {
        return this.entityFactory.createCircleMoveNode();
    }

    @Override
    public MoveDirectionNode create(DirectionNodeImpl directionNode) {
        return this.entityFactory.createMoveDirectionNode();
    }

    @Override
    public IfNode create(ElseIfNodeImpl elseIfNode) {
        IfNode node = this.entityFactory.createElseIfNode();
        node.setExpressionNoUndo(elseIfNode.getExpressionBranchNode());
        return node;
    }

    @Override
    public IfNode create(ElseNodeImpl elseNode) {
        return this.entityFactory.createElseNode();
    }

    @Override
    public PalletNode create(PalletNodeImpl palletNode) {
        return this.entityFactory.createPalletNode();
    }

    @Override
    public StackNode create(SeekNodeImpl seekNode) {
        return this.entityFactory.createStackNode();
    }

    @Override
    public ForceNode create(ForceNodeImpl forceNode) {
        return this.entityFactory.createForceNode();
    }
}

