/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program;

import com.ur.math.Time;
import com.ur.polyscope.pin.AbstractRegister;
import com.ur.polyscope.pin.GeneralPurposeBooleanRegister;
import com.ur.polyscope.pin.GeneralPurposeFloatRegister;
import com.ur.polyscope.pin.GeneralPurposeIntRegister;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.urcaps.IOImpl;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.program.undoredo.ThrowIfNonCompoundProgramChanges;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.urcap.api.domain.io.AnalogIO;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.io.IOFilterFactory;
import com.ur.urcap.api.domain.io.IOModel;
import com.ur.urcap.api.domain.io.ModbusIO;
import com.ur.urcap.api.domain.program.nodes.builtin.InvalidDomainException;
import com.ur.urcap.api.domain.program.nodes.builtin.SetNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.AnalogOutput;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.AnalogOutputCurrentSetNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.AnalogOutputSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.AnalogOutputVoltageSetNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.DigitalOutput;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.DigitalOutputSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.DigitalOutputSetNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.ExpressionOutput;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.ExpressionOutputSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.ExpressionOutputSetNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.FloatRegisterOutput;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.FloatRegisterOutputSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.FloatRegisterOutputSetNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SetNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SetNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SingleDigitalPulseSetNodeConfig;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.value.simple.Current;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Time;
import com.ur.urcap.api.domain.value.simple.Voltage;
import com.ur.urcap.domain.expression.ExpressionImpl;
import com.ur.urcap.domain.program.ProgramNodeImpl;
import com.ur.urcap.domain.program.RealNodeFactory;
import com.ur.urcap.domain.program.SetNodeImpl$1$AjcClosure1;
import com.ur.urcap.domain.program.SetNodeImpl$2$AjcClosure1;
import com.ur.urcap.domain.program.SetNodeImpl$3$AjcClosure1;
import com.ur.urcap.domain.program.SetNodeImpl$4$AjcClosure1;
import com.ur.urcap.domain.program.SetNodeImpl$AjcClosure1;
import com.ur.urcap.domain.program.SetNodeImpl$AjcClosure3;
import com.ur.urcap.domain.program.SetNodeImpl$AjcClosure5;
import com.ur.urcap.domain.program.SetNodeImpl$AjcClosure7;
import com.ur.urcap.domain.program.SetNodeImpl$AjcClosure9;
import com.ur.urcap.domain.program.configurations.setnode.AnalogOutputCurrentSetNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.setnode.AnalogOutputImpl;
import com.ur.urcap.domain.program.configurations.setnode.AnalogOutputVoltageSetNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.setnode.DigitalOutputImpl;
import com.ur.urcap.domain.program.configurations.setnode.DigitalOutputSetNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.setnode.ExpressionOutputImpl;
import com.ur.urcap.domain.program.configurations.setnode.FloatRegisterOutputImpl;
import com.ur.urcap.domain.program.configurations.setnode.FloatRegisterSetNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.setnode.OutputExpressionSetNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.setnode.SetNodeConfigFactoryImpl;
import com.ur.urcap.domain.program.configurations.setnode.SingleDigitalPulseSetNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.setnode.UnresolvedDigitalOutputImpl;
import com.ur.urcap.domain.program.configurations.setnode.UnresolvedOutputExpressionImpl;
import com.ur.urcap.installation.io.AnalogIOImpl;
import com.ur.urcap.installation.io.BooleanRegisterImpl;
import com.ur.urcap.installation.io.FloatRegisterImpl;
import com.ur.urcap.installation.io.IntegerRegisterImpl;
import gui.program.setnode.SetNode;
import gui.program.validation.SetNodeValidationStrategyProvider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SetNodeImpl
extends ProgramNodeImpl<gui.program.setnode.SetNode>
implements SetNode {
    private static final SetNodeConfig NO_TYPE_CONFIG;
    private static final SetNodeConfig NO_ACTION_CONFIG;
    private static final SetNodeConfig INCREMENT_VARIABLE_CONFIG;
    private static final ExpressionOutputSelection NO_OUTPUT_SELECTION;
    private static final DigitalOutputSelection NO_DIGITAL_OUTPUT;
    private static final AnalogOutputSelection NO_ANALOG_OUTPUT;
    private static final int OUTPUT_ACTION_LOWFALSE = 0;
    private static final int OUTPUT_ACTION_HIGHTRUE = 1;
    private static final int ELECTRIC_CURRENT_DOMAIN = 0;
    private final SimpleValueFactory valueFactory;
    private final IOModel ioModel;
    private final SetNodeConfig defaultConfig;
    private SetNodeConfigFactory configFactory;
    private SetNodeConfig config = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        SetNodeImpl.ajc$preClinit();
        NO_TYPE_CONFIG = SetNodeImpl.createConfigType(SetNodeConfig.ConfigType.NO_TYPE);
        NO_ACTION_CONFIG = SetNodeImpl.createConfigType(SetNodeConfig.ConfigType.NO_ACTION);
        INCREMENT_VARIABLE_CONFIG = SetNodeImpl.createConfigType(SetNodeConfig.ConfigType.INCREMENT_VARIABLE);
        NO_OUTPUT_SELECTION = SetNodeImpl.createOutputSelection(ExpressionOutputSelection.SelectionType.NO_OUTPUT);
        NO_DIGITAL_OUTPUT = SetNodeImpl.createDigitalOutputSelection(DigitalOutputSelection.SelectionType.NO_DIGITAL_OUTPUT);
        NO_ANALOG_OUTPUT = new AnalogOutputSelection(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public AnalogOutputSelection.SelectionType getType() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                SetNodeImpl$1$AjcClosure1 setNodeImpl$1$AjcClosure1 = new SetNodeImpl$1$AjcClosure1(objectArray);
                return (AnalogOutputSelection.SelectionType)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeImpl$1$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ AnalogOutputSelection.SelectionType getType_aroundBody0(1 ajc$this, JoinPoint joinPoint) {
                return AnalogOutputSelection.SelectionType.NO_ANALOG_OUTPUT;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SetNodeImpl.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.ur.urcap.domain.program.SetNodeImpl$1", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.AnalogOutputSelection$SelectionType"), 72);
            }
        };
    }

    public SetNodeImpl(gui.program.setnode.SetNode defaultSetNode, SetNodeValidationStrategyProvider validation, SimpleValueFactory valueFactory, IOModel ioModel) {
        this.configFactory = new SetNodeConfigFactoryImpl(validation);
        this.valueFactory = valueFactory;
        this.ioModel = ioModel;
        this.defaultConfig = this.getActualConfig(defaultSetNode);
    }

    private static ExpressionOutputSelection createOutputSelection(final ExpressionOutputSelection.SelectionType selectionType) {
        return new ExpressionOutputSelection(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public ExpressionOutputSelection.SelectionType getType() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                SetNodeImpl$2$AjcClosure1 setNodeImpl$2$AjcClosure1 = new SetNodeImpl$2$AjcClosure1(objectArray);
                return (ExpressionOutputSelection.SelectionType)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeImpl$2$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                2.ajc$preClinit();
            }

            static final /* synthetic */ ExpressionOutputSelection.SelectionType getType_aroundBody0(2 ajc$this, JoinPoint joinPoint) {
                return ajc$this.selectionType;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SetNodeImpl.java", 2.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.ur.urcap.domain.program.SetNodeImpl$2", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.ExpressionOutputSelection$SelectionType"), 99);
            }
        };
    }

    private static DigitalOutputSelection createDigitalOutputSelection(final DigitalOutputSelection.SelectionType selectionType) {
        return new DigitalOutputSelection(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public DigitalOutputSelection.SelectionType getType() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                SetNodeImpl$3$AjcClosure1 setNodeImpl$3$AjcClosure1 = new SetNodeImpl$3$AjcClosure1(objectArray);
                return (DigitalOutputSelection.SelectionType)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeImpl$3$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                3.ajc$preClinit();
            }

            static final /* synthetic */ DigitalOutputSelection.SelectionType getType_aroundBody0(3 ajc$this, JoinPoint joinPoint) {
                return ajc$this.selectionType;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SetNodeImpl.java", 3.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.ur.urcap.domain.program.SetNodeImpl$3", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.DigitalOutputSelection$SelectionType"), 108);
            }
        };
    }

    private static SetNodeConfig createConfigType(final SetNodeConfig.ConfigType configType) {
        return new SetNodeConfig(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public SetNodeConfig.ConfigType getConfigType() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                SetNodeImpl$4$AjcClosure1 setNodeImpl$4$AjcClosure1 = new SetNodeImpl$4$AjcClosure1(objectArray);
                return (SetNodeConfig.ConfigType)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeImpl$4$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                4.ajc$preClinit();
            }

            static final /* synthetic */ SetNodeConfig.ConfigType getConfigType_aroundBody0(4 ajc$this, JoinPoint joinPoint) {
                return ajc$this.configType;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SetNodeImpl.java", 4.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigType", "com.ur.urcap.domain.program.SetNodeImpl$4", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SetNodeConfig$ConfigType"), 117);
            }
        };
    }

    @Override
    public gui.program.setnode.SetNode createRealNode(RealNodeFactory realNodeFactory) {
        this.setRealProgramNode(realNodeFactory.create(this));
        gui.program.setnode.SetNode realProgramNode = (gui.program.setnode.SetNode)this.getRealProgramNode();
        if (this.config != null) {
            this.applyConfig(this.config, realProgramNode);
        }
        return realProgramNode;
    }

    @Override
    public void doVisit(int i, int depth, ProgramNodeVisitor nodeVisitor) {
        nodeVisitor.visit((SetNode)this, i, depth);
    }

    public SetNodeConfigFactory getConfigFactory() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SetNodeImpl$AjcClosure1 setNodeImpl$AjcClosure1 = new SetNodeImpl$AjcClosure1(objectArray);
        return (SetNodeConfigFactory)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ThrowIfNonCompoundProgramChanges
    public synchronized SetNode setConfig(SetNodeConfig setNodeConfig) throws InvalidDomainException {
        Object object;
        SetNodeConfig setNodeConfig2 = setNodeConfig;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)setNodeConfig2);
        Object[] objectArray = new Object[]{this, setNodeConfig2, joinPoint};
        SetNodeImpl$AjcClosure5 setNodeImpl$AjcClosure5 = new SetNodeImpl$AjcClosure5(objectArray);
        try {
            object = ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(setNodeImpl$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            setNodeImpl$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            setNodeImpl$AjcClosure5.unlink();
            throw throwable;
        }
        return (SetNode)object;
    }

    @IgnoreProgramChanges(NonUIThreadOnly=true)
    @CompoundProgramChange
    private SetNode doSetConfig(SetNodeConfig setNodeConfig) throws InvalidDomainException {
        SetNodeConfig setNodeConfig2 = setNodeConfig;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)setNodeConfig2);
        Object[] objectArray = new Object[]{this, setNodeConfig2, joinPoint};
        SetNodeImpl$AjcClosure7 setNodeImpl$AjcClosure7 = new SetNodeImpl$AjcClosure7(objectArray);
        return (SetNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(setNodeImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public synchronized SetNodeConfig getConfig() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SetNodeImpl$AjcClosure9 setNodeImpl$AjcClosure9 = new SetNodeImpl$AjcClosure9(objectArray);
        return (SetNodeConfig)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void verifyAnalogDomain(SetNodeConfig config) throws InvalidDomainException {
        AnalogIO io;
        if (this.isAnalogOutputCurrentAndHasOutput(config) && (io = ((AnalogOutput)((AnalogOutputCurrentSetNodeConfig)config).getOutputSelection()).getOutput()).isVoltage()) {
            throw new InvalidDomainException("Analog output is configured to voltage. Trying to set a current.");
        }
        if (this.isAnalogOutputVoltageAndHasOutput(config) && (io = ((AnalogOutput)((AnalogOutputVoltageSetNodeConfig)config).getOutputSelection()).getOutput()).isCurrent()) {
            throw new InvalidDomainException("Analog output is configured to electric current. Trying to set voltage.");
        }
    }

    private boolean isAnalogOutputCurrentAndHasOutput(SetNodeConfig config) {
        return config.getConfigType().equals((Object)SetNodeConfig.ConfigType.ANALOG_OUTPUT_CURRENT) && ((AnalogOutputCurrentSetNodeConfig)config).getOutputSelection().getType() == AnalogOutputSelection.SelectionType.ANALOG_OUTPUT;
    }

    private boolean isAnalogOutputVoltageAndHasOutput(SetNodeConfig config) {
        return config.getConfigType().equals((Object)SetNodeConfig.ConfigType.ANALOG_OUTPUT_VOLTAGE) && ((AnalogOutputVoltageSetNodeConfig)config).getOutputSelection().getType() == AnalogOutputSelection.SelectionType.ANALOG_OUTPUT;
    }

    private SetNodeConfig getActualConfig(gui.program.setnode.SetNode realNode) {
        switch (realNode.getType()) {
            case UNDEFINED: {
                return NO_TYPE_CONFIG;
            }
            case NO_ACTION: {
                return NO_ACTION_CONFIG;
            }
            case ANALOG_OUTPUT_ACTION: {
                return this.buildAnalogOutputConfig(realNode);
            }
            case DIGITAL_OUTPUT_ACTION: {
                return this.buildDigitalOutputConfig(realNode);
            }
            case EXPRESSION_OUTPUT_ACTION: {
                return this.buildExpressionOutputConfig(realNode);
            }
            case SINGLE_DIGITAL_PULSE: {
                return this.buildSingleDigitalPulseConfig(realNode);
            }
            case INCREMENT_VARIABLE: {
                return INCREMENT_VARIABLE_CONFIG;
            }
        }
        return NO_TYPE_CONFIG;
    }

    private SetNodeConfig buildExpressionOutputConfig(gui.program.setnode.SetNode node) {
        Pin digitalOutput = node.getDigitalExpressionOutput();
        Object io = null;
        if (digitalOutput != null && digitalOutput instanceof AbstractRegister) {
            if (digitalOutput instanceof GeneralPurposeBooleanRegister) {
                io = new BooleanRegisterImpl((Register<Boolean>)((Register)digitalOutput));
            } else if (digitalOutput instanceof GeneralPurposeFloatRegister) {
                io = new FloatRegisterImpl((Register<Float>)((Register)digitalOutput));
            } else if (digitalOutput instanceof GeneralPurposeIntRegister) {
                io = new IntegerRegisterImpl((Register<Integer>)((Register)digitalOutput));
            }
        } else {
            io = this.getIO(digitalOutput);
        }
        PinReference pinReference = node.getDigitalExpressionPinReference();
        ExpressionOutputSelection outputSelection = this.createOutputSelection(pinReference, (IO)io);
        return new OutputExpressionSetNodeConfigImpl(outputSelection, new ExpressionImpl(node.getExpression()));
    }

    private ExpressionOutputSelection createOutputSelection(PinReference pinReference, IO output) {
        if (pinReference != null && output != null) {
            return new ExpressionOutputImpl(output);
        }
        if (pinReference != null) {
            return new UnresolvedOutputExpressionImpl(pinReference);
        }
        return NO_OUTPUT_SELECTION;
    }

    private SetNodeConfig buildDigitalOutputConfig(gui.program.setnode.SetNode node) {
        Object io;
        Pin digitalOutputPin = node.getDigitalOutput();
        if (digitalOutputPin != null && digitalOutputPin instanceof AbstractRegister) {
            io = new BooleanRegisterImpl((Register<Boolean>)((Register)digitalOutputPin));
        } else {
            io = this.getIO(digitalOutputPin);
            if (io instanceof ModbusIO && !io.getType().equals((Object)IO.IOType.DIGITAL)) {
                io = null;
            }
        }
        PinReference pinReference = node.getDigitalPinReference();
        DigitalOutputSelection digitalOutputSelection = this.createDigitalOutputSelection(pinReference, (IO)io);
        return new DigitalOutputSetNodeConfigImpl(digitalOutputSelection, node.getDigitalValue() != 0);
    }

    private SetNodeConfig buildSingleDigitalPulseConfig(gui.program.setnode.SetNode node) {
        Object io;
        Pin digitalOutputPin = node.getSingleDigitalPulseActionState().getPinReference().dereference();
        if (digitalOutputPin != null && digitalOutputPin instanceof AbstractRegister) {
            io = new BooleanRegisterImpl((Register<Boolean>)((Register)digitalOutputPin));
        } else {
            io = this.getIO(digitalOutputPin);
            if (io instanceof ModbusIO && !io.getType().equals((Object)IO.IOType.DIGITAL)) {
                io = null;
            }
        }
        PinReference pinReference = node.getSingleDigitalPulseActionState().getPinReference();
        DigitalOutputSelection digitalOutputSelection = this.createDigitalOutputSelection(pinReference, (IO)io);
        return new SingleDigitalPulseSetNodeConfigImpl(digitalOutputSelection, (com.ur.urcap.api.domain.value.simple.Time)Time.from((double)node.getSingleDigitalPulseActionState().getTime().asDouble(), (Time.Unit)Time.Unit.S));
    }

    private DigitalOutputSelection createDigitalOutputSelection(PinReference pinReference, IO output) {
        if (pinReference != null && output != null) {
            return new DigitalOutputImpl(output);
        }
        if (pinReference != null) {
            return new UnresolvedDigitalOutputImpl(pinReference);
        }
        return NO_DIGITAL_OUTPUT;
    }

    private SetNodeConfig buildAnalogOutputConfig(gui.program.setnode.SetNode node) {
        Pin analogOutput = node.getAnalogOutput();
        if (analogOutput != null && analogOutput instanceof AbstractRegister) {
            FloatRegisterImpl floatRegister = new FloatRegisterImpl((Register<Float>)((Register)analogOutput));
            return new FloatRegisterSetNodeConfigImpl((FloatRegisterOutputSelection)new FloatRegisterOutputImpl(floatRegister), node.getAnalogValue());
        }
        AnalogIO analogIO = (AnalogIO)this.getIO(analogOutput);
        if (this.isElectricCurrentDomain(node) || analogIO == null) {
            return new AnalogOutputCurrentSetNodeConfigImpl(this.createAnalogOutputSelection(analogIO), this.valueFactory.createCurrent(node.getAnalogValue(), Current.Unit.mA));
        }
        return new AnalogOutputVoltageSetNodeConfigImpl((AnalogOutputSelection)new AnalogOutputImpl(analogIO), this.valueFactory.createVoltage(node.getAnalogValue(), Voltage.Unit.V));
    }

    private AnalogOutputSelection createAnalogOutputSelection(AnalogIO output) {
        return output != null ? new AnalogOutputImpl(output) : NO_ANALOG_OUTPUT;
    }

    private IO getIO(Pin<?> output) {
        for (IO io : this.ioModel.getIOs(IOFilterFactory.outputFilter())) {
            if (!((IOImpl)io).getIOPin().equals(output)) continue;
            return io;
        }
        return null;
    }

    private boolean isElectricCurrentDomain(gui.program.setnode.SetNode node) {
        return node.getAnalogOutputDomain() == 0;
    }

    private void applyConfig(SetNodeConfig config, gui.program.setnode.SetNode realNode) {
        if (config == null) {
            return;
        }
        switch (config.getConfigType()) {
            case DIGITAL_OUTPUT: {
                this.applyDigitalOutputConfig((DigitalOutputSetNodeConfig)config, realNode);
                break;
            }
            case ANALOG_OUTPUT_CURRENT: {
                this.applyAnalogOutputCurrentConfig((AnalogOutputCurrentSetNodeConfig)config, realNode);
                break;
            }
            case ANALOG_OUTPUT_VOLTAGE: {
                this.applyAnalogOutputVoltageConfig((AnalogOutputVoltageSetNodeConfig)config, realNode);
                break;
            }
            case FLOAT_REGISTER_OUTPUT: {
                this.applyFloatRegisterConfig((FloatRegisterOutputSetNodeConfig)config, realNode);
                break;
            }
            case EXPRESSION_OUTPUT: {
                this.applyOutputExpressionConfig((ExpressionOutputSetNodeConfig)config, realNode);
                break;
            }
            case SINGLE_DIGITAL_PULSE: {
                this.applySingleDigitalPulseConfig((SingleDigitalPulseSetNodeConfig)config, realNode);
                break;
            }
            case NO_ACTION: {
                realNode.setType(SetNode.Type.NO_ACTION);
                break;
            }
            case NO_TYPE: {
                realNode.setType(SetNode.Type.UNDEFINED);
                break;
            }
            case INCREMENT_VARIABLE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported configuration type: " + config.getConfigType());
            }
        }
    }

    private void applyDigitalOutputConfig(DigitalOutputSetNodeConfig config, gui.program.setnode.SetNode realNode) {
        realNode.setDigitalValueAndType(config.getValueToSet() ? 1 : 0);
        this.setDigitalOutPutOnNode(config.getOutputSelection(), realNode);
    }

    private void setDigitalOutPutOnNode(DigitalOutputSelection outputSelection, gui.program.setnode.SetNode realNode) {
        if (outputSelection.getType() == DigitalOutputSelection.SelectionType.DIGITAL_OUTPUT) {
            Pin ioPin = ((IOImpl)((DigitalOutput)outputSelection).getOutput()).getIOPin();
            realNode.setDigitalOutput(ioPin);
        } else if (outputSelection.getType() == DigitalOutputSelection.SelectionType.UNRESOLVED_DIGITAL_OUTPUT) {
            if (outputSelection instanceof UnresolvedDigitalOutputImpl) {
                PinReference pinReference = ((UnresolvedDigitalOutputImpl)outputSelection).getPinReference();
                realNode.setDigitalPinReference(pinReference);
            }
        } else {
            realNode.setDigitalOutput(null);
        }
    }

    private void applyAnalogOutputCurrentConfig(AnalogOutputCurrentSetNodeConfig config, gui.program.setnode.SetNode realNode) {
        Pin<?> ioPin = this.getAnalogOutputPin(config.getOutputSelection());
        realNode.setAnalogOutput(ioPin);
        realNode.setAnalogValueAndType(config.getCurrent().getAs(Current.Unit.mA));
    }

    private void applyAnalogOutputVoltageConfig(AnalogOutputVoltageSetNodeConfig config, gui.program.setnode.SetNode realNode) {
        Pin<?> ioPin = this.getAnalogOutputPin(config.getOutputSelection());
        realNode.setAnalogOutput(ioPin);
        realNode.setAnalogValueAndType(config.getVoltage().getAs(Voltage.Unit.V));
    }

    private Pin<?> getAnalogOutputPin(AnalogOutputSelection analogOutputSelection) {
        return analogOutputSelection.getType() == AnalogOutputSelection.SelectionType.ANALOG_OUTPUT ? ((AnalogIOImpl)((AnalogOutput)analogOutputSelection).getOutput()).getIOPin() : null;
    }

    private void applyFloatRegisterConfig(FloatRegisterOutputSetNodeConfig config, gui.program.setnode.SetNode realNode) {
        Pin<?> ioPin = this.getFloatRegisterPin(config.getOutputSelection());
        realNode.setTypeAndResetOthers(SetNode.Type.ANALOG_OUTPUT_ACTION);
        realNode.setAnalogOutput(ioPin);
        realNode.setAnalogValue((double)config.getValueToSet());
    }

    private Pin<?> getFloatRegisterPin(FloatRegisterOutputSelection floatRegisterSelection) {
        return floatRegisterSelection.getType() == FloatRegisterOutputSelection.SelectionType.FLOAT_REGISTER_OUTPUT ? ((IOImpl)((FloatRegisterOutput)floatRegisterSelection).getOutput()).getIOPin() : null;
    }

    private void applyOutputExpressionConfig(ExpressionOutputSetNodeConfig config, gui.program.setnode.SetNode realNode) {
        realNode.setExpressionAndType(((ExpressionImpl)config.getExpression()).getExpressionBranchNode());
        this.setExpressionOutputOnNode(config.getOutputSelection(), realNode);
    }

    private void setExpressionOutputOnNode(ExpressionOutputSelection outputSelection, gui.program.setnode.SetNode realNode) {
        if (outputSelection.getType() == ExpressionOutputSelection.SelectionType.OUTPUT) {
            Pin ioPin = ((IOImpl)((ExpressionOutput)outputSelection).getOutput()).getIOPin();
            realNode.setDigitalExpressionOutput(ioPin);
        } else if (outputSelection.getType() == ExpressionOutputSelection.SelectionType.UNRESOLVED_OUTPUT) {
            if (outputSelection instanceof UnresolvedOutputExpressionImpl) {
                PinReference pinReference = ((UnresolvedOutputExpressionImpl)outputSelection).getPinReference();
                realNode.setDigitalExpressionPinReference(pinReference);
            }
        } else {
            realNode.setDigitalExpressionOutput(null);
        }
    }

    private void applySingleDigitalPulseConfig(SingleDigitalPulseSetNodeConfig config, gui.program.setnode.SetNode realNode) {
        realNode.setSingleDigitalPulseAndType(this.getDigitalOutputPin(config.getOutputSelection()), com.ur.math.Time.from((double)config.getPulseTime().getAs(Time.Unit.S), (Time.Unit)Time.Unit.SECONDS));
    }

    private Pin getDigitalOutputPin(DigitalOutputSelection outputSelection) {
        Pin ioPin = null;
        if (outputSelection.getType() == DigitalOutputSelection.SelectionType.DIGITAL_OUTPUT) {
            ioPin = ((IOImpl)((DigitalOutput)outputSelection).getOutput()).getIOPin();
        } else if (outputSelection.getType() == DigitalOutputSelection.SelectionType.UNRESOLVED_DIGITAL_OUTPUT && outputSelection instanceof UnresolvedDigitalOutputImpl) {
            PinReference pinReference = ((UnresolvedDigitalOutputImpl)outputSelection).getPinReference();
            ioPin = pinReference.dereference();
        }
        return ioPin;
    }

    static final /* synthetic */ SetNodeConfigFactory getConfigFactory_aroundBody0(SetNodeImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.configFactory;
    }

    static final /* synthetic */ SetNode setConfig_aroundBody2(SetNodeImpl ajc$this, SetNodeConfig setNodeConfig, JoinPoint joinPoint) {
        return ajc$this.doSetConfig(setNodeConfig);
    }

    static final /* synthetic */ SetNode setConfig_aroundBody4(SetNodeImpl setNodeImpl, SetNodeConfig setNodeConfig, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{setNodeImpl, setNodeConfig, joinPoint};
        SetNodeImpl$AjcClosure3 setNodeImpl$AjcClosure3 = new SetNodeImpl$AjcClosure3(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeImpl$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            setNodeImpl$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            setNodeImpl$AjcClosure3.unlink();
            throw throwable;
        }
        return (SetNode)object;
    }

    static final /* synthetic */ SetNode doSetConfig_aroundBody6(SetNodeImpl ajc$this, SetNodeConfig setNodeConfig, JoinPoint joinPoint) {
        gui.program.setnode.SetNode realProgramNode;
        if (setNodeConfig != null) {
            ajc$this.verifyAnalogDomain(setNodeConfig);
            ajc$this.config = setNodeConfig;
        }
        if ((realProgramNode = (gui.program.setnode.SetNode)ajc$this.getRealProgramNode()) != null) {
            ajc$this.applyConfig(ajc$this.config, realProgramNode);
        }
        return ajc$this;
    }

    static final /* synthetic */ SetNodeConfig getConfig_aroundBody8(SetNodeImpl ajc$this, JoinPoint joinPoint) {
        gui.program.setnode.SetNode realNode = (gui.program.setnode.SetNode)ajc$this.getRealProgramNode();
        if (realNode != null) {
            ajc$this.config = ajc$this.getActualConfig(realNode);
        } else if (ajc$this.config == null) {
            ajc$this.config = ajc$this.defaultConfig;
        }
        return ajc$this.config;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SetNodeImpl.java", SetNodeImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigFactory", "com.ur.urcap.domain.program.SetNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SetNodeConfigFactory"), 139);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "setConfig", "com.ur.urcap.domain.program.SetNodeImpl", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SetNodeConfig", "setNodeConfig", "com.ur.urcap.api.domain.program.nodes.builtin.InvalidDomainException", "com.ur.urcap.api.domain.program.nodes.builtin.SetNode"), 145);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doSetConfig", "com.ur.urcap.domain.program.SetNodeImpl", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SetNodeConfig", "setNodeConfig", "com.ur.urcap.api.domain.program.nodes.builtin.InvalidDomainException", "com.ur.urcap.api.domain.program.nodes.builtin.SetNode"), 151);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getConfig", "com.ur.urcap.domain.program.SetNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.setnode.SetNodeConfig"), 164);
    }
}

