/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.domain.program.CompatibleWaypointNodeUnderMoveNode;
import com.ur.util.logging.Log;
import gui.polyscope.program.AbstractInsertNodeStrategy;
import gui.polyscope.program.rules.insertion.IfNodeContextInsertRule;
import gui.polyscope.program.rules.insertion.NoChildrenForLeafNodes;
import gui.program.EntityFactory;
import java.util.Set;
import javax.inject.Inject;

public class SubTreeInsertionRules
extends AbstractInsertNodeStrategy {
    @Inject
    public SubTreeInsertionRules(EntityFactory entityFactory, Set<ProgramNodeInsertionRule> contributedRules) {
        super(entityFactory);
        this.addRule((ProgramNodeInsertionRule)new NoChildrenForLeafNodes());
        this.addRule((ProgramNodeInsertionRule)new IfNodeContextInsertRule());
        this.addRule(new CompatibleWaypointNodeUnderMoveNode());
        for (ProgramNodeInsertionRule contributedRule : contributedRules) {
            this.addRule(contributedRule);
        }
    }

    public boolean insert(AbstractProgramNode toInsert, AbstractProgramNode pivot) {
        return false;
    }

    public boolean canInsertEx(AbstractProgramNode childNode, AbstractProgramNode parentNode, int index) throws TreeStructureException {
        for (ProgramNodeInsertionRule each : this.rules) {
            if (each.canInsert(childNode, parentNode, index)) continue;
            String errorMessage = each.getErrorMessage(childNode, parentNode, index);
            Log.error((String)errorMessage);
            throw new TreeStructureException(errorMessage);
        }
        return true;
    }
}

