/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeRemovalRule;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.util.logging.Log;
import gui.polyscope.program.AbstractRemoveNodeStrategy;
import gui.polyscope.program.rules.removal.IfNodeContextRemoveRule;
import java.util.Set;
import javax.inject.Inject;

public class SubTreeRemovalRules
extends AbstractRemoveNodeStrategy {
    @Inject
    public SubTreeRemovalRules(Set<ProgramNodeRemovalRule> contributedRules) {
        this.addRule((ProgramNodeRemovalRule)new IfNodeContextRemoveRule());
        for (ProgramNodeRemovalRule contributedRule : contributedRules) {
            this.addRule(contributedRule);
        }
    }

    public boolean canRemoveEx(AbstractProgramNode childNode) throws TreeStructureException {
        for (ProgramNodeRemovalRule rule : this.rules) {
            if (rule.canRemove(childNode)) continue;
            String errorMessage = rule.getErrorMessage(childNode);
            Log.error((String)errorMessage);
            throw new TreeStructureException(errorMessage);
        }
        return true;
    }
}

