/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program.configurations.until;

import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.urcaps.IOImpl;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.polyscope.valueobjects.Length;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.CompareOperator;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.AnalogInputUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.BlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.CustomBlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.CustomDecelerationParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.DecelerationParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.DigitalInputUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.DistanceUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.ExpressionUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.FloatRegisterInputUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.IOInputUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.UntilNodeConfig;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.AngularAcceleration;
import com.ur.urcap.api.domain.value.simple.Current;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Voltage;
import com.ur.urcap.domain.expression.ExpressionImpl;
import com.ur.urcap.domain.program.configurations.until.IOInputUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.ToolContactUntilNodeConfig;
import com.ur.urcap.installation.io.AnalogIOImpl;
import com.ur.urcap.installation.io.FloatRegisterImpl;
import com.ur.util.Optional;
import gui.program.services.ProgramReferenceService;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.deceleration.UntilDecelerationCustom;
import gui.program.until.deceleration.UntilDecelerationShared;
import gui.program.until.types.AnalogPinReference;
import gui.program.until.types.DigitalPinReference;
import gui.program.until.types.NullUntilTypeNode;
import gui.program.until.types.UntilContactDetection;
import gui.program.until.types.UntilDistanceNode;
import gui.program.until.types.UntilExpressionNode;
import gui.program.until.types.UntilIONode;
import gui.program.until.types.UntilReachedWaypointNode;

public class UntilNodeConfigApplyer {
    private final ProgramReferenceService programReferenceService;

    public UntilNodeConfigApplyer(ProgramReferenceService programReferenceService) {
        this.programReferenceService = programReferenceService;
    }

    public void applyConfig(UntilNodeConfig config, UntilNode node) {
        switch (config.getConfigType()) {
            case EXPRESSION: {
                this.applyExpressionNode((ExpressionUntilNodeConfig)config, node);
                break;
            }
            case DISTANCE: {
                this.applyDistanceNode((DistanceUntilNodeConfig)config, node);
                break;
            }
            case IO_INPUT: {
                this.applyIONode((IOInputUntilNodeConfig)config, node);
                break;
            }
            case NONE: {
                node.setSelectedTypeNode((UntilTypeNode)new NullUntilTypeNode());
                break;
            }
            case REACHED_WAYPOINT: {
                this.applyReachedWaypointNode(node);
                break;
            }
            case TOOL_CONTACT: {
                this.applyToolContactNode((ToolContactUntilNodeConfig)config, node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't apply configuration for unsupported config type: " + config.getConfigType());
            }
        }
    }

    private void applyToolContactNode(ToolContactUntilNodeConfig config, UntilNode node) {
        UntilContactDetection untilContactDetection = new UntilContactDetection(config.getRetractToAvoidClamping(), config.getUntilDeceleration(), config.getForceThreshold());
        untilContactDetection.setParent((com.ur.polyscope.program.nodes.until.UntilNode)node);
        node.setSelectedTypeNode((UntilTypeNode)untilContactDetection);
    }

    private void applyIONode(IOInputUntilNodeConfig config, UntilNode node) {
        UntilIONode untilIONode;
        switch (config.getType()) {
            case ANALOG_INPUT: {
                untilIONode = this.createAnalogInputUntilIONode((AnalogInputUntilNodeConfig)config);
                break;
            }
            case DIGITAL_INPUT: {
                untilIONode = this.createDigitalInputUntilIONode((DigitalInputUntilNodeConfig)config);
                break;
            }
            case FLOAT_REGISTER_INPUT: {
                untilIONode = this.createFloatRegisterInputUntulIONode((FloatRegisterInputUntilNodeConfig)config);
                break;
            }
            case NONE: {
                untilIONode = this.createUnresolved(config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't apply config for unsupported io node type " + config.getType());
            }
        }
        untilIONode.setParent((com.ur.polyscope.program.nodes.until.UntilNode)node);
        node.setSelectedTypeNode((UntilTypeNode)untilIONode);
    }

    private UntilIONode createUnresolved(IOInputUntilNodeConfig config) {
        if (!(config instanceof IOInputUntilNodeConfigImpl)) {
            return new UntilIONode();
        }
        IOInputUntilNodeConfigImpl undefinedConfig = (IOInputUntilNodeConfigImpl)config;
        DigitalPinReference digital = undefinedConfig.getDigitalPinReference();
        AnalogPinReference analog = undefinedConfig.getAnalogPinReference();
        UntilIONode untilIONode = digital != null ? new UntilIONode(digital) : (analog != null ? new UntilIONode(analog) : new UntilIONode());
        return untilIONode;
    }

    private UntilIONode createAnalogInputUntilIONode(AnalogInputUntilNodeConfig config) {
        AnalogIOImpl io = (AnalogIOImpl)config.getInput();
        PinReference pinReference = this.programReferenceService.getPinReference(io.getIOPin());
        double value = 0.0;
        if (config.getInputDomainType() == AnalogInputUntilNodeConfig.InputDomainType.VOLTAGE) {
            value = config.getVoltageThreshold().getAs(Voltage.Unit.V);
        } else if (config.getInputDomainType() == AnalogInputUntilNodeConfig.InputDomainType.CURRENT) {
            value = config.getCurrentThreshold().getAs(Current.Unit.mA);
        }
        AnalogPinReference analogPinReference = new AnalogPinReference(Optional.of((Object)pinReference), this.convertComparator(config.getCompareOperator()), value);
        return new UntilIONode(analogPinReference);
    }

    private UntilIONode createDigitalInputUntilIONode(DigitalInputUntilNodeConfig config) {
        IOImpl io = (IOImpl)config.getInput();
        PinReference pinReference = this.programReferenceService.getPinReference(io.getIOPin());
        DigitalPinReference digitalPinReference = new DigitalPinReference(Optional.of((Object)pinReference), config.getValueToProceedUntil());
        return new UntilIONode(digitalPinReference);
    }

    private UntilIONode createFloatRegisterInputUntulIONode(FloatRegisterInputUntilNodeConfig config) {
        FloatRegisterImpl io = (FloatRegisterImpl)config.getInput();
        PinReference pinReference = this.programReferenceService.getPinReference(io.getIOPin());
        AnalogPinReference analogPinReference = new AnalogPinReference(Optional.of((Object)pinReference), this.convertComparator(config.getCompareOperator()), (double)config.getThreshold());
        return new UntilIONode(analogPinReference);
    }

    private void applyExpressionNode(ExpressionUntilNodeConfig config, UntilNode node) {
        UntilDecelerationShared deceleration;
        if (config.getDecelerationParameters().getType() == DecelerationParameters.ParameterType.SHARED_DECELERATION) {
            deceleration = new UntilDecelerationShared(node);
        } else {
            CustomDecelerationParameters customDecelerationParams = (CustomDecelerationParameters)config.getDecelerationParameters();
            Acceleration realAcceleration = Acceleration.from((double)customDecelerationParams.getCartesianDeceleration().getAs(Acceleration.Unit.M_S2), (Acceleration.Unit)Acceleration.Unit.SI);
            AngularAcceleration realAngularAcceleration = AngularAcceleration.from((double)customDecelerationParams.getAngularDeceleration().getAs(AngularAcceleration.Unit.RAD_S2), (AngularAcceleration.Unit)AngularAcceleration.Unit.SI);
            deceleration = new UntilDecelerationCustom(realAcceleration, realAngularAcceleration);
        }
        UntilExpressionNode untilExpressionNode = new UntilExpressionNode(((ExpressionImpl)config.getExpression()).getExpressionBranchNode(), (UntilDeceleration)deceleration);
        untilExpressionNode.setParent((com.ur.polyscope.program.nodes.until.UntilNode)node);
        node.setSelectedTypeNode((UntilTypeNode)untilExpressionNode);
    }

    private void applyDistanceNode(DistanceUntilNodeConfig config, UntilNode node) {
        UntilDistanceNode untilDistanceNode;
        if (config.getBlendParameters().getType() == BlendParameters.ParameterType.NO_BLEND) {
            untilDistanceNode = new UntilDistanceNode(Length.from((double)config.getDistance().getAs(Length.Unit.M), (Length.Unit)Length.Unit.M));
        } else {
            CustomBlendParameters untilBlendParameters = (CustomBlendParameters)config.getBlendParameters();
            com.ur.urcap.api.domain.value.simple.Length radius = untilBlendParameters.getBlend().getRadiusLength();
            untilDistanceNode = new UntilDistanceNode(Length.from((double)config.getDistance().getAs(Length.Unit.M), (Length.Unit)Length.Unit.M), Length.from((double)radius.getAs(Length.Unit.M), (Length.Unit)Length.Unit.SI), UntilDistanceNode.DistanceNodeType.BLEND);
        }
        untilDistanceNode.setParent((com.ur.polyscope.program.nodes.until.UntilNode)node);
        node.setSelectedTypeNode((UntilTypeNode)untilDistanceNode);
    }

    private AnalogPinReference.Comparision convertComparator(CompareOperator compareOperator) {
        return compareOperator == CompareOperator.GREATER_THAN ? AnalogPinReference.Comparision.GREATER_THAN : AnalogPinReference.Comparision.LESS_THAN;
    }

    private void applyReachedWaypointNode(UntilNode node) {
        UntilReachedWaypointNode untilReachedWaypointNode = new UntilReachedWaypointNode();
        untilReachedWaypointNode.setParent((com.ur.polyscope.program.nodes.until.UntilNode)node);
        node.setSelectedTypeNode((UntilTypeNode)untilReachedWaypointNode);
    }
}

