/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program.configurations.until;

import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.urcaps.IOImpl;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.urcap.api.domain.io.AnalogIO;
import com.ur.urcap.api.domain.io.FloatRegister;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.io.IOFilterFactory;
import com.ur.urcap.api.domain.io.IOModel;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.CompareOperator;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.BlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.CustomDecelerationParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.DecelerationParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.DistanceUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.IOInputUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.UntilNodeConfig;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.AngularAcceleration;
import com.ur.urcap.api.domain.value.simple.Current;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Voltage;
import com.ur.urcap.domain.expression.ExpressionImpl;
import com.ur.urcap.domain.program.configurations.until.AnalogInputUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.CustomDecelerationParametersImpl;
import com.ur.urcap.domain.program.configurations.until.DecelerationParametersImpl;
import com.ur.urcap.domain.program.configurations.until.DigitalInputUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.DistanceUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.ExpressionUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.FloatRegisterInputUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.IOInputUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.PolyscopeToURCapConverter;
import com.ur.urcap.domain.program.configurations.until.ReachedWaypointUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.ToolContactUntilNodeConfig;
import com.ur.urcap.domain.program.configurations.until.ToolContactUntilNodeConfigImpl;
import com.ur.urcap.domain.program.configurations.until.UntilNodeConfigImpl;
import com.ur.util.Optional;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.types.AnalogPinReference;
import gui.program.until.types.DigitalPinReference;
import gui.program.until.types.UntilContactDetection;
import gui.program.until.types.UntilDistanceNode;
import gui.program.until.types.UntilExpressionNode;
import gui.program.until.types.UntilIONode;

public class UntilNodeConfigExtractor {
    private final PolyscopeToURCapConverter converter;
    private final IOModel ioModel;
    private SimpleValueFactory simpleValueFactory;

    public UntilNodeConfigExtractor(PolyscopeToURCapConverter polyscopeToURCapConverter, SimpleValueFactory simpleValueFactory, IOModel ioModel) {
        this.converter = polyscopeToURCapConverter;
        this.simpleValueFactory = simpleValueFactory;
        this.ioModel = ioModel;
    }

    public UntilNodeConfig extractConfig(UntilNode node) {
        Object config;
        UntilTypeNode type = node.getSelectedTypeNode();
        switch (type.getType()) {
            case EXPRESSION: {
                config = this.extractExpressionNodeConfig(node);
                break;
            }
            case DISTANCE: {
                config = this.extractDistanceNodeConfig(node);
                break;
            }
            case IO: {
                config = this.extractIOConfig(node);
                break;
            }
            case NONE: {
                config = new UntilNodeConfigImpl();
                break;
            }
            case REACHED_WAYPOINT: {
                config = new ReachedWaypointUntilNodeConfigImpl();
                break;
            }
            case TOOL_CONTACT_DETECTION: {
                config = this.extractToolContactConfig(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't get config for unsupported node type " + type);
            }
        }
        return config;
    }

    private ToolContactUntilNodeConfig extractToolContactConfig(UntilNode node) {
        UntilContactDetection type = (UntilContactDetection)node.getSelectedTypeNode();
        return new ToolContactUntilNodeConfigImpl(type.retractOnContact(), type.getUntilDeceleration(), type.getForceThreshold());
    }

    private IOInputUntilNodeConfig extractIOConfig(UntilNode node) {
        UntilIONode type = (UntilIONode)node.getSelectedTypeNode();
        switch (type.getIOType()) {
            case NONE: {
                return this.createUndefinedUntilNodeConfig();
            }
            case ANALOG_INPUT: {
                return this.extractAnalogInput(type);
            }
            case DIGITAL_INPUT: {
                return this.extractDigitalInput(type);
            }
        }
        throw new IllegalArgumentException("Can't get config for unsupported io node type " + type.getIOType());
    }

    private IOInputUntilNodeConfig extractDigitalInput(UntilIONode type) {
        Optional optionalDigitalPinReference = type.getDigitalPinReference();
        if (!optionalDigitalPinReference.isPresent()) {
            return this.createUndefinedUntilNodeConfig();
        }
        DigitalPinReference digitalPinReference = (DigitalPinReference)optionalDigitalPinReference.get();
        Optional optionalPinReference = digitalPinReference.getPinReference();
        if (!optionalPinReference.isPresent()) {
            return this.createUndefinedUntilNodeConfig();
        }
        PinReference pinReference = (PinReference)optionalPinReference.get();
        Pin derefPin = pinReference.dereference();
        IO ioPin = this.getIO(derefPin);
        if (ioPin == null) {
            return new IOInputUntilNodeConfigImpl(digitalPinReference);
        }
        boolean value = digitalPinReference.getValue();
        return new DigitalInputUntilNodeConfigImpl(ioPin, value);
    }

    private IOInputUntilNodeConfigImpl createUndefinedUntilNodeConfig() {
        return new IOInputUntilNodeConfigImpl();
    }

    private IOInputUntilNodeConfig extractAnalogInput(UntilIONode type) {
        Optional optionalAnalogPinReference = type.getAnalogPinReference();
        if (!optionalAnalogPinReference.isPresent()) {
            return this.createUndefinedUntilNodeConfig();
        }
        AnalogPinReference analogPinReference = (AnalogPinReference)optionalAnalogPinReference.get();
        Optional optionalPinReference = analogPinReference.getPinReference();
        if (!optionalPinReference.isPresent()) {
            return this.createUndefinedUntilNodeConfig();
        }
        PinReference pinReference = (PinReference)optionalPinReference.get();
        Pin derefPin = pinReference.dereference();
        IO ioPin = this.getIO(derefPin);
        if (ioPin == null) {
            return new IOInputUntilNodeConfigImpl(analogPinReference);
        }
        AnalogPinReference.Comparision comparison = analogPinReference.getComparision();
        CompareOperator operator = this.getCompareOperator(comparison);
        double value = analogPinReference.getValue();
        if (ioPin instanceof FloatRegister) {
            FloatRegister floatRegister = (FloatRegister)ioPin;
            return new FloatRegisterInputUntilNodeConfigImpl(floatRegister, operator, (float)value);
        }
        if (ioPin instanceof AnalogIO) {
            AnalogIO analogIO = (AnalogIO)ioPin;
            if (analogPinReference.getIsCurrent()) {
                Current current = this.simpleValueFactory.createCurrent(value, Current.Unit.mA);
                return new AnalogInputUntilNodeConfigImpl(analogIO, operator, current);
            }
            Voltage voltage = this.simpleValueFactory.createVoltage(value, Voltage.Unit.V);
            return new AnalogInputUntilNodeConfigImpl(analogIO, operator, voltage);
        }
        return this.createUndefinedUntilNodeConfig();
    }

    private ExpressionUntilNodeConfigImpl extractExpressionNodeConfig(UntilNode node) {
        Object deceleration;
        UntilExpressionNode type = (UntilExpressionNode)node.getSelectedTypeNode();
        UntilDeceleration.Type untilDecelerationType = type.getUntilDeceleration().getType();
        if (untilDecelerationType == UntilDeceleration.Type.SHARED) {
            deceleration = new DecelerationParametersImpl();
        } else {
            UntilDeceleration untilDeceleration = type.getUntilDeceleration();
            Acceleration cartesianDeceleration = untilDeceleration.getCartesianDeceleration();
            double accelerationValue = cartesianDeceleration.getIn(Acceleration.Unit.SI);
            com.ur.urcap.api.domain.value.simple.Acceleration decelerationAcceleration = this.simpleValueFactory.createAcceleration(accelerationValue, Acceleration.Unit.M_S2);
            com.ur.polyscope.valueobjects.AngularAcceleration angularDeceleration = untilDeceleration.getAngularDeceleration();
            double angularAccelerationValue = angularDeceleration.getIn(AngularAcceleration.Unit.SI);
            AngularAcceleration decelerationAngularAcceleration = this.simpleValueFactory.createAngularAcceleration(angularAccelerationValue, AngularAcceleration.Unit.RAD_S2);
            deceleration = node.isCartesianMovement() ? new CustomDecelerationParametersImpl(decelerationAngularAcceleration, decelerationAcceleration, CustomDecelerationParameters.Type.Cartesian) : new CustomDecelerationParametersImpl(decelerationAngularAcceleration, decelerationAcceleration, CustomDecelerationParameters.Type.Angular);
        }
        ExpressionBranchNode expressionBranchNode = type.getExpression();
        ExpressionImpl expression = new ExpressionImpl(expressionBranchNode);
        return new ExpressionUntilNodeConfigImpl((DecelerationParameters)deceleration, expression);
    }

    private DistanceUntilNodeConfig extractDistanceNodeConfig(UntilNode node) {
        UntilDistanceNode type = (UntilDistanceNode)node.getSelectedTypeNode();
        BlendParameters blend = this.converter.convertBlendToBlendParameters((Optional<Length>)(type.getNodeType() == UntilDistanceNode.DistanceNodeType.STOP ? Optional.empty() : Optional.of((Object)type.getBlendRadius())));
        com.ur.urcap.api.domain.value.simple.Length length = this.simpleValueFactory.createLength(type.getDistance().getIn(Length.Unit.M), Length.Unit.M);
        return new DistanceUntilNodeConfigImpl(length, blend);
    }

    private CompareOperator getCompareOperator(AnalogPinReference.Comparision analogComparison) {
        if (analogComparison == AnalogPinReference.Comparision.GREATER_THAN) {
            return CompareOperator.GREATER_THAN;
        }
        return CompareOperator.LESS_THAN;
    }

    private IO getIO(Pin<?> input) {
        if (this.ioModel != null) {
            for (IO io : this.ioModel.getIOs(IOFilterFactory.inputFilter())) {
                if (!((IOImpl)io).getIOPin().equals(input)) continue;
                return io;
            }
        }
        return null;
    }
}

