/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program.configurations.until.validation;

import com.ur.polyscope.valueobjects.validation.ValidationResult;
import com.ur.polyscope.valueobjects.validation.Validator;
import com.ur.urcap.api.domain.validation.ErrorHandler;

public abstract class AbstractUnitValidator<V, T> {
    private static final int MAX_RECURSIVE_ERROR_HANDLER_CALLS = 100;
    private final Validator<T> validator;

    public AbstractUnitValidator(Validator<T> validator) {
        this.validator = validator;
    }

    protected abstract T asValidatorValue(V var1);

    protected abstract V asUnitValue(T var1);

    public V getValidValue(V uncheckedValue, ErrorHandler<V> errorHandler) {
        V resultValue = uncheckedValue;
        ValidationResult validationResult = this.validator.validate(this.asValidatorValue(uncheckedValue));
        if (validationResult.isValid()) {
            return resultValue;
        }
        resultValue = errorHandler != null ? this.handlerError(uncheckedValue, errorHandler) : this.asUnitValue(validationResult.validValue());
        return resultValue;
    }

    private V handlerError(V value, ErrorHandler<V> errorHandler) {
        boolean isValid = false;
        int triedTimes = 0;
        while (triedTimes < 100) {
            ValidationResult validationResult = this.validator.validate(this.asValidatorValue(value));
            if (validationResult.isValid()) {
                isValid = true;
                break;
            }
            V nearestValidValue = this.asUnitValue(validationResult.validValue());
            value = errorHandler.onError(value, nearestValidValue, validationResult.errorMessage());
            ++triedTimes;
        }
        if (!isValid) {
            throw new IllegalStateException("Too many recursive calls to error handler without valid value returned!");
        }
        return value;
    }
}

