/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program.configurations.until.validation;

import com.ur.polyscope.program.nodes.move.MoveNodeValidators;
import com.ur.polyscope.valueobjects.validation.ValidationResult;
import com.ur.polyscope.valueobjects.validation.Validator;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.domain.program.configurations.until.validation.AccelerationInMS2Validator;
import com.ur.urcap.domain.program.configurations.until.validation.AngularAccelerationInDegS2Validator;
import com.ur.urcap.domain.program.configurations.until.validation.DistanceValidatorInMM;
import javax.inject.Inject;
import javax.inject.Provider;

public class UntilNodeValidators {
    private final SimpleValueFactory simpleValueFactory;
    private final Provider<MoveNodeValidators> moveNodeValidatorsProvider;

    @Inject
    public UntilNodeValidators(SimpleValueFactory simpleValueFactory, Provider<MoveNodeValidators> moveNodeValidatorsProvider) {
        this.simpleValueFactory = simpleValueFactory;
        this.moveNodeValidatorsProvider = moveNodeValidatorsProvider;
    }

    public AngularAccelerationInDegS2Validator getAngularDecelerationValidator() {
        MoveNodeValidators validators = (MoveNodeValidators)this.moveNodeValidatorsProvider.get();
        return new AngularAccelerationInDegS2Validator(this.simpleValueFactory, (Validator<Double>)validators.getJointAccelerationLimitValidator());
    }

    public AccelerationInMS2Validator getCartesianDecelerationValidator() {
        MoveNodeValidators validators = (MoveNodeValidators)this.moveNodeValidatorsProvider.get();
        return new AccelerationInMS2Validator(this.simpleValueFactory, (Validator<Double>)validators.getCartesianJointAccelerationLimitValidator());
    }

    public DistanceValidatorInMM getDistanceValidator() {
        Validator<Double> validator = new Validator<Double>(){

            public ValidationResult<Double> validate(final Double aDouble) {
                return new ValidationResult<Double>(){

                    public boolean isValid() {
                        return aDouble > 0.0;
                    }

                    public String errorMessage() {
                        if (this.isValid()) {
                            return "";
                        }
                        return "Distance should be greater than 0 mm";
                    }

                    public Double validValue() {
                        if (this.isValid()) {
                            return aDouble;
                        }
                        return 1.0;
                    }
                };
            }
        };
        return new DistanceValidatorInMM(this.simpleValueFactory, validator);
    }
}

