/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.program.visitors;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.ProgramNodeVisitor;
import com.ur.polyscope.program.nodes.waypoint.WaypointNode;
import gui.tools.LanguagePack;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramNodeAddedVisitor
extends ProgramNodeVisitor {
    private final NamingService namingService;

    @Inject
    public ProgramNodeAddedVisitor(NamingService namingService) {
        this.namingService = namingService;
    }

    public void visit(WaypointNode node) {
        gui.program.position.WaypointNode waypointNode = (gui.program.position.WaypointNode)node;
        String oldName = waypointNode.getName();
        String newName = waypointNode.getName();
        if (this.isDefaultWaypointName(oldName)) {
            newName = this.namingService.makeUniqueName(gui.program.position.WaypointNode.class, gui.program.position.WaypointNode.DEFAULT_NAME);
        } else if (this.isDefaultCircularViaName(oldName)) {
            newName = this.namingService.makeUniqueName(gui.program.position.WaypointNode.class, LanguagePack.getDefaultViaPointName());
        } else if (this.isDefaultCircularEndName(oldName)) {
            newName = this.namingService.makeUniqueName(gui.program.position.WaypointNode.class, LanguagePack.getDefaultEndPointName());
        }
        this.namingService.setNameOfEntity((NamedEntity)waypointNode, newName);
        if (waypointNode.getWaypointPoseInFeatureCoordinates() == null) {
            waypointNode.recalculatePoseInFeatureSpace();
        }
    }

    private boolean isDefaultWaypointName(String waypointNodeName) {
        return gui.program.position.WaypointNode.DEFAULT_NAME.equals(waypointNodeName);
    }

    private boolean isDefaultCircularViaName(String waypointNodeName) {
        return LanguagePack.getDefaultViaPointName().equals(waypointNodeName);
    }

    private boolean isDefaultCircularEndName(String waypointNodeName) {
        return LanguagePack.getDefaultEndPointName().equals(waypointNodeName);
    }
}

