/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.userinteraction;

import com.ur.lang.DecimalFormatFactory;
import com.ur.swing.api.input.UserInput;
import com.ur.swing.api.input.UserInputType;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.urcap.domain.userinteraction.AbstractKeyboardNumberInput;
import com.ur.urcap.domain.validation.DoubleValidatorAdapter;
import java.text.DecimalFormat;

public class DoubleKeyboardInput
extends AbstractKeyboardNumberInput<Double> {
    private static final int MAXIMUM_FRACTION_DIGITS = 8;

    public DoubleKeyboardInput(ExceptionHandling exceptionHandling, InputValidator<String> defaultValidator, UserInput userInput, UserInputType type) {
        super(exceptionHandling, defaultValidator, userInput, type);
    }

    @Override
    protected InputValidator<String> adaptValidator(InputValidator<Double> validator) {
        return new DoubleValidatorAdapter(validator);
    }

    @Override
    protected String prepareInitialValue(Double initialValue) {
        if (initialValue == null) {
            return null;
        }
        DecimalFormat df = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#");
        df.setMaximumFractionDigits(8);
        return df.format(initialValue);
    }

    @Override
    protected Double valueOf(String userInputValue) {
        return DoubleValidatorAdapter.valueOf(userInputValue);
    }
}

