/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.userinteraction;

import com.ur.lang.StringUtils;
import com.ur.polyscope.urcaps.userinteraction.keyboard.KeyboardExpressionInput;
import com.ur.polyscope.valueobjects.aspects.NotNullArgumentAspect;
import com.ur.polyscope.valueobjects.validation.NotNull;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.ExpressionValidator;
import com.ur.swing.expression.field.ExpressionContentProvider;
import com.ur.swing.expression.field.ExpressionHolder;
import com.ur.swing.expression.field.ExpressionInserter;
import com.ur.swing.expression.field.ExpressionPicker;
import com.ur.swing.i18n.TextResource;
import com.ur.swing.number.OnEditListener;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.domain.expression.ExpressionImpl;
import com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl$AjcClosure1;
import com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl$AjcClosure3;
import com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl$AjcClosure5;
import com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl$AjcClosure7;
import java.awt.Color;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class KeyboardExpressionInputImpl
implements KeyboardExpressionInput {
    private final ExpressionInserter expressionInserter;
    private final TextResource textResource;
    private ExpressionContentProvider contentProvider;
    private ExpressionBranchNode nodeBranch = new ExpressionBranchNode();
    private ExpressionPicker expressionPicker = null;
    private long timeToWaitAfterClose = System.currentTimeMillis();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Inject
    public KeyboardExpressionInputImpl(ExpressionContentProvider contentProvider, ExpressionInserter expressionInserter, TextResource textResource) {
        this.contentProvider = contentProvider;
        this.expressionInserter = expressionInserter;
        this.textResource = textResource;
    }

    public KeyboardExpressionInput setInitialValue(Expression initialValue) {
        this.nodeBranch = ((ExpressionImpl)initialValue).getExpressionBranchNode();
        return this;
    }

    public KeyboardExpressionInput setInitialValue(String initialText) {
        this.nodeBranch = new ExpressionBranchNode(initialText);
        return this;
    }

    public void show(@NotNull JTextField component, @NotNull KeyboardInputCallback<Expression> callback) {
        JTextField jTextField = component;
        KeyboardInputCallback<Expression> keyboardInputCallback = callback;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jTextField, keyboardInputCallback);
        Object[] objectArray = new Object[]{this, jTextField, keyboardInputCallback, joinPoint};
        KeyboardExpressionInputImpl$AjcClosure1 keyboardExpressionInputImpl$AjcClosure1 = new KeyboardExpressionInputImpl$AjcClosure1(objectArray);
        NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(keyboardExpressionInputImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void show(@NotNull JButton component, @NotNull KeyboardInputCallback<Expression> callback) {
        JButton jButton = component;
        KeyboardInputCallback<Expression> keyboardInputCallback = callback;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)jButton, keyboardInputCallback);
        Object[] objectArray = new Object[]{this, jButton, keyboardInputCallback, joinPoint};
        KeyboardExpressionInputImpl$AjcClosure3 keyboardExpressionInputImpl$AjcClosure3 = new KeyboardExpressionInputImpl$AjcClosure3(objectArray);
        NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(keyboardExpressionInputImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public void show(@NotNull JLabel component, @NotNull KeyboardInputCallback<Expression> callback) {
        JLabel jLabel = component;
        KeyboardInputCallback<Expression> keyboardInputCallback = callback;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)jLabel, keyboardInputCallback);
        Object[] objectArray = new Object[]{this, jLabel, keyboardInputCallback, joinPoint};
        KeyboardExpressionInputImpl$AjcClosure5 keyboardExpressionInputImpl$AjcClosure5 = new KeyboardExpressionInputImpl$AjcClosure5(objectArray);
        NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(keyboardExpressionInputImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    private void showKeyboard(@NotNull JComponent component, @NotNull KeyboardInputCallback<Expression> callback) {
        JComponent jComponent = component;
        KeyboardInputCallback<Expression> keyboardInputCallback = callback;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)jComponent, keyboardInputCallback);
        Object[] objectArray = new Object[]{this, jComponent, keyboardInputCallback, joinPoint};
        KeyboardExpressionInputImpl$AjcClosure7 keyboardExpressionInputImpl$AjcClosure7 = new KeyboardExpressionInputImpl$AjcClosure7(objectArray);
        NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(keyboardExpressionInputImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    private Expression generateExpression() {
        return new ExpressionImpl(this.nodeBranch);
    }

    private String generateText() {
        StringBuffer s = new StringBuffer();
        this.nodeBranch.generateText(s);
        return s.toString();
    }

    private void updateInputTextField(JComponent component) {
        String setText;
        String text = this.generateText();
        boolean hasNoExpressionText = this.hasNoExpression(text);
        String string = setText = hasNoExpressionText ? "f(x)" : text;
        if (component instanceof JTextField) {
            ((JTextField)component).setText(setText);
        }
        if (component instanceof JLabel) {
            ((JLabel)component).setText(setText);
        }
        if (component instanceof JButton) {
            ((JButton)component).setText(setText);
        }
        component.setForeground(hasNoExpressionText ? Color.LIGHT_GRAY : Color.BLACK);
        component.setBackground(component.isEnabled() && (hasNoExpressionText || this.nodeBranch.isUndefined()) ? DisplayMessageFactory.WARNING_COLOR : Color.WHITE);
    }

    private boolean hasNoExpression(String text) {
        return StringUtils.isNullOrOnlyWhitespace((String)text);
    }

    private ExpressionHolder getExpressionHolder(final JComponent component) {
        return new ExpressionHolder(){

            public ExpressionBranchNode getExpression() {
                if (KeyboardExpressionInputImpl.this.nodeBranch != null) {
                    return KeyboardExpressionInputImpl.this.nodeBranch.clone();
                }
                return new ExpressionBranchNode();
            }

            public void setExpression(ExpressionBranchNode expression) {
                KeyboardExpressionInputImpl.this.nodeBranch = expression;
                if (component instanceof JTextField) {
                    ((JTextField)component).postActionEvent();
                }
            }
        };
    }

    static {
        KeyboardExpressionInputImpl.ajc$preClinit();
    }

    static final /* synthetic */ void show_aroundBody0(KeyboardExpressionInputImpl ajc$this, JTextField component, KeyboardInputCallback callback, JoinPoint joinPoint) {
        ajc$this.showKeyboard(component, (KeyboardInputCallback<Expression>)callback);
    }

    static final /* synthetic */ void show_aroundBody2(KeyboardExpressionInputImpl ajc$this, JButton component, KeyboardInputCallback callback, JoinPoint joinPoint) {
        ajc$this.showKeyboard(component, (KeyboardInputCallback<Expression>)callback);
    }

    static final /* synthetic */ void show_aroundBody4(KeyboardExpressionInputImpl ajc$this, JLabel component, KeyboardInputCallback callback, JoinPoint joinPoint) {
        ajc$this.showKeyboard(component, (KeyboardInputCallback<Expression>)callback);
    }

    static final /* synthetic */ void showKeyboard_aroundBody6(KeyboardExpressionInputImpl ajc$this, final JComponent component, final KeyboardInputCallback callback, JoinPoint joinPoint) {
        if (!component.isVisible()) {
            return;
        }
        if (ajc$this.expressionPicker == null && ajc$this.timeToWaitAfterClose < System.currentTimeMillis()) {
            component.setBackground(UIManager.getColor("textHighlight"));
            OnEditListener[] onEditListenerArray = (OnEditListener[])component.getListeners(OnEditListener.class);
            int n = onEditListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                OnEditListener each = onEditListenerArray[n2];
                each.requestEdit();
                ++n2;
            }
            ajc$this.expressionPicker = new ExpressionPicker(ajc$this.getExpressionHolder(component), ajc$this.contentProvider, ajc$this.expressionInserter, (ExpressionValidator)ajc$this.expressionInserter, ajc$this.textResource);
            ajc$this.expressionPicker.addCloseListener(new CloseListener(){

                public void onClose() {
                    KeyboardExpressionInputImpl.this.expressionPicker = null;
                    KeyboardExpressionInputImpl.this.timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                    KeyboardExpressionInputImpl.this.updateInputTextField(component);
                    KeyboardExpressionInputImpl.this.nodeBranch = new ExpressionBranchNode();
                }
            });
            ajc$this.expressionPicker.addCompletedListener(new CompletedListener(){

                public void requestApply() {
                    callback.onOk((Object)KeyboardExpressionInputImpl.this.generateExpression());
                }

                public void requestCancel() {
                    callback.onCancel();
                }
            });
            int position = component.getLocationOnScreen().y + component.getHeight();
            ajc$this.expressionPicker.showInputPanelAt(component, position);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KeyboardExpressionInputImpl.java", KeyboardExpressionInputImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "show", "com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl", "javax.swing.JTextField:com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback", "component:callback", "", "void"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "show", "com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl", "javax.swing.JButton:com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback", "component:callback", "", "void"), 67);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "show", "com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl", "javax.swing.JLabel:com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback", "component:callback", "", "void"), 73);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "showKeyboard", "com.ur.urcap.domain.userinteraction.KeyboardExpressionInputImpl", "javax.swing.JComponent:com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback", "component:callback", "", "void"), 78);
    }
}

