/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.userinteraction;

import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.contribution.ExceptionHandling;
import com.ur.util.logging.Log;

class KeyboardValidationStrategy
implements ValidationStrategy {
    private final ExceptionHandling exceptionHandling;
    private InputValidator<String> validator = null;

    KeyboardValidationStrategy(ExceptionHandling exceptionHandling) {
        this.exceptionHandling = exceptionHandling;
    }

    public boolean isValid(String uncheckedString) {
        if (this.validator == null) {
            return true;
        }
        try {
            return this.validator.isValid((Object)uncheckedString);
        }
        catch (Throwable t) {
            Log.error((String)("Error in " + KeyboardValidationStrategy.getClassName(this.validator) + ".isValid()"), (Throwable)t);
            this.showExceptionDialog(t, this.validator);
            return false;
        }
    }

    public String getErrorMessage(String uncheckedString) {
        if (uncheckedString == null || uncheckedString.length() == 0) {
            return "";
        }
        if (this.validator == null) {
            return "";
        }
        try {
            return this.validator.getMessage((Object)uncheckedString);
        }
        catch (Throwable t) {
            Log.error((String)("Error in " + KeyboardValidationStrategy.getClassName(this.validator) + ".getMessage()"), (Throwable)t);
            this.showExceptionDialog(t, this.validator);
            return "Error in KeyboardInputCallback.onOk";
        }
    }

    private void showExceptionDialog(Throwable t, InputValidator validator) {
        this.exceptionHandling.showURCapExceptionDialog(t, Thread.currentThread().getStackTrace()[1], validator.getClass());
    }

    private static String getClassName(InputValidator validator) {
        String simpleName = validator.getClass().getSimpleName();
        simpleName = simpleName.isEmpty() ? "Validator" : simpleName;
        return simpleName;
    }

    public void setValidator(InputValidator<String> validator) {
        this.validator = validator;
    }
}

