/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.domain.value;

import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.urcap.api.domain.validation.ErrorHandler;

public class ValidatedValue<V> {
    private final AutoCorrectionValidator validator;
    public static final int MAX_RECURSIVE_ERROR_HANDLER_CALLS = 100;

    public ValidatedValue(AutoCorrectionValidator validator) {
        this.validator = validator;
    }

    public V getValidValue(V uncheckedValue, ErrorHandler errorHandler) {
        if (this.validator.isValid(this.getStringValue(uncheckedValue))) {
            return uncheckedValue;
        }
        return this.handledError(uncheckedValue, errorHandler);
    }

    String getStringValue(V value) {
        return value instanceof NumberValue ? String.valueOf(((NumberValue)value).asDouble()) : String.valueOf(value);
    }

    private V handledError(V value, ErrorHandler errorHandler) {
        if (errorHandler == null) {
            return this.getNearestValidValue(value);
        }
        return this.getValidValueFromErrorHandler(value, errorHandler);
    }

    private V getValidValueFromErrorHandler(V uncheckedValue, ErrorHandler<V> errorHandler) {
        boolean isValid = false;
        int triedTimes = 0;
        while (!isValid && triedTimes++ < 100) {
            V nearestValidValue = this.getNearestValidValue(uncheckedValue);
            uncheckedValue = errorHandler.onError(uncheckedValue, nearestValidValue, this.validator.getErrorMessage(this.getStringValue(uncheckedValue)));
            isValid = this.validator.isValid(this.getStringValue(uncheckedValue));
        }
        if (!isValid) {
            throw new RuntimeException("Too many recursive calls to error handler without valid value returned!");
        }
        return uncheckedValue;
    }

    private V getNearestValidValue(V value) {
        if (value == null) {
            return null;
        }
        String stringValue = this.getStringValue(value);
        String nearestValue = this.validator.getNearestValidValue(stringValue);
        if (value instanceof String) {
            return (V)nearestValue;
        }
        if (value instanceof Integer) {
            return (V)new Integer(nearestValue);
        }
        if (value instanceof Long) {
            return (V)new Long(nearestValue);
        }
        if (value instanceof Float) {
            return (V)new Float(nearestValue);
        }
        if (value instanceof Double) {
            return (V)new Double(nearestValue);
        }
        if (value instanceof NumberValue) {
            return this.createNewInstance((NumberValue)value, nearestValue);
        }
        throw new ClassCastException("Unsupported class: " + value.getClass());
    }

    V createNewInstance(NumberValue value, String newValue) {
        return (V)newValue;
    }

    public AutoCorrectionValidator getValidator() {
        return this.validator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValidatedValue{");
        sb.append('}');
        return sb.toString();
    }
}

